/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.update;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.update.UpdateOutputProcessor;
import com.dataiku.dip.dataflow.exec.update.UpdateRecipeParams;
import com.dataiku.dip.dataflow.exec.update.UpdateRecipeSchemaComputer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.InlineDataOutput;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateRecipeRunner
implements FlowRunnable,
RecipeRunner {
    @Autowired
    private JobAuthCtxService authCtxService;
    private final JobActivity activity;
    private final RecipeRunnableSubgraph subgraph;
    private final FlowRecipe recipe;
    private DatasetsDAO datasetsDAO;
    protected Dataset inputDS;
    protected Dataset outputDS;
    protected FlowDataset inputFD;
    protected FlowDataset outputFD;
    protected UpdateRecipeParams params;
    private MemTable previousContent;
    private MemTable previousChanges;
    InlineDatasetHandler outputDatasetHandler;
    static Logger logger = Logger.getLogger((String)"dku.flow.update");

    public UpdateRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        this.activity.initStatus();
    }

    @Autowired
    public void setDatasetsDAO(DatasetsDAO dao) {
        this.datasetsDAO = dao;
    }

    @Override
    public void init() throws Exception {
        this.recipe.validateExactly1Source();
        this.recipe.validateExactly1Target();
        new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        this.activity.setStatusMessage("Initializing");
        this.inputFD = GraphUtils.getSingleSource(this.subgraph.getRecipe());
        this.outputFD = GraphUtils.getSingleTarget(this.subgraph.getRecipe());
        this.inputDS = this.inputFD.getMandatory(this.datasetsDAO);
        this.outputDS = this.outputFD.getMandatory(this.datasetsDAO);
        SerializedRecipe.RecipeOutput recipeOutput = this.subgraph.getRecipe().getModel().getSingleOutput("main");
        Output.WriteMode writeMode = recipeOutput.getWriteMode();
        if (writeMode != null && writeMode != Output.WriteMode.OVERWRITE) {
            logger.warn((Object)("Recipe only supports OVERWRITE writeMode (" + String.valueOf(writeMode) + " requested)"));
        }
        DatasetHandler odh = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), this.outputDS);
        this.outputDatasetHandler = (InlineDatasetHandler)odh;
        this.previousContent = this.outputDatasetHandler.getDataAsMemTable();
        this.previousChanges = this.outputDatasetHandler.getChangesAsMemTable();
        logger.info((Object)("CONTENT : " + String.valueOf(this.previousContent == null || this.previousContent.rows == null ? "null" : Integer.valueOf(this.previousContent.rows.size()))));
        logger.info((Object)("CHANGES : " + String.valueOf(this.previousChanges == null || this.previousChanges.rows == null ? "null" : Integer.valueOf(this.previousChanges.rows.size()))));
        this.outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{this.activity.getSubgraph().getTargetPartition(this.outputFD)}));
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.params = RecipeRegistry.getParamsAs(this.activity, UpdateRecipeParams.class);
        if (this.params == null) {
            throw new IllegalArgumentException("Empty recipe params");
        }
    }

    @Override
    public void run() throws Exception {
        assert (this.params != null);
        this.activity.setStatusMessage("Updating output");
        StreamableDatasetSelection dataSelection = StreamableDatasetSelection.full();
        if (this.inputDS.getPartitioningSchema().isPartitioned()) {
            dataSelection.withSelectedPartitions(this.activity.getSubgraph().getSourcePartitions(this.inputFD));
        }
        if (FilterDescUtils.willFilter(this.params.filter)) {
            dataSelection.filter = this.params.filter;
        }
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        Partition targetPartition = this.activity.getSubgraph().getTargetPartition(this.outputFD);
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        InlineDataOutput mainOutput = this.outputDatasetHandler.buildOutput(targetPartition, 0, 8, this.activity.warnContext);
        mainOutput.setSchema(new UpdateRecipeSchemaComputer(authCtx, this.activity).getSchema());
        InlineDataOutput changesOutput = this.outputDatasetHandler.buildChangesOutput(targetPartition, 0, 8, this.activity.warnContext);
        UpdateOutputProcessor out = new UpdateOutputProcessor(mainOutput, changesOutput, this.previousContent, this.previousChanges, (ColumnFactory)cf, (RowFactory)rf, this.params);
        UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(authCtx, this.inputDS, out, (ColumnFactory)cf, (RowFactory)rf);
        pusher.setWarningsContext(this.activity.warnContext);
        pusher.setDatasetSelection(dataSelection);
        pusher.push();
        out.lastRowEmitted();
        this.outputDatasetHandler.close();
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }
}

