/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeRunner;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeSingleOutputRunner;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineElement;
import com.dataiku.dip.dataflow.pipeline.VisualSqlRecipePipelineHelper;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryJobDefBuilder;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JoinRecipePipelineHelper
extends VisualSqlRecipePipelineHelper {
    private JoinRecipeHelper joinHelper;
    private JoinRecipePayloadParams params;

    public JoinRecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, JobActivity jobActivity) {
        super(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    protected void parseParams() {
        this.joinHelper = new JoinRecipeHelper();
        this.params = this.joinHelper.loadParams(this.payload, this.recipe);
        this.engineParams = this.params.engineParams;
    }

    @Override
    protected void finalizeElt(SparkPipelineDef.SparkPipelineElt elt, JobActivity activity, SparkSQLDialect dialect, ResourcesGatherer gatherer) throws Exception {
        elt.type = "spark_sql_query";
        SparkSQLQueryJobDefBuilder builder = new SparkSQLQueryJobDefBuilder(activity);
        Map<String, String> queriesByOutputFullName = this.generateSqlQueries(activity, dialect).stream().collect(Collectors.toMap(sqlPipelineElement -> sqlPipelineElement.targetFlowDataset.getFullName(), sqlPipelineElement -> sqlPipelineElement.sqlQuery));
        elt.sparkSQL = builder.buildJobDef(queriesByOutputFullName, this.sparkSqlParams.overwriteOutputSchema, false, this.sparkSqlParams.readParams);
    }

    @Override
    List<SqlPipelineElement> generateSqlQueries(JobActivity activity, SQLDialect dialect) throws Exception {
        this.joinHelper.initInputDatasets(activity, this.params, false, dialect, false);
        JoinRecipeRunner runner = new JoinRecipeRunner(activity);
        runner.setPayload(this.payload);
        ArrayList<SqlPipelineElement> pipelines = new ArrayList<SqlPipelineElement>();
        for (JoinRecipeSingleOutputRunner nestedRunner : runner.getNestedRunners()) {
            pipelines.add(new SqlPipelineElement(nestedRunner.getActivity(), nestedRunner.generateSQL(dialect)));
        }
        return pipelines;
    }

    @Override
    VisualSQLRecipePayloadParams getParams() {
        return this.params;
    }
}

