/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.VisualSqlRecipePipelineHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.TopNRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class TopNRecipePipelineHelper
extends VisualSqlRecipePipelineHelper {
    @Autowired
    private TopNRecipeService topnService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    private TopNRecipePayloadParams params;

    public TopNRecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, JobActivity jobActivity) {
        super(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    protected void assertConfiguration() {
        assert (this.isValidConfiguration());
    }

    @Override
    protected void parseParams() {
        this.params = this.topnService.loadParams(this.payload, this.recipe);
        this.engineParams = this.params.engineParams;
    }

    @Override
    protected String generateSqlQuery(JobActivity activity, SQLDialect dialect) throws Exception {
        List<SerializedRecipe.RecipeInput> inputList = this.recipe.getInputsForRole("main");
        assert (inputList.size() == 1);
        FlowRecipe fr = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        Dataset inputDS = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(inputList.get(0).getLoc(this.recipe.getProjectKey())));
        return this.topnService.generateSQL(activity, fr, dialect, inputDS, this.params, "main", true);
    }

    @Override
    protected boolean isValidConfiguration() {
        return super.isValidConfiguration() && this.isSingleInputAndOuput();
    }

    @Override
    VisualSQLRecipePayloadParams getParams() {
        return this.params;
    }

    private boolean isSingleInputAndOuput() {
        return this.recipe.getFlatInputs().size() == 1 && this.recipe.getFlatOutputs().size() == 1;
    }
}

