/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.SqlPipelineRecipeParams;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLExecutor;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryJobDefBuilder;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.utils.JSON;
import org.apache.commons.lang.StringUtils;

public abstract class VisualSqlRecipePipelineHelper
extends RecipePipelineHelper {
    VisualSQLRecipeEngineParams engineParams;
    SparkSQLExecutor.SparkSQLExecutorParams sparkSqlParams;
    private SqlPipelineRecipeParams sqlPipelineParams;
    protected String engineType;

    VisualSqlRecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, JobActivity jobActivity) {
        super(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    protected void initialize(JobActivity jobActivity) {
        SpringUtils.getInstance().autowire((Object)this);
        this.parseParams();
        this.setEngineType();
    }

    @Override
    protected void initializeForSpark() {
        this.sparkSqlParams = this.engineParams.sparkSQL;
        this.allowPipelineStart = this.sparkSqlParams.pipelineAllowStart;
        this.allowPipelineMerge = this.sparkSqlParams.pipelineAllowMerge;
    }

    @Override
    protected void initializeForSql() {
        this.sqlPipelineParams = this.engineParams.sqlPipelineParams;
        this.allowPipelineStart = this.sqlPipelineParams.pipelineAllowStart;
        this.allowPipelineMerge = this.sqlPipelineParams.pipelineAllowMerge;
    }

    protected abstract void parseParams();

    protected void setEngineType() {
        this.engineType = this.engineType();
    }

    @Override
    protected void finalizeElt(SparkPipelineDef.SparkPipelineElt elt, JobActivity activity, SparkSQLDialect dialect, ResourcesGatherer gatherer) throws Exception {
        elt.type = "spark_sql_query";
        SparkSQLQueryJobDefBuilder builder = new SparkSQLQueryJobDefBuilder(activity);
        elt.sparkSQL = builder.buildJobDef(this.generateSqlQuery(activity, dialect), this.sparkSqlParams.overwriteOutputSchema, false, this.sparkSqlParams.readParams);
    }

    @Override
    protected String getEngineType() {
        return this.engineType;
    }

    @Override
    protected boolean isValidConfiguration() {
        return RecipePipelineHelper.PipelineType.SQL.equals((Object)this.pipelineType) || StringUtils.isBlank((String)this.sparkSqlParams.preQueries);
    }

    @Override
    protected boolean useGlobalMetastore() {
        return this.sparkSqlParams.useGlobalMetastore;
    }

    @Override
    protected SparkOverrideConfig sparkConfig() {
        return this.sparkSqlParams.sparkConfig;
    }

    @Override
    protected AbstractSparkRecipeParams.SparkExecutionEngine sparkExecutionEngine() {
        return this.sparkSqlParams.executionEngine;
    }

    abstract VisualSQLRecipePayloadParams getParams();

    protected String getUpdatedPayload() {
        return JSON.pretty((Object)this.getParams());
    }

    @Override
    String setSparkPipelineability(boolean allowStart, boolean allowMerge) {
        this.sparkSqlParams.pipelineAllowStart = allowStart;
        this.sparkSqlParams.pipelineAllowMerge = allowMerge;
        return this.getUpdatedPayload();
    }

    @Override
    String setSqlPipelineability(boolean allowStart, boolean allowMerge) {
        this.sqlPipelineParams.pipelineAllowStart = allowStart;
        this.sqlPipelineParams.pipelineAllowMerge = allowMerge;
        return this.getUpdatedPayload();
    }
}

