/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.refactoring;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.mec.MECPaths;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetRenameService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.datasets.FileUploadService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsSaveService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowCopyService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private LabelingTasksDAO labelingtasksDAO;
    @Autowired
    private ManagedFolderDAO managedFoldersDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private TaggableObjectsSaveService taggableObjectsSaveService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private FlowGraphService graphService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.flow.subflowCopy");

    public CopySubflowTestResponse startCopySubflow(Set<TaggableObjectsService.TaggableObjectRef> topCopy, AuthCtx authCtx) {
        CopySubflowTestResponse results = new CopySubflowTestResponse();
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopySubflowTestResponse testCopySubflow_NT(Set<TaggableObjectsService.TaggableObjectRef> toCopy, String originProjectKey, CopySubflowOptions options, AuthCtx authCtx) throws Exception {
        CopySubflowResponse resp;
        Map<Object, Object> datasetsToCheck = Collections.emptyMap();
        try (RWTransaction t = this.transactionService.beginNonCommittableWriteAsLoggedInUser(authCtx);){
            resp = this.copySubflow(toCopy, options, authCtx);
            if (options.targetMode == TargetMode.NEW_PROJECT) {
                datasetsToCheck = this.getDatasetsToCheck(authCtx, resp);
            }
        }
        if (options.targetMode != TargetMode.NEW_PROJECT) {
            datasetsToCheck = this.getDatasetsToCheck(authCtx, resp);
        }
        CopySubflowTestResponse results = new CopySubflowTestResponse();
        try {
            for (Map.Entry<Object, Object> entry : datasetsToCheck.entrySet()) {
                SerializedDataset dsModel = ((Dataset)entry.getKey()).getModel();
                DatasetTestHandler testHandler = (DatasetTestHandler)entry.getValue();
                logger.info((Object)String.format("Checking name safety for dataset name: %s", dsModel.getFullId()));
                InfoMessage.InfoMessages messages = testHandler.checkManagedDatasetNameSafety(dsModel.name);
                results.mergeFrom(messages);
            }
        }
        finally {
            this.closeDatasetTestHandlersNoFail(datasetsToCheck.values());
        }
        return results;
    }

    public CopySubflowResponse copySubflow(Set<TaggableObjectsService.TaggableObjectRef> toCopy, CopySubflowOptions options, AuthCtx authCtx) throws Exception {
        TaggableObjectsService.TaggableObject copy;
        TaggableObjectsService.TaggableObject original;
        assert (options.targetMode != TargetMode.CURRENT_PROJECT);
        if (options.targetMode == TargetMode.NEW_PROJECT) {
            logger.info((Object)("Create project for copy: " + options.targetProjectKey));
            this.projectsService.create(options.targetProjectKey, options.targetProjectName, options.targetProjectFolderId);
        }
        logger.info((Object)("Copy subflow with " + toCopy.size() + " items. Mode: " + String.valueOf((Object)options.targetMode)));
        CopySubflowResponse ret = new CopySubflowResponse();
        Map<Boolean, List<TaggableObjectsService.TaggableObjectRef>> refsByComputability = toCopy.stream().collect(Collectors.partitioningBy(ref -> FlowComputable.FCType.isFlowComputable(ref.type)));
        List<TaggableObjectsService.TaggableObjectRef> computableRefs = refsByComputability.get(true);
        List<TaggableObjectsService.TaggableObjectRef> nonComputableRefs = refsByComputability.get(false);
        Map<Boolean, List<TaggableObjectsService.TaggableObjectRef>> computableRefsByLocality = computableRefs.stream().collect(Collectors.partitioningBy(ref -> ref.projectKey.equals(ref.getLoc().resolved().getProjectKey())));
        List foreignComputableRefs = computableRefsByLocality.getOrDefault(false, Collections.emptyList());
        List localComputableRefs = computableRefsByLocality.getOrDefault(true, Collections.emptyList());
        Map<ITaggingService.TaggableType, List<TaggableObjectsService.TaggableObjectRef>> nonComputableRefsPerType = nonComputableRefs.stream().collect(Collectors.groupingBy(ref -> ref.type));
        List recipeRefs = nonComputableRefsPerType.getOrDefault((Object)ITaggingService.TaggableType.RECIPE, Collections.emptyList());
        List labelingTaskRefs = nonComputableRefsPerType.getOrDefault((Object)ITaggingService.TaggableType.LABELING_TASK, Collections.emptyList());
        List<TaggableObjectsService.TaggableObjectRef> flowRefs = nonComputableRefsPerType.getOrDefault((Object)ITaggingService.TaggableType.FLOW_ZONE, Collections.emptyList());
        if (toCopy.size() > 0 && options.copyToFlowZone && options.zoneCreationMode != null) {
            switch (options.zoneCreationMode) {
                case SELECT: {
                    break;
                }
                case CREATE: {
                    Zone zone = new Zone(null, options.zoneName, options.zoneColor, options.targetProjectKey);
                    this.flowZonesService.create(options.targetProjectKey, zone, authCtx);
                    options.selectedZone = zone.getId();
                    this.graphService.invalidateCache(options.targetProjectKey);
                }
            }
        }
        for (TaggableObjectsService.TaggableObjectRef nonLocalComputableRef : foreignComputableRefs) {
            this.copyForeignComputable(nonLocalComputableRef, options.targetProjectKey, authCtx);
        }
        for (TaggableObjectsService.TaggableObjectRef localComputableRef : localComputableRefs) {
            original = this.taggableObjectsReadService.getMandatoryUnsafe(localComputableRef.projectKey, localComputableRef.type, localComputableRef.id);
            copy = this.copyLocalComputable(localComputableRef, options, toCopy, authCtx);
            String zoneId = options.copyToFlowZone ? options.selectedZone : this.flowZonesService.retrieveZone(localComputableRef.projectKey, original);
            this.flowZonesService.attachObjectToZone(zoneId, copy.getProjectKey(), copy, true);
            ret.createdItems.add(new CopiedSublowItem(original, copy));
            this.copyData_T(original, copy, authCtx);
        }
        for (TaggableObjectsService.TaggableObjectRef recipeRef : recipeRefs) {
            this.copyRecipe(recipeRef, options, toCopy, authCtx);
        }
        for (TaggableObjectsService.TaggableObjectRef labelingTaskRef : labelingTaskRefs) {
            original = this.taggableObjectsReadService.getMandatoryUnsafe(labelingTaskRef.projectKey, labelingTaskRef.type, labelingTaskRef.id);
            copy = this.copyLabelingTask(labelingTaskRef, options, toCopy, authCtx);
            ret.createdItems.add(new CopiedSublowItem(original, copy));
        }
        this.copyFlowZones(toCopy, options, ret, flowRefs, authCtx);
        if (!flowRefs.isEmpty()) {
            this.graphService.invalidateCache(options.targetProjectKey);
        }
        nonComputableRefsPerType.keySet().stream().filter(refType -> !ITaggingService.TaggableType.RECIPE.equals(refType)).filter(refType -> !ITaggingService.TaggableType.FLOW_ZONE.equals(refType)).filter(refType -> !ITaggingService.TaggableType.LABELING_TASK.equals(refType)).findFirst().ifPresent(refType -> {
            throw ErrorContext.iaef((String)"Cannot copy type %s", (Object)refType, (Object[])new Object[0]);
        });
        return ret;
    }

    private void copyFlowZones(Set<TaggableObjectsService.TaggableObjectRef> toCopy, CopySubflowOptions options, CopySubflowResponse response, List<TaggableObjectsService.TaggableObjectRef> flowRefs, AuthCtx authCtx) throws Exception {
        Zone defaultZone = null;
        HashSet<SmartObjectRef> objectsInNonDefaultZone = new HashSet<SmartObjectRef>();
        for (TaggableObjectsService.TaggableObjectRef flowZoneRef : flowRefs) {
            Zone originalZone = (Zone)this.taggableObjectsReadService.getMandatory(flowZoneRef);
            if (originalZone.isDefaultZone()) {
                defaultZone = originalZone;
                continue;
            }
            this.copyFlowZone(originalZone, originalZone.getItems(), options, authCtx, response);
            if (!options.copyZoneContent) continue;
            objectsInNonDefaultZone.addAll(originalZone.getItems());
        }
        if (defaultZone != null) {
            Set<SmartObjectRef> defaultZoneItems = !options.copyZoneContent ? Collections.emptySet() : toCopy.stream().filter(tof -> tof.type != ITaggingService.TaggableType.FLOW_ZONE).map(tof -> new SmartObjectRef(null, tof.type, tof.id)).collect(Collectors.toSet());
            defaultZoneItems.removeAll(objectsInNonDefaultZone);
            this.copyFlowZone(defaultZone, defaultZoneItems, options, authCtx, response);
        }
    }

    private Map<Dataset, DatasetTestHandler> getDatasetsToCheck(AuthCtx authCtx, CopySubflowResponse resp) throws Exception {
        LinkedHashMap<Dataset, DatasetTestHandler> mapping = new LinkedHashMap<Dataset, DatasetTestHandler>();
        try {
            for (CopiedSublowItem to : resp.createdItems) {
                if (to.copy.getTaggableType() != ITaggingService.TaggableType.DATASET) continue;
                SerializedDataset ds = (SerializedDataset)to.copy;
                Dataset dataset = Dataset.fromSerialized(ds);
                if (BuiltinFSDatasets.FILES_IN_FOLDER_META.getType().equals(ds.type)) continue;
                logger.info((Object)String.format("Adding new dataset to check for name safety: %s", ds.getFullId()));
                DatasetTestHandler dh = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, DatasetTestHandler.class);
                mapping.put(dataset, dh);
            }
        }
        catch (Exception e) {
            this.closeDatasetTestHandlersNoFail(mapping.values());
            throw e;
        }
        return mapping;
    }

    private void closeDatasetTestHandlersNoFail(Collection<DatasetTestHandler> testHandlers) {
        logger.info((Object)"Closing all dataset tests handlers");
        for (DatasetTestHandler testHandler : testHandlers) {
            try {
                testHandler.close();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Cannot close dataset test handler %s", testHandlers.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }

    private void copyForeignComputable(TaggableObjectsService.TaggableObjectRef ref, String targetProjectKey, AuthCtx authCtx) throws IOException, LimitsStatusComputer.LicenseLimitException, DKUSecurityException, CodedException {
        String contextProjectKey = ref.projectKey;
        String sourceProjectKey = ref.getLoc().resolved().getProjectKey();
        boolean copyToSameProject = targetProjectKey.equals(contextProjectKey);
        boolean becomesLocal = sourceProjectKey.equals(targetProjectKey);
        if (copyToSameProject) {
            logger.info((Object)"Skip copy foreign object to same project");
            return;
        }
        if (becomesLocal) {
            logger.info((Object)"Skip copy foreign object to its origin project");
            return;
        }
        this.expose(sourceProjectKey, targetProjectKey, ref, authCtx);
    }

    private TaggableObjectsService.TaggableObject copyLocalComputable(TaggableObjectsService.TaggableObjectRef ref, CopySubflowOptions options, Set<TaggableObjectsService.TaggableObjectRef> toCopy, AuthCtx authCtx) throws Exception {
        SerializedDataset sds;
        Dataset ds;
        assert (ref.projectKey.equals(ref.getLoc().resolved().getProjectKey()));
        EnumSet<ITaggingService.TaggableType[]> computableTypes = EnumSet.of(ITaggingService.TaggableType.DATASET, new ITaggingService.TaggableType[]{ITaggingService.TaggableType.MANAGED_FOLDER, ITaggingService.TaggableType.STREAMING_ENDPOINT, ITaggingService.TaggableType.SAVED_MODEL, ITaggingService.TaggableType.MODEL_EVALUATION_STORE, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE});
        assert (computableTypes.contains((Object)ref.type));
        TaggableObjectsService.TaggableObject original = this.taggableObjectsReadService.getMandatory(ref);
        TaggableObjectsService.TaggableObject copy = (TaggableObjectsService.TaggableObject)JSON.deepCopy((Object)original);
        if (StringUtils.isNotBlank((String)options.oldItemsTag)) {
            original.tags.add(options.oldItemsTag);
            this.taggableObjectsSaveService.save(original);
        }
        copy.setId(this.getIdAfterCopy(ref, options, toCopy, authCtx));
        copy.setProjectKey(options.targetProjectKey);
        if (this.taggableObjectsReadService.getOrNullUnsafe(copy.getProjectKey(), copy.getTaggableType(), copy.getId()) != null) {
            throw ErrorContext.iaef((String)"%s already exists: %s", (Object)copy.getTaggableType().toHumanReadableString(), (Object[])new Object[]{copy.getFullId()});
        }
        TaggableObjectsService.TaggableObjectRef newRef = new TaggableObjectsService.TaggableObjectRef(copy);
        copy.versionTag = copy.creationTag = new VersionTag(authCtx.getAssociatedDSSUserOrIdentifier());
        if (options.dontCopyTags || copy.tags == null) {
            copy.tags = new ArrayList<String>();
        }
        if (StringUtils.isNotBlank((String)options.newItemsTag)) {
            copy.tags.add(options.newItemsTag);
        }
        if (ref.type == ITaggingService.TaggableType.DATASET) {
            SerializedDataset copySD = (SerializedDataset)copy;
            DatasetSaveService.DatasetCreationContext dsCtx = original.getProjectKey().equals(options.targetProjectKey) ? DatasetSaveService.DatasetCreationContext.buildDefault() : DatasetSaveService.DatasetCreationContext.buildCopyFromAnotherProject(original.getProjectKey(), original.getId());
            this.customPolicyHooksRegistry.onPreDatasetCreation(authCtx, copySD, dsCtx);
            String connectionName = copySD.getParams().getConnection();
            if (copySD.managed && StringUtils.isNotBlank((String)connectionName)) {
                DSSConnection connection = this.connectionsDAO.getConnectionUnsafeUnexpanded(authCtx, connectionName);
                if (connection == null) {
                    throw ErrorContext.iaef((String)"Connection '%s' does not exist", (Object)connectionName, (Object[])new Object[0]);
                }
                Dataset ds2 = Dataset.fromSerializedUnsafe(copySD);
                DatasetHandler.DatasetMeta<?, ?> newMeta = DatasetHandlerFactory.getMeta(copySD.type);
                newMeta.fillManagedDatasetParams(ds2, connection, null, true);
                this.copyDatasetChartsAndExplore(original, copy, authCtx);
            }
            if (BuiltinFSDatasets.FILES_IN_FOLDER_META.getType().equals(copySD.type)) {
                params = copySD.getParamsAs(BuiltinFSDatasets.FilesInFolderConfig.class);
                loc = AnyLoc.resolveSmart(original.getProjectKey(), params.folderSmartId);
                TaggableObjectsService.TaggableObjectRef underlyingFolderRef = new TaggableObjectsService.TaggableObjectRef(loc.getProjectKey(), ITaggingService.TaggableType.MANAGED_FOLDER, loc.getId());
                params.folderSmartId = this.getIdAfterCopy(underlyingFolderRef, options, toCopy, authCtx);
            } else if ("JobsDB".equals(copySD.type)) {
                params = copySD.getParamsAs(JobsdbDatasetParams.class);
                if (((JobsdbDatasetParams)params).scope == JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT) {
                    loc = AnyLoc.resolveSmart(original.getProjectKey(), ((JobsdbDatasetParams)params).smartName);
                    TaggableObjectsService.TaggableObjectRef underlyingComputableRef = new TaggableObjectsService.TaggableObjectRef(loc.getProjectKey(), ITaggingService.TaggableType.DATASET, loc.getId());
                    ((JobsdbDatasetParams)params).smartName = this.getIdAfterCopy(underlyingComputableRef, options, toCopy, authCtx);
                }
            }
            copySD.manualDataLineage = null;
        } else if (ref.type == ITaggingService.TaggableType.MANAGED_FOLDER) {
            ManagedFolder mf = (ManagedFolder)copy;
            String connectionName = mf.params.connection;
            if (StringUtils.isNotBlank((String)connectionName)) {
                DSSConnection connection = this.connectionsDAO.getConnectionUnsafeUnexpanded(authCtx, connectionName);
                if (connection == null) {
                    throw ErrorContext.iaef((String)"Connection '%s' does not exist", (Object)connectionName, (Object[])new Object[0]);
                }
                DatasetHandler.DatasetMeta<?, ?> newMeta = DatasetHandlerFactory.getMeta(mf.getType());
                newMeta.fillManagedFolderParams(mf, connection, true);
            }
        } else if (ref.type == ITaggingService.TaggableType.STREAMING_ENDPOINT) {
            StreamingEndpoint se = (StreamingEndpoint)copy;
            StreamingEndpointMeta meta = StreamingEndpointsRegistry.getMeta(se.type);
            meta.fillCopyParams(se);
        } else if (ref.type != ITaggingService.TaggableType.SAVED_MODEL && ref.type != ITaggingService.TaggableType.MODEL_EVALUATION_STORE && ref.type != ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE) {
            throw new Error("Unreachable");
        }
        this.taggableObjectsSaveService.save(copy);
        if (ref.type == ITaggingService.TaggableType.DATASET && this.neverBuiltComputablesCacheService.canBeAdded(ds = Dataset.fromSerializedUnsafe(sds = (SerializedDataset)copy))) {
            this.neverBuiltComputablesCacheService.add(newRef);
        }
        TaggableObjectChangedEvent.ActionType actionType = TaggableObjectChangedEvent.ActionType.DATASET_CREATE;
        if (ref.type == ITaggingService.TaggableType.MANAGED_FOLDER) {
            actionType = TaggableObjectChangedEvent.ActionType.MANAGED_FOLDER_CREATE;
        } else if (ref.type == ITaggingService.TaggableType.SAVED_MODEL) {
            actionType = TaggableObjectChangedEvent.ActionType.SAVED_MODEL_CREATE;
        } else if (ref.type == ITaggingService.TaggableType.MODEL_EVALUATION_STORE) {
            actionType = TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_CREATE;
        } else if (ref.type == ITaggingService.TaggableType.STREAMING_ENDPOINT) {
            actionType = TaggableObjectChangedEvent.ActionType.STREAMING_ENDPOINT_CREATE;
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ref.type, copy.getProjectKey(), copy.getId(), authCtx, actionType));
        return copy;
    }

    private Zone copyFlowZone(Zone original, Set<SmartObjectRef> items, CopySubflowOptions options, AuthCtx authCtx, CopySubflowResponse response) throws Exception {
        NameChange nameChange;
        Zone copy;
        Zone zone = copy = options.copyZoneContent || options.renaming ? (Zone)JSON.deepCopyExcept((Object)original, (String[])new String[]{"items", "shared"}) : (Zone)JSON.deepCopy((Object)original);
        if (StringUtils.isNotBlank((String)options.oldItemsTag)) {
            original.tags.add(options.oldItemsTag);
            this.taggableObjectsSaveService.save(original);
        }
        copy.setId(null);
        copy.setProjectKey(options.targetProjectKey);
        copy.versionTag = copy.creationTag = new VersionTag(authCtx.getAssociatedDSSUser());
        if (options.renaming && options.flowZoneNames != null && (nameChange = options.flowZoneNames.get(original.getId())) != null) {
            copy.setName(nameChange.newName);
        }
        if (options.copyZoneContent) {
            SmartObjectRef clonedRef;
            for (SmartObjectRef smRef : items) {
                clonedRef = this.createNewRefFromSubflowCopyOptions(smRef, options);
                if (!this.needsToMoveRef(clonedRef, response)) continue;
                this.flowZonesService.detachObjectFromZone(copy.getProjectKey(), clonedRef);
                copy.addItem(clonedRef);
            }
            for (SmartObjectRef smRef : original.getShared()) {
                clonedRef = this.createNewRefFromSubflowCopyOptions(smRef, options);
                copy.addZoneShared(clonedRef);
            }
        }
        if (options.dontCopyTags || copy.tags == null) {
            copy.tags = new ArrayList();
        }
        if (StringUtils.isNotBlank((String)options.newItemsTag)) {
            copy.tags.add(options.newItemsTag);
        }
        this.flowZonesService.create(copy.getProjectKey(), copy, authCtx);
        return copy;
    }

    private SmartObjectRef createNewRefFromSubflowCopyOptions(SmartObjectRef smRef, CopySubflowOptions options) {
        TaggableObjectsService.TaggableObjectRef tor = smRef.toTaggableObjectRef(options.targetProjectKey);
        return this.createNewRefFromSubflowCopyOptions(smRef.projectKey, tor, options);
    }

    private SmartObjectRef createNewRefFromSubflowCopyOptions(String originalObjectProjectKey, TaggableObjectsService.TaggableObjectRef taggableObjectRef, CopySubflowOptions options) {
        return SmartObjectRef.fromResolved(taggableObjectRef.type, originalObjectProjectKey, this.applyRenaming(taggableObjectRef, options), options.targetProjectKey);
    }

    private boolean needsToMoveRef(SmartObjectRef newRef, CopySubflowResponse response) {
        if (!FlowComputable.FCType.isFlowComputable(newRef.objectType)) {
            return newRef.objectType == ITaggingService.TaggableType.RECIPE || newRef.objectType == ITaggingService.TaggableType.LABELING_TASK;
        }
        for (CopiedSublowItem createdItem : response.createdItems) {
            if (createdItem.copy.getTaggableType() != newRef.objectType || !Objects.equals(createdItem.copy.getId(), newRef.objectId)) continue;
            return true;
        }
        return false;
    }

    private void copyRecipe(TaggableObjectsService.TaggableObjectRef ref, CopySubflowOptions options, Set<TaggableObjectsService.TaggableObjectRef> toCopy, AuthCtx authCtx) throws Exception {
        TaggableObjectsService.TaggableObjectRef computableRef;
        SerializedRecipe original = (SerializedRecipe)this.recipesDAO.getMandatory(ref.getLoc());
        SerializedRecipe copy = (SerializedRecipe)JSON.deepCopy((Object)original);
        String payload = this.recipesDAO.getPayloadOrNull(copy.projectKey, copy.name);
        if (StringUtils.isNotBlank((String)options.oldItemsTag)) {
            original.tags.add(options.oldItemsTag);
            this.recipeSaveService.save(original.projectKey, original, payload);
        }
        String sourceProjectKey = original.projectKey;
        copy.name = this.recipeSaveService.smartRename(options.targetProjectKey, original.name, options.datasetNames);
        copy.projectKey = options.targetProjectKey;
        copy.versionTag = copy.creationTag = new VersionTag(authCtx.getAssociatedDSSUserOrIdentifier());
        for (SerializedRecipe.RecipeOutput out : copy.getFlatOutputs()) {
            computableRef = this.getComputableRef(sourceProjectKey, out.ref);
            if (!toCopy.contains(computableRef)) {
                throw ErrorContext.iae((String)("Recipes must be copied with their outputs: " + copy.getId()));
            }
            out.ref = this.getIdAfterCopy(computableRef, options, toCopy, authCtx);
            if (computableRef.type != ITaggingService.TaggableType.DATASET) continue;
            payload = DatasetRenameService.updateDatasetInRecipePayload(copy, sourceProjectKey, payload, computableRef.getLoc().toDatasetLoc(), out.getLoc(options.targetProjectKey).toDatasetLoc(), false, authCtx);
            DatasetRenameService.updateDatasetReferencesInRecipeParams(copy, computableRef.getLoc().toDatasetLoc().getSmartName(sourceProjectKey), out.ref);
        }
        for (SerializedRecipe.RecipeInput in : copy.getFlatInputs()) {
            computableRef = this.getComputableRef(sourceProjectKey, in.ref);
            in.ref = this.getIdAfterCopy(computableRef, options, toCopy, authCtx);
            if (computableRef.type == ITaggingService.TaggableType.DATASET) {
                payload = DatasetRenameService.updateDatasetInRecipePayload(copy, sourceProjectKey, payload, computableRef.getLoc().toDatasetLoc(), in.getLoc(options.targetProjectKey).toDatasetLoc(), true, authCtx);
                DatasetRenameService.updateDatasetReferencesInRecipeParams(copy, computableRef.getLoc().toDatasetLoc().getSmartName(sourceProjectKey), in.ref);
            }
            if (in.deps == null) continue;
            for (SerializedRecipe.SDep dep : in.deps) {
                if (!StringUtils.isNotBlank((String)dep.out)) continue;
                try {
                    TaggableObjectsService.TaggableObjectRef outputRef = this.getComputableRef(sourceProjectKey, dep.out);
                    dep.out = this.getIdAfterCopy(outputRef, options, toCopy, authCtx);
                }
                catch (NotFoundException e) {
                    logger.warn((Object)"Computable not found in partition dependency", (Throwable)e);
                    dep.out = "";
                }
            }
        }
        if (options.dontCopyTags || copy.tags == null) {
            copy.tags = new ArrayList();
        }
        if (StringUtils.isNotBlank((String)options.newItemsTag)) {
            copy.tags.add(options.newItemsTag);
        }
        if (this.recipesDAO.getOrNullUnsafe(copy.projectKey, copy.name) != null) {
            throw ErrorContext.iaef((String)"Recipe already exists: %s", (Object)copy.getFullId(), (Object[])new Object[0]);
        }
        String zoneId = options.copyToFlowZone ? options.selectedZone : this.flowZonesService.retrieveZone(original.projectKey, original);
        this.flowZonesService.attachObjectToZone(zoneId, copy.projectKey, copy, true);
        this.recipeSaveService.save(copy.projectKey, copy, payload);
        if (options.recipeNames != null) {
            options.recipeNames.put(original.name, copy.name);
        }
    }

    private LabelingTask copyLabelingTask(TaggableObjectsService.TaggableObjectRef ref, CopySubflowOptions options, Set<TaggableObjectsService.TaggableObjectRef> toCopy, AuthCtx authCtx) throws Exception {
        LabelingTask original = (LabelingTask)this.labelingtasksDAO.getMandatory(ref.getLoc());
        LabelingTask copy = (LabelingTask)JSON.deepCopy((Object)original);
        if (StringUtils.isNotBlank((String)options.oldItemsTag)) {
            original.tags.add(options.oldItemsTag);
            this.taggableObjectsSaveService.save(original);
        }
        copy.projectKey = options.targetProjectKey;
        copy.versionTag = copy.creationTag = new VersionTag(authCtx.getAssociatedDSSUserOrIdentifier());
        for (LabelingTask.LabelingTaskOutput out : copy.getFlatOutputs()) {
            TaggableObjectsService.TaggableObjectRef computableRef = this.getComputableRef(original.projectKey, out.ref);
            if (!toCopy.contains(computableRef)) {
                throw ErrorContext.iae((String)("Labeling tasks must be copied with their outputs: " + copy.getId()));
            }
            out.ref = this.getIdAfterCopy(computableRef, options, toCopy, authCtx);
        }
        for (LabelingTask.LabelingTaskInput in : copy.getFlatInputs()) {
            in.ref = this.getIdAfterCopy(this.getComputableRef(original.projectKey, in.ref), options, toCopy, authCtx);
        }
        if (options.dontCopyTags || copy.tags == null) {
            copy.tags = new ArrayList();
        }
        if (StringUtils.isNotBlank((String)options.newItemsTag)) {
            copy.tags.add(options.newItemsTag);
        }
        String zoneId = options.copyToFlowZone ? options.selectedZone : this.flowZonesService.retrieveZone(original.projectKey, original);
        copy.id = null;
        LabelingTask savedTask = this.labelingTasksCRUDService.upsertLabelingTask(copy, zoneId);
        if (options.labelingTaskNames != null) {
            options.labelingTaskNames.put(original.id, savedTask.id);
        }
        return savedTask;
    }

    private TaggableObjectsService.TaggableObjectRef getComputableRef(String projectKey, String id) throws IOException {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, id);
        if (this.datasetsDAO.getOrNullUnsafe(loc) != null) {
            return new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.DATASET, id);
        }
        if (this.managedFoldersDAO.getOrNullUnsafe(loc) != null) {
            return new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.MANAGED_FOLDER, id);
        }
        if (this.streamingEndpointsDAO.getOrNullUnsafe(loc) != null) {
            return new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.STREAMING_ENDPOINT, id);
        }
        if (this.savedModelsDAO.getOrNullUnsafe(loc) != null) {
            return new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.SAVED_MODEL, id);
        }
        if (this.modelEvaluationStoresDAO.getOrNullUnsafe(loc) != null) {
            return new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.MODEL_EVALUATION_STORE, id);
        }
        if (this.retrievableKnowledgeDAO.getOrNullUnsafe(loc) != null) {
            return new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE, id);
        }
        throw new NotFoundException("Computable not found: " + projectKey + "." + id);
    }

    private String getIdAfterCopy(TaggableObjectsService.TaggableObjectRef ref, CopySubflowOptions options, Set<TaggableObjectsService.TaggableObjectRef> toCopy, AuthCtx authCtx) throws Exception {
        String contextProjectKey = ref.projectKey;
        String sourceProjectKey = ref.getLoc().resolved().getProjectKey();
        boolean copyToSameProject = contextProjectKey.equals(options.targetProjectKey);
        boolean wasLocal = contextProjectKey.equals(sourceProjectKey);
        if (copyToSameProject) {
            logger.info((Object)(ref.toString() + " : copy to same project => don't expose"));
            if (!toCopy.contains(ref)) {
                return ref.id;
            }
            if (!wasLocal) {
                return ref.id;
            }
            return this.applyRenaming(ref, options);
        }
        if (toCopy.contains(ref)) {
            logger.info((Object)(ref.toString() + " : copied => don't expose"));
            return this.applyRenaming(ref, options);
        }
        if (wasLocal) {
            logger.info((Object)(ref.toString() + " : not local anymore => expose"));
            this.expose(sourceProjectKey, options.targetProjectKey, ref, authCtx);
            return contextProjectKey + "." + ref.id;
        }
        boolean becomesLocal = sourceProjectKey.equals(options.targetProjectKey);
        if (becomesLocal) {
            logger.info((Object)(ref.toString() + " : becomes local => don't expose"));
            return ref.getLoc().resolved().getId();
        }
        logger.info((Object)(ref.toString() + " : still foreign => expose"));
        this.expose(sourceProjectKey, options.targetProjectKey, ref, authCtx);
        return ref.id;
    }

    void expose(String sourceProjectKey, String targetProjectKey, TaggableObjectsService.TaggableObjectRef ref, AuthCtx authCtx) throws DKUSecurityException, IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        AnyLoc loc = AnyLoc.resolveSmart(sourceProjectKey, ref.id);
        boolean isQuicklyShareable = this.exposedObjectsService.isQuickSharingEnabled(loc.getProjectKey(), ref.type, loc.getId());
        logger.info((Object)(ref.toString() + " : not local anymore => expose"));
        if (!isQuicklyShareable) {
            this.permissionsService.checkProjectPrivileges(authCtx, sourceProjectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
        }
        this.exposedObjectsService.addObjectsExpositions(sourceProjectKey, Lists.newArrayList((Object[])new String[]{targetProjectKey}), Lists.newArrayList((Object[])new TaggableObjectsService.TaggableObjectRef[]{ref}));
    }

    private String applyRenaming(TaggableObjectsService.TaggableObjectRef ref, CopySubflowOptions options) {
        if (options.renaming) {
            if (ref.type == ITaggingService.TaggableType.DATASET && options.datasetNames.containsKey(ref.id)) {
                return options.datasetNames.get(ref.id);
            }
            if (ref.type == ITaggingService.TaggableType.RECIPE && options.recipeNames.containsKey(ref.id)) {
                return options.recipeNames.get(ref.id);
            }
            if (ref.type == ITaggingService.TaggableType.LABELING_TASK && options.labelingTaskNames.containsKey(ref.id)) {
                return options.labelingTaskNames.get(ref.id);
            }
            if (ref.type == ITaggingService.TaggableType.STREAMING_ENDPOINT && options.streamingEndpointNames.containsKey(ref.id)) {
                return options.streamingEndpointNames.get(ref.id);
            }
            if (ref.type == ITaggingService.TaggableType.SAVED_MODEL) {
                String newId = options.newModelIds.get(ref.id);
                if (newId == null) {
                    newId = SecretKeyGenerator.generate((int)8);
                    options.newModelIds.put(ref.id, newId);
                }
                return newId;
            }
            if (ref.type == ITaggingService.TaggableType.MODEL_EVALUATION_STORE) {
                String newId = options.newEvaluationStoreIds.get(ref.id);
                if (newId == null) {
                    newId = SecretKeyGenerator.generate((int)8);
                    options.newEvaluationStoreIds.put(ref.id, newId);
                }
                return newId;
            }
            if (ref.type == ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE) {
                String newId = options.newRetrievableKnowledgeIds.get(ref.id);
                if (newId == null) {
                    newId = SecretKeyGenerator.generate((int)8);
                    options.newRetrievableKnowledgeIds.put(ref.id, newId);
                }
                return newId;
            }
            if (ref.type == ITaggingService.TaggableType.MANAGED_FOLDER) {
                String newId = options.newFolderIds.get(ref.id);
                if (newId == null) {
                    newId = SecretKeyGenerator.generate((int)8);
                    options.newFolderIds.put(ref.id, newId);
                }
                return newId;
            }
        }
        return ref.id;
    }

    private void copyDatasetChartsAndExplore(TaggableObjectsService.TaggableObject original, TaggableObjectsService.TaggableObject copy, AuthCtx authCtx) throws IOException {
        Dataset dataset = Dataset.fromSerialized((SerializedDataset)copy);
        RelFile fromData = new RelFile(new String[]{"projects", original.getProjectKey(), "explore", original.getId() + ".json"});
        RelFile toData = new RelFile(new String[]{"projects", dataset.getProjectKey(), "explore", dataset.getName() + ".json"});
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(fromData)) {
            t.copyFile(fromData, toData);
        } else {
            logger.info((Object)"No explore data for the dataset");
        }
    }

    public void copyData_T(TaggableObjectsService.TaggableObject original, TaggableObjectsService.TaggableObject copy, AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        if (copy.getTaggableType() == ITaggingService.TaggableType.DATASET) {
            Dataset dataset = Dataset.fromSerialized((SerializedDataset)copy);
            if (InlineDatasetHandler.META.getType().equals(dataset.getType())) {
                RelFile fromData = new RelFile(new String[]{"projects", original.getProjectKey(), "datasets", original.getId() + ".data"});
                RelFile toData = new RelFile(new String[]{"projects", dataset.getProjectKey(), "datasets", dataset.getName() + ".data"});
                RWTransactionRef t = TransactionContext.retrieveWrite();
                t.copyFile(fromData, toData);
            }
        }
    }

    public void copyData_NT(TaggableObjectsService.TaggableObject original, TaggableObjectsService.TaggableObject copy, AuthCtx authCtx) throws Exception {
        if (copy.getTaggableType() == ITaggingService.TaggableType.DATASET) {
            Dataset dataset = Dataset.fromSerialized((SerializedDataset)copy);
            if ("UploadedFiles".equals(dataset.getType())) {
                File fromFile = FileUploadService.localDatasetDir(original.getProjectKey(), original.getId());
                File toFile = FileUploadService.localDatasetDir(dataset.getProjectKey(), dataset.getName());
                DKUFileUtils.copyDirectory((File)fromFile, (File)toFile);
            } else if (this.neverBuiltComputablesCacheService.canBeAdded(dataset)) {
                this.neverBuiltComputablesCacheService.add(new TaggableObjectsService.TaggableObjectRef(copy));
            }
        } else if (copy.getTaggableType() == ITaggingService.TaggableType.MANAGED_FOLDER) {
            ManagedFolder originalFolder = (ManagedFolder)original;
            if ("Filesystem".equals(originalFolder.getType())) {
                try (ManagedFolderHandler inputFolderHandler = (ManagedFolderHandler)originalFolder.buildHandler(authCtx);){
                    FSBrowsePath root = inputFolderHandler.browse("");
                    try (ManagedFolderHandler handler = (ManagedFolderHandler)((ManagedFolder)copy).buildHandler(authCtx);){
                        for (FSBrowsePath child : root.children) {
                            File source = new File(inputFolderHandler.getAbsolutePath(child.fullPath));
                            if (child.directory) {
                                DKUFileUtils.copyDirectory((File)source, (File)new File(handler.getResolvedPath()));
                                continue;
                            }
                            FileUtils.copyFileToDirectory((File)source, (File)new File(handler.getResolvedPath()));
                        }
                    }
                }
            }
        } else if (copy.getTaggableType() == ITaggingService.TaggableType.SAVED_MODEL) {
            File originalDir = MLPaths.savedModelBaseFolder((SavedModel)original);
            File destinationDir = MLPaths.savedModelBaseFolder((SavedModel)copy);
            DKUFileUtils.copyDirectory((File)originalDir, (File)destinationDir);
            FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(destinationDir);
        } else if (copy.getTaggableType() == ITaggingService.TaggableType.MODEL_EVALUATION_STORE) {
            File originalDir = MECPaths.modelEvaluationStoreBaseFolder((ModelEvaluationStore)original);
            File destinationDir = MECPaths.modelEvaluationStoreBaseFolder((ModelEvaluationStore)copy);
            DKUFileUtils.copyDirectory((File)originalDir, (File)destinationDir);
            MECPaths.restrictPermissionsMESFolder(destinationDir);
        } else if (copy.getTaggableType() == ITaggingService.TaggableType.LABELING_TASK) {
            this.labelingTasksCRUDService.copyLabelingAnswers(authCtx, (LabelingTask)original, (LabelingTask)copy);
        } else if (copy.getTaggableType() == ITaggingService.TaggableType.STREAMING_ENDPOINT) {
            // empty if block
        }
    }

    public static class CopySubflowTestResponse
    extends InfoMessage.InfoMessages {
    }

    public static class CopySubflowOptions {
        public TargetMode targetMode;
        public String targetProjectKey;
        public String targetProjectName;
        public String targetProjectFolderId;
        public boolean renaming;
        public Map<String, String> datasetNames;
        public Map<String, String> recipeNames;
        public Map<String, String> labelingTaskNames;
        public Map<String, NameChange> flowZoneNames;
        public Map<String, String> streamingEndpointNames;
        public String newItemsTag;
        public String oldItemsTag;
        public boolean dontCopyTags;
        public Map<String, String> newFolderIds = new HashMap<String, String>();
        public Map<String, String> newModelIds = new HashMap<String, String>();
        public Map<String, String> newEvaluationStoreIds = new HashMap<String, String>();
        public Map<String, String> newRetrievableKnowledgeIds = new HashMap<String, String>();
        public boolean copyData;
        public boolean copyZoneContent;
        public boolean copyToFlowZone;
        public ZoneCreationMode zoneCreationMode;
        public String zoneName;
        public String zoneColor;
        public String selectedZone;
    }

    public static class CopySubflowResponse
    extends InfoMessage.InfoMessages {
        public Set<CopiedSublowItem> createdItems = new HashSet<CopiedSublowItem>();
    }

    public static enum TargetMode {
        CURRENT_PROJECT,
        EXISTING_PROJECT,
        NEW_PROJECT;

    }

    public static enum ZoneCreationMode {
        CREATE,
        SELECT;

    }

    public static class CopiedSublowItem {
        public TaggableObjectsService.TaggableObject original;
        public TaggableObjectsService.TaggableObject copy;

        public CopiedSublowItem(TaggableObjectsService.TaggableObject original, TaggableObjectsService.TaggableObject copy) {
            this.original = original;
            this.copy = copy;
        }
    }

    public static class NameChange {
        public String oldName;
        public String newName;
    }
}

