/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming.slave;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.security.INonImpersonatedKernel;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;

public class ContinuousActivityKernel
extends DSSKernelBase
implements INonImpersonatedKernel {
    private final String activityUniqueId;
    private final File runDir;
    protected LocalPrivilegedIntercomAPIClient apiClient;
    private DKULogger logger = DKULogger.getLogger((String)"dku.streaming.cak");

    public ContinuousActivityKernel(String activityUniqueId, File runDir) {
        super("CAK-" + activityUniqueId);
        this.activityUniqueId = activityUniqueId;
        this.runDir = runDir;
    }

    public Integer getPid() {
        IsolableProcess p = this.process;
        if (p == null) {
            return null;
        }
        return this.process.getWorkingPid();
    }

    public void start() throws Exception {
        String cakBin = System.getenv("DKUCAKBIN");
        if (cakBin == null) {
            throw new Error("environment variable DKUCAKBIN not defined");
        }
        ArrayList args = Lists.newArrayList((Object[])new String[]{cakBin, this.activityUniqueId});
        ProcessBuilder pb = new ProcessBuilder(args);
        this.logger.infoV("Starting CA kernel activityUniqueId=%s runDir=%s", new Object[]{this.activityUniqueId, this.runDir});
        if (HadoopLoader.isKerberosLoginEnabled()) {
            HadoopLoader.addTicketCacheEnvVar(pb.environment());
        }
        SharedSecretUtils.getSharedSecret((boolean)true);
        this.process = new RegularProcess(pb, ApplicationConfigurator.getBaseFolderF());
        this.process.start();
        int maxLogFiles = ApplicationConfigurator.getParams().getIntParam("dku.cak.max.log.files", Integer.valueOf(3));
        int maxLogFileSize = ApplicationConfigurator.getParams().getIntParam("dku.cak.max.log.file.size", Integer.valueOf(0x500000));
        DKUtils.RotatingLoggingSubscription logSubscription = new DKUtils.RotatingLoggingSubscription(this.runDir, "output.log", maxLogFiles, (long)maxLogFileSize);
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)logSubscription);
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)logSubscription);
        this.monitorThread = new DSSKernelBase.KernelMonitorThread((DSSKernelBase)this);
        this.monitorThread.start();
        this.waitForPort();
        this.apiClient = new LocalPrivilegedIntercomAPIClient(this.port, EncryptedRPC.enabled());
    }

    protected void waitForPort() throws Exception {
        int loops = 0;
        while (true) {
            ++loops;
            Thread.sleep(300L);
            if (this.process == null) {
                this.logger.error((Object)"CA kernel process died before start");
                throw new Exception("CA kernel process died before start", this.processExitException);
            }
            try {
                int foundPort = this.getPort();
                if (foundPort <= 0) continue;
                this.logger.info((Object)("CA kernel registered on port : " + this.port));
            }
            catch (Exception e) {
                if (loops % 10 != 5) continue;
                this.logger.info((Object)"CA kernel is not yet ready: ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private synchronized int getPort() {
        return this.port;
    }

    public synchronized void onRegister(int port) {
        this.port = port;
    }
}

