/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.utils;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SchemaComparator {
    public static List<String> findIncompatibilities(Schema existingSchema, Schema generatedSchema, boolean caseSensitive) {
        ArrayList<String> incompatibilities = new ArrayList<String>();
        List generatedColumns = generatedSchema.getColumns();
        List existingColumns = existingSchema.getColumns();
        if (existingColumns.size() == 0) {
            incompatibilities.add("The existing schema is empty");
            return incompatibilities;
        }
        if (generatedColumns.size() != existingColumns.size()) {
            incompatibilities.add("Different number of columns (" + existingColumns.size() + " columns previously, " + generatedColumns.size() + " columns in the current recipe) ");
            return incompatibilities;
        }
        for (int i = 0; i < existingColumns.size(); ++i) {
            SchemaColumn currentCol = (SchemaColumn)existingColumns.get(i);
            SchemaColumn generatedCol = (SchemaColumn)generatedColumns.get(i);
            if (StringUtils.isBlank((String)currentCol.getName())) {
                incompatibilities.add("Column at position " + i + " is unnamed");
                continue;
            }
            if (!SchemaComparator.sameName(currentCol, generatedCol, caseSensitive)) {
                incompatibilities.add("Column name changed at position " + i + " (\"" + generatedCol.getName() + "\" was called \"" + currentCol.getName() + "\" previously). ");
                continue;
            }
            SchemaComparator.addTypeDifferences(currentCol, generatedCol, incompatibilities);
        }
        return incompatibilities;
    }

    public static List<String> findDifferences(Schema existingSchema, Schema generatedSchema, boolean caseSensitive) {
        ArrayList<String> differences = new ArrayList<String>();
        List generatedColumns = generatedSchema.getColumns();
        List existingColumns = existingSchema.getColumns();
        if (existingColumns.size() == 0) {
            differences.add("The existing schema is empty");
            return differences;
        }
        if (generatedColumns.size() != existingColumns.size()) {
            differences.add("Different number of columns (" + existingColumns.size() + " columns previously, " + generatedColumns.size() + " columns in the current recipe) ");
            return differences;
        }
        for (int i = 0; i < existingColumns.size(); ++i) {
            boolean notNullsAndDifferent;
            SchemaColumn currentCol = (SchemaColumn)existingColumns.get(i);
            SchemaColumn generatedCol = (SchemaColumn)generatedColumns.get(i);
            if (StringUtils.isBlank((String)currentCol.getName())) {
                differences.add("Column at position " + i + " is unnamed");
                continue;
            }
            if (!SchemaComparator.sameName(currentCol, generatedCol, caseSensitive)) {
                differences.add("Column name mismatch at position " + i + " (\"" + generatedCol.getName() + "\" was called \"" + currentCol.getName() + "\" previously). ");
                continue;
            }
            if (!SchemaComparator.equals(currentCol.comment, generatedCol.comment)) {
                differences.add("Column description changed for " + generatedCol.getName());
                continue;
            }
            boolean onlyLeftNull = currentCol.customFields == null && generatedCol.customFields != null;
            boolean onlyRightNull = currentCol.customFields != null && generatedCol.customFields == null;
            boolean bl = notNullsAndDifferent = currentCol.customFields != null && generatedCol.customFields != null && !JSON.jsonEquals((Object)currentCol.customFields, (Object)generatedCol.customFields);
            if (onlyLeftNull || onlyRightNull || notNullsAndDifferent) {
                differences.add("Custom fields changed for " + generatedCol.getName());
                continue;
            }
            if (!SchemaComparator.equals(currentCol.getMeaning(), generatedCol.getMeaning())) {
                differences.add("Column meaning changed for " + generatedCol.getName() + ": " + currentCol.getMeaning() + " -> " + generatedCol.getMeaning());
                continue;
            }
            SchemaComparator.addTypeDifferences(currentCol, generatedCol, differences);
        }
        return differences;
    }

    private static boolean equals(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static boolean sameName(SchemaColumn a, SchemaColumn b, boolean caseSensitive) {
        boolean sameName = caseSensitive ? StringUtils.equals((String)a.getName(), (String)b.getName()) : StringUtils.equalsIgnoreCase((String)a.getName(), (String)b.getName());
        return sameName;
    }

    private static void addTypeDifferences(SchemaColumn currentCol, SchemaColumn generatedCol, List<String> differences) {
        if (!currentCol.getType().isCompatibleWith(generatedCol.getType())) {
            differences.add("Type mismatch at column " + generatedCol.getName() + " (type was \"" + currentCol.getType().getName() + "\", detected type is " + generatedCol.getType().getName() + "). ");
        } else if (!generatedCol.getType().isPrimitive()) {
            SchemaColumn simpleCur = SchemaComparator.simplify((SchemaColumn)JSON.deepCopy((Object)currentCol));
            SchemaColumn simpleGen = SchemaComparator.simplify((SchemaColumn)JSON.deepCopy((Object)generatedCol));
            simpleCur.setName(null);
            simpleGen.setName(null);
            if (!JSON.json((Object)simpleCur).equals(JSON.json((Object)simpleGen))) {
                differences.add("Complex type mismatch at column " + generatedCol.getName() + ", was :" + JSON.json((Object)simpleCur) + ", detected type is: " + JSON.json((Object)simpleGen));
            }
        }
    }

    private static SchemaColumn simplify(SchemaColumn col) {
        col.comment = null;
        col.customFields = null;
        col.setName(null);
        col.maxLength = 0;
        col.downcastedToStringFromMeaning = null;
        col.originalType = null;
        col.timestampNoTzAsDate = false;
        if (col.arrayContent != null) {
            SchemaComparator.simplify(col.arrayContent);
        }
        if (col.mapKeys != null) {
            SchemaComparator.simplify(col.mapKeys);
        }
        if (col.mapValues != null) {
            SchemaComparator.simplify(col.mapValues);
        }
        if (col.objectFields != null) {
            for (SchemaColumn field : col.objectFields) {
                SchemaComparator.simplify(field);
            }
        }
        return col;
    }
}

