/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality;

import com.dataiku.dip.dataquality.ReadMetricValueHelper;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.DatasetCheckContext;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.common.math.Quantiles;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@UIModel
public final class DriftRulesHelper {
    private DriftRulesHelper() {
    }

    public static RelevantHistoryCollection collectRelevantHistory(String metricId, DatasetCheckContext context, DqDriftParams params, ReadOnlyJobsInternalDB.MetricDataPoint currentValue) throws Exception {
        ArrayList data = Lists.newArrayList();
        if (params.periodUnit == DqDriftPeriodUnit.RUNS) {
            AtomicInteger validDataPointCnt = new AtomicInteger(0);
            context.browseRecentMetricData(metricId, dataPoint -> {
                if (currentValue.time == dataPoint.time) {
                    return true;
                }
                try {
                    ReadMetricValueHelper.checkMetricIsNumeric(dataPoint);
                    double value = Double.parseDouble(dataPoint.value);
                    int tmpValidDataPointCnt = validDataPointCnt.incrementAndGet();
                    if (params.lookbackPeriod >= tmpValidDataPointCnt) {
                        data.add(value);
                    }
                    return tmpValidDataPointCnt < params.lookbackPeriod || tmpValidDataPointCnt < params.learningPeriod;
                }
                catch (ReadMetricValueHelper.ReadMetricError e) {
                    return true;
                }
            });
            return new RelevantHistoryCollection(data, validDataPointCnt.get() >= params.learningPeriod);
        }
        AtomicBoolean hasDataPointOlderThanLearningTimestamp = new AtomicBoolean(false);
        long lookbackTimestamp = Instant.now().minus(Duration.ofDays(params.lookbackPeriod)).toEpochMilli();
        long learningTimestamp = Instant.now().minus(Duration.ofDays(params.learningPeriod)).toEpochMilli();
        long oldestTimestamp = Math.min(lookbackTimestamp, learningTimestamp);
        context.browseRecentMetricData(metricId, dataPoint -> {
            if (currentValue.time == dataPoint.time) {
                return true;
            }
            try {
                ReadMetricValueHelper.checkMetricIsNumeric(dataPoint);
                double value = Double.parseDouble(dataPoint.value);
                if (dataPoint.time <= learningTimestamp) {
                    hasDataPointOlderThanLearningTimestamp.set(true);
                }
                if (dataPoint.time > lookbackTimestamp) {
                    data.add(value);
                }
                return dataPoint.time > oldestTimestamp;
            }
            catch (ReadMetricValueHelper.ReadMetricError e) {
                return true;
            }
        });
        return new RelevantHistoryCollection(data, hasDataPointOlderThanLearningTimestamp.get());
    }

    public static AbstractCheckContext.CheckResult computeDrift(List<Double> relevantHistoryDataPoints, DqDriftParams params, double testedValue) {
        Map quartiles = Quantiles.percentiles().indexes(new int[]{25, 75}).compute(relevantHistoryDataPoints);
        double q1 = (Double)quartiles.get(25);
        double q3 = (Double)quartiles.get(75);
        double iqr = q3 - q1;
        double hardMin = q1 - params.iqrFactor * iqr;
        double hardMax = q3 + params.iqrFactor * iqr;
        double softMin = q1 - params.softIqrFactor * iqr;
        double softMax = q3 + params.softIqrFactor * iqr;
        if (params.iqrFactorEnabled && (testedValue < hardMin || testedValue > hardMax)) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, testedValue + " not in range: " + hardMin + " - " + hardMax);
        }
        if (params.softIqrFactorEnabled && (testedValue < softMin || testedValue > softMax)) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.WARNING, testedValue + " not in range: " + softMin + " - " + softMax);
        }
        if (params.iqrFactorEnabled && params.softIqrFactorEnabled) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, testedValue + " in range: " + Math.max(softMin, hardMin) + " - " + Math.min(softMax, hardMax));
        }
        if (params.iqrFactorEnabled) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, testedValue + " in range: " + hardMin + " - " + hardMax);
        }
        if (params.softIqrFactorEnabled) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, testedValue + " in range: " + softMin + " - " + softMax);
        }
        return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, "No range defined, current value is " + testedValue);
    }

    public static AbstractCheckContext.CheckResult runRule(String metricId, AbstractCheckContext context, DqDriftParams driftParams) throws Exception {
        double metricValueParsed;
        ReadOnlyJobsInternalDB.MetricDataPoint metricValue;
        try {
            metricValue = context.getCurrentValue(metricId);
            metricValueParsed = ReadMetricValueHelper.readDoubleMetricsValue(context, metricId);
        }
        catch (ReadMetricValueHelper.ReadMetricError e) {
            return new AbstractCheckContext.CheckResult(e.outcome, e.message);
        }
        RelevantHistoryCollection history = DriftRulesHelper.collectRelevantHistory(metricId, (DatasetCheckContext)context, driftParams, metricValue);
        if (!history.hasEnoughDataForLearningPeriod) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.EMPTY, "Empty (learning period not yet complete)");
        }
        if (history.data.size() < 3 && driftParams.periodUnit == DqDriftPeriodUnit.DAYS) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.WARNING, String.format("Lookback window only contains %d values", history.data.size()));
        }
        return DriftRulesHelper.computeDrift(history.data, driftParams, metricValueParsed);
    }

    @Nullable
    public static RuleValidationError verifyDriftParams(DqDriftParams driftParams) {
        if (driftParams.learningPeriod < 1) {
            return new RuleValidationError("Training period must be at least 1");
        }
        return null;
    }

    @UIModel
    public static class DqDriftParams {
        public DqDriftPeriodUnit periodUnit = DqDriftPeriodUnit.DAYS;
        public int learningPeriod = 4;
        public int lookbackPeriod = 7;
        public double iqrFactor = 1.5;
        public double softIqrFactor = 1.25;
        public boolean iqrFactorEnabled = true;
        public boolean softIqrFactorEnabled = false;
    }

    public static enum DqDriftPeriodUnit {
        RUNS,
        DAYS;

    }

    public static class RelevantHistoryCollection {
        public List<Double> data;
        public boolean hasEnoughDataForLearningPeriod;

        public RelevantHistoryCollection(List<Double> data, boolean hasEnoughDataForLearningPeriod) {
            this.data = data;
            this.hasEnoughDataForLearningPeriod = hasEnoughDataForLearningPeriod;
        }
    }
}

