/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.ReadMetricValueHelper;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractMultiColumnRule;
import com.dataiku.dip.dataquality.rules.MetricsBasedDataQualityRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.MetricInNumericRangeCheck;
import com.dataiku.dip.metrics.probes.BasicStatsDatasetProbeType;
import com.dataiku.dip.security.AuthCtx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ColumnNotEmptyRule
extends AbstractMultiColumnRule
implements MetricsBasedDataQualityRule {
    public static final String TYPE = "ColumnNotEmptyRule";
    public List<String> columns = new ArrayList<String>();
    @Nullable
    public ThresholdType thresholdType;
    public double maximum;
    public boolean maximumEnabled;
    public double softMaximum;
    public boolean softMaximumEnabled;

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    private Metric buildMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics metricType, String column) {
        return new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(metricType, column, null);
    }

    private long readMetricsValue(AbstractCheckContext context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics metricType, String column) throws Exception {
        return ReadMetricValueHelper.readLongMetricsValue(context, Metric.serializeMetric(this.buildMetric(metricType, column)));
    }

    @Override
    public List<Metric> getMetricsForOneColumn(String column) {
        assert (this.thresholdType != null);
        switch (this.thresholdType) {
            case ENTIRE_COLUMN_NOT_EMPTY: 
            case MAX_PERCENTAGE_EMPTY: {
                return Arrays.asList(this.buildMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT, column), this.buildMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_NULL, column));
            }
            case MAX_COUNT_EMPTY: {
                return Collections.singletonList(this.buildMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_NULL, column));
            }
        }
        throw new IllegalStateException("Unknown threshold type");
    }

    @Override
    public AbstractCheckContext.CheckResult runForOneColumn(String column, AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        assert (this.thresholdType != null);
        MetricInNumericRangeCheck check = new MetricInNumericRangeCheck().withMaximum(this.maximumEnabled, this.maximum).withSoftMaximum(this.softMaximumEnabled, this.softMaximum);
        switch (this.thresholdType) {
            case ENTIRE_COLUMN_NOT_EMPTY: {
                long emptyCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_NULL, column);
                if (emptyCount > 0L) {
                    return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, String.format("%d empty value%s", emptyCount, emptyCount == 1L ? "" : "s"));
                }
                long totalCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT, column);
                return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, String.format("%d non-empty %s", totalCount, totalCount > 1L ? "values" : "value"));
            }
            case MAX_COUNT_EMPTY: {
                long emptyCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_NULL, column);
                return check.runForResolvedValue(emptyCount);
            }
            case MAX_PERCENTAGE_EMPTY: {
                long emptyCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT_NULL, column);
                long notEmptyCount = this.readMetricsValue(context, BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.COUNT, column);
                long totalCount = emptyCount + notEmptyCount;
                if (totalCount == 0L) {
                    throw new AbstractMultiColumnRule.MultiRunStopException(new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot compute percentage-based rule: dataset is empty"));
                }
                return check.runForResolvedValue(100.0 * (double)emptyCount / (double)totalCount);
            }
        }
        throw new IllegalStateException("Unknown threshold type");
    }

    @Override
    public RuleValidationError verifyConfigOtherThanColumnsExistence(Dataset dataset) {
        if (this.thresholdType == null) {
            return new RuleValidationError("Threshold type cannot be null");
        }
        if (this.maximumEnabled && this.thresholdType == ThresholdType.MAX_PERCENTAGE_EMPTY && (this.maximum < 0.0 || this.maximum > 100.0)) {
            return new RuleValidationError("Maximum percentage must be between 0 and 100");
        }
        if (this.softMaximumEnabled && this.thresholdType == ThresholdType.MAX_PERCENTAGE_EMPTY && (this.softMaximum < 0.0 || this.softMaximum > 100.0)) {
            return new RuleValidationError("Soft maximum percentage must be between 0 and 100");
        }
        return null;
    }

    @Override
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return this.checkComputedMetricsPresent(computedMetrics);
    }

    @Override
    public void accept(FailedRowsExtractRuleVisitor visitor) {
        visitor.visit(this);
    }

    public static enum ThresholdType {
        ENTIRE_COLUMN_NOT_EMPTY,
        MAX_COUNT_EMPTY,
        MAX_PERCENTAGE_EMPTY;

    }
}

