/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ObjectCompleteMetadata;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.cassandra.AbstractCassandraDatasetHandler;
import com.dataiku.dip.datasets.custompython.CustomDatasetDesc;
import com.dataiku.dip.datasets.custompython.CustomJavaDatasetMeta;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetDesc;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetMeta;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetMeta;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDesc;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.datasets.sql.GenericSQLDatasetMeta;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.avro.AvroFormatMeta;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.naming.ASCIITransliterator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DatasetInspector {
    private static final Set<String> METASTORE_AWARE_DATASET_TYPES = Sets.newHashSet((Object[])new String[]{"HDFS", "S3", "Azure", "GCS"});
    private static final Set<String> POSSIBLY_SQLABLE_NON_SQL_DATASET_TYPES = Sets.newHashSet((Object[])new String[]{"S3"});
    private static Logger logger = Logger.getLogger((String)"dku.dataset.inspector");

    public static void checkType(String type) {
        DatasetHandlerFactory.getMeta(type);
    }

    public static void checkDatasetParams(AuthCtx authCtx, Dataset dataset) throws CodedException, DKUSecurityException, IOException {
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);){
            dh.checkConfiguration();
        }
    }

    public static void checkDatasetFormat(AuthCtx authCtx, Dataset dataset) throws CodedException {
        if (DatasetHandlerFactory.getMeta(dataset).isFSLike()) {
            if (dataset.getFormatType() == null) {
                throw new IllegalArgumentException("This dataset type (" + dataset.getType() + ") requires a format");
            }
            FormatFactory.buildExtractor(dataset.getFormatType(), dataset.getFormatParams(), authCtx, dataset.getProjectKey());
        }
    }

    public static void checkDataset(AuthCtx authCtx, Dataset dataset) throws CodedException, DKUSecurityException, IOException {
        try (ErrorContext.ACNDC ac = ErrorContext.pushWithNDC((String)("dataset:" + String.valueOf(dataset.getLoc())));){
            DatasetInspector.checkType(dataset.getType());
            DatasetInspector.checkDatasetParams(authCtx, dataset);
            DatasetInspector.checkDatasetFormat(authCtx, dataset);
        }
    }

    public static List<AnyLoc> getDependentDatasetsForVariablesExpansionLoop(Dataset dataset) {
        AbstractSQLDatasetHandler.AbstractSQLConfig asc;
        if (DatasetInspector.isFSNoThrow(dataset)) {
            AbstractFSDatasetHandler.AbstractFSConfig afc = dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class);
            if (afc != null && afc.variablesExpansionLoopConfig.isEnabled() && StringUtils.isNotBlank((String)afc.variablesExpansionLoopConfig.datasetRef)) {
                return Lists.newArrayList((Object[])new AnyLoc[]{AnyLoc.resolveSmart(dataset.getProjectKey(), afc.variablesExpansionLoopConfig.datasetRef)});
            }
        } else if (DatasetInspector.isSQL(dataset) && (asc = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class)) != null && asc.variablesExpansionLoopConfig.isEnabled() && StringUtils.isNotBlank((String)asc.variablesExpansionLoopConfig.datasetRef)) {
            return Lists.newArrayList((Object[])new AnyLoc[]{AnyLoc.resolveSmart(dataset.getProjectKey(), asc.variablesExpansionLoopConfig.datasetRef)});
        }
        return new ArrayList<AnyLoc>();
    }

    public static boolean isHDFSDatasetWithAssociatedHiveTableOrIsHiveTableDataset(Dataset dataset) {
        if (DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset)) {
            try {
                HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean hasAssociatedMetastoreTable(Dataset dataset) {
        if (DatasetInspector.isMetastoreAssociatedType(dataset)) {
            try {
                HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isHDFSInsideUploaded(AuthCtx authCtx, Dataset dataset, ConnectionsDAO connectionsDAO) throws DKUSecurityException {
        if ("UploadedFiles".equals(dataset.getType())) {
            return DatasetInspector.isHDFSInsideUploaded(authCtx, dataset.getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class), connectionsDAO);
        }
        return false;
    }

    public static boolean isHDFSInsideUploaded(AuthCtx authCtx, SerializedDataset dataset, ConnectionsDAO connectionsDAO) throws DKUSecurityException {
        if ("UploadedFiles".equals(dataset.type)) {
            return DatasetInspector.isHDFSInsideUploaded(authCtx, dataset.getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class), connectionsDAO);
        }
        return false;
    }

    public static boolean isHDFSInsideUploaded(AuthCtx authCtx, BuiltinFSDatasets.UploadedFilesConfig params, ConnectionsDAO connectionsDAO) throws DKUSecurityException {
        if (StringUtils.isNotBlank((String)params.connection)) {
            try {
                DSSConnection conn = connectionsDAO.getConnection(authCtx, params.connection);
                return conn != null && "HDFS".equals(conn.getType());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean canHDFS(Dataset dataset) {
        return dataset.getParams() instanceof HDFSDatasetHandler.Config;
    }

    public static boolean supportsORC(Dataset dataset) {
        return dataset.getParams() instanceof HDFSDatasetHandler.Config || dataset.getParams() instanceof BuiltinFSDatasets.AzureBlobDatasetConfig || dataset.getParams() instanceof BuiltinFSDatasets.S3DatasetConfig || dataset.getParams() instanceof BuiltinFSDatasets.GCSDatasetConfig;
    }

    public static boolean supportsParquet(Dataset dataset) {
        return dataset.getParams() instanceof HDFSDatasetHandler.Config || dataset.getParams() instanceof BuiltinFSDatasets.AzureBlobDatasetConfig || dataset.getParams() instanceof BuiltinFSDatasets.S3DatasetConfig || dataset.getParams() instanceof BuiltinFSDatasets.GCSDatasetConfig;
    }

    public static NotAppendableReason isAppendableDataset(Dataset dataset) {
        NotAppendableReason nar = new NotAppendableReason();
        if (DatasetInspector.supportsParquet(dataset) && ParquetFormatMeta.META.getType().equals(dataset.getFormatType())) {
            nar.noAppend = true;
            nar.datasetFormat = dataset.getFormatType();
        }
        if (DatasetInspector.supportsORC(dataset) && ORCFileFormatMeta.META.getType().equals(dataset.getFormatType())) {
            nar.noAppend = true;
            nar.datasetFormat = dataset.getFormatType();
        }
        if (DatasetInspector.isCustomPythonDatasetNoThrow(dataset)) {
            CustomPythonDatasetDesc desc = DatasetInspector.getCustomPythonDatasetDesc(dataset);
            if (!desc.supportAppend) {
                nar.noAppend = true;
                nar.customPythonDataset = true;
            }
        }
        return nar;
    }

    public static boolean isMetastoreAssociatedType(Dataset dataset) {
        return METASTORE_AWARE_DATASET_TYPES.contains(dataset.getType());
    }

    public static boolean canHive(Dataset dataset) {
        return dataset.getParams() instanceof HDFSDatasetHandler.Config || DatasetInspector.isHive(dataset);
    }

    public static boolean isHDFSDatasetOrHiveTableDataset(Dataset dataset) {
        return DatasetInspector.isHDFSDataset(dataset) || DatasetInspector.isHiveTable(dataset);
    }

    public static boolean isHDFSDataset(Dataset dataset) {
        return dataset.getParams() instanceof HDFSDatasetHandler.Config;
    }

    public static boolean syncsHiveTable(Dataset dataset) {
        return dataset.getParams() instanceof HDFSDatasetHandler.Config && dataset.getParamsAs(HDFSDatasetHandler.Config.class).metastoreSynchronizationEnabled || DatasetInspector.isHiveTable(dataset);
    }

    public static boolean syncsMetastoreTable(Dataset dataset) {
        return dataset.getParams() instanceof AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig && dataset.getParamsAs(AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig.class).metastoreSynchronizationEnabled || DatasetInspector.syncsHiveTable(dataset);
    }

    public static boolean canHDFS(SerializedDataset dataset) {
        return dataset.getParams() instanceof HDFSDatasetHandler.Config;
    }

    public static boolean canHive(SerializedDataset dataset) {
        return dataset.getParams() instanceof HDFSDatasetHandler.Config || DatasetInspector.isHive(dataset);
    }

    public static boolean canHiveTable(SerializedDataset dataset) {
        return dataset.getParams() instanceof HDFSDatasetHandler.Config || DatasetInspector.isHiveTable(dataset);
    }

    public static boolean isFSLike(Dataset dataset) {
        return DatasetHandlerFactory.getMeta(dataset).isFSLike();
    }

    public static boolean isFSLike(SerializedDataset dataset) {
        return DatasetInspector.isFSLike(Dataset.fromSerialized("X.X", dataset));
    }

    public static boolean isFS(Dataset dataset) {
        return DatasetHandlerFactory.getMeta(dataset).isFS();
    }

    public static boolean isFS(SerializedDataset dataset) {
        return DatasetInspector.isFS(Dataset.fromSerialized("X.X", dataset));
    }

    public static boolean isFSNoThrow(Dataset dataset) {
        return DatasetInspector.isFSNoThrow(dataset.getModel());
    }

    public static boolean isFSNoThrow(SerializedDataset sd) {
        return DatasetHandlerFactory.hasParamsClass(sd.type) && DatasetInspector.isFS(sd);
    }

    public static boolean isEditable(Dataset dataset) {
        return "Inline".equals(dataset.getType());
    }

    public static boolean isCustomPythonDataset(Dataset dataset) {
        return DatasetHandlerFactory.getMeta(dataset) instanceof CustomPythonDatasetMeta;
    }

    public static boolean isCustomPythonDatasetNoThrow(Dataset dataset) {
        try {
            return DatasetHandlerFactory.getMeta(dataset) instanceof CustomPythonDatasetMeta;
        }
        catch (UnavailableDSSObjectException e) {
            logger.warn((Object)("Could not find type " + dataset.getType() + " for dataset " + dataset.getName() + ". This is a custom dataset that has been uninstalled."));
        }
        catch (Exception e) {
            logger.warn((Object)("Could not verify if dataset " + dataset.getName() + " is not a custom python dataset : unknown type, default to false. "), (Throwable)e);
        }
        return false;
    }

    public static CustomPythonDatasetDesc getCustomPythonDatasetDesc(Dataset dataset) {
        if (!DatasetInspector.isCustomPythonDataset(dataset)) {
            throw ErrorContext.iaef((String)"dataset %s is not a custom python dataset", (Object)dataset.getName(), (Object[])new Object[0]);
        }
        CustomPythonDatasetMeta datasetMeta = (CustomPythonDatasetMeta)DatasetHandlerFactory.getMeta(dataset);
        return (CustomPythonDatasetDesc)datasetMeta.getDesc().desc;
    }

    public static boolean arePartitioningColumnsMandatoryInSchema(Dataset dataset) {
        return DatasetInspector.isSQLOrHive(dataset) || MongoDBDatasetHandler.META.getType().equals(dataset.getType()) || AbstractCassandraDatasetHandler.META.getType().equals(dataset.getType());
    }

    public static boolean arePartitioningColumnsForbiddenInSchema(Dataset dataset) {
        return "HDFS".equals(dataset.getType());
    }

    public static boolean isSQL(SerializedDataset dataset) {
        return dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig && !DatasetInspector.isHive(dataset);
    }

    public static SQLAbleFlavor getSQLAbleFlavorForSQLAbleDataset(AuthCtx authCtx, Dataset dataset) throws IOException {
        if (DatasetInspector.isSQLTable(dataset)) {
            if ("Athena".equals(dataset.getType())) {
                return SQLAbleFlavor.ATHENA;
            }
            if ("Trino".equals(dataset.getType())) {
                return SQLAbleFlavor.TRINO;
            }
            return SQLAbleFlavor.REAL_SQL;
        }
        if ("S3".equals(dataset.getType())) {
            try (S3DatasetHandler dh = (S3DatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                EC2Connection ec2Connection = dh.getConnection();
                if (StringUtils.isNotBlank((String)ec2Connection.params.associatedAthenaConnection)) {
                    SQLAbleFlavor sQLAbleFlavor = SQLAbleFlavor.ATHENA;
                    return sQLAbleFlavor;
                }
                throw ErrorContext.iaef((String)"S3 dataset %s is not associated to an Athena connection", (Object)dataset.getName(), (Object[])new Object[0]);
            }
        }
        throw ErrorContext.iaef((String)"Input dataset %s is not a SQL table", (Object)dataset.getName(), (Object[])new Object[0]);
    }

    public static String getSQLConnectionNameForSQLAbleDatasetOrHive(AuthCtx authCtx, SerializedDataset dataset) {
        return DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, Dataset.fromSerialized(dataset));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSQLConnectionNameForSQLAbleDatasetOrHive(AuthCtx authCtx, Dataset dataset) {
        if (DatasetInspector.isSQLOrHive(dataset)) {
            try (AbstractSQLDatasetHandler sourceDH = (AbstractSQLDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                String string = sourceDH.getConnectionName();
                return string;
            }
        }
        if (!"S3".equals(dataset.getType())) throw ErrorContext.iaef((String)"Input dataset %s is not a SQL table", (Object)dataset.getName(), (Object[])new Object[0]);
        try (S3DatasetHandler dh = (S3DatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
            EC2Connection ec2Connection = dh.getConnection();
            if (!StringUtils.isNotBlank((String)ec2Connection.params.associatedAthenaConnection)) throw ErrorContext.iaef((String)"S3 dataset %s is not associated to an Athena connection", (Object)dataset.getName(), (Object[])new Object[0]);
            String string = ec2Connection.params.associatedAthenaConnection;
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isSQL(Dataset dataset) {
        return dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig && !DatasetInspector.isHive(dataset);
    }

    public static boolean isSQL(String datasetType) {
        return AbstractSQLDatasetHandler.AbstractSQLConfig.class.isAssignableFrom(DatasetHandlerFactory.getMeta(datasetType).paramsClass()) && !DatasetInspector.isHive(datasetType);
    }

    public static boolean isSQLOrHive(SerializedDataset dataset) {
        return DatasetInspector.isSQLOrHive(dataset.getParams());
    }

    public static boolean isSQLOrHive(Dataset dataset) {
        return DatasetInspector.isSQLOrHive(dataset.getParams());
    }

    public static boolean isSQLOrHive(DatasetHandler.DatasetParams datasetParams) {
        return datasetParams instanceof AbstractSQLDatasetHandler.AbstractSQLConfig;
    }

    public static boolean isSQLOrHive(String datasetType) {
        return AbstractSQLDatasetHandler.AbstractSQLConfig.class.isAssignableFrom(DatasetHandlerFactory.getMeta(datasetType).paramsClass());
    }

    public static boolean isBigQuery(String datasetType) {
        return BuiltinSQLDatasets.BIGQUERY_META.getType().equals(datasetType);
    }

    public static boolean isTreasureData(String datasetType) {
        return BuiltinSQLDatasets.TREASUREDATA_META.getType().equals(datasetType);
    }

    public static boolean isHive(SerializedDataset dataset) {
        return BuiltinSQLDatasets.HIVE_META.getType().equals(dataset.type);
    }

    public static boolean isHive(Dataset dataset) {
        return BuiltinSQLDatasets.HIVE_META.getType().equals(dataset.getType());
    }

    public static boolean isHive(String datasetType) {
        return BuiltinSQLDatasets.HIVE_META.getType().equals(datasetType);
    }

    public static boolean isSQLTable(Dataset dataset) {
        return DatasetInspector.isSQLTableConfig(dataset.getModel()) && !BuiltinSQLDatasets.HIVE_META.getType().equals(dataset.getType());
    }

    public static boolean isElasticSearch(SerializedDataset dataset) {
        return ElasticSearchDatasetHandler.META.getType().equals(dataset.type);
    }

    public static boolean isHiveTable(Dataset dataset) {
        return DatasetInspector.isSQLTableConfig(dataset.getModel()) && BuiltinSQLDatasets.HIVE_META.getType().equals(dataset.getType());
    }

    public static boolean isHiveQuery(Dataset dataset) {
        return DatasetInspector.isSQLQuery(dataset.getModel()) && BuiltinSQLDatasets.HIVE_META.getType().equals(dataset.getType());
    }

    public static boolean isSQLOrHiveTable(Dataset dataset) {
        return DatasetInspector.isSQLTableConfig(dataset.getModel());
    }

    public static boolean isSQLTable(SerializedDataset dataset) {
        return DatasetInspector.isSQLTableConfig(dataset) && !BuiltinSQLDatasets.HIVE_META.getType().equals(dataset.type);
    }

    public static boolean isSQLQuery(SerializedDataset dataset) {
        if (dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            AbstractSQLDatasetHandler.AbstractSQLConfig params = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
            return "query".equals(params.mode);
        }
        return false;
    }

    public static boolean isHiveTable(SerializedDataset dataset) {
        return DatasetInspector.isSQLTableConfig(dataset) && BuiltinSQLDatasets.HIVE_META.getType().equals(dataset.type);
    }

    public static boolean isSQLAbleAndSQLTable(AuthCtx authCtx, Dataset dataset) {
        if (DatasetInspector.isSQLTableConfig(dataset.getModel()) && !BuiltinSQLDatasets.HIVE_META.getType().equals(dataset.getType())) {
            return true;
        }
        if (POSSIBLY_SQLABLE_NON_SQL_DATASET_TYPES.contains(dataset.getType())) {
            try {
                DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, dataset);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isSQLAble(AuthCtx authCtx, Dataset dataset) {
        if (DatasetInspector.isSQL(dataset.getModel())) {
            return true;
        }
        if (POSSIBLY_SQLABLE_NON_SQL_DATASET_TYPES.contains(dataset.getType())) {
            try {
                DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, dataset);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isSQLAble(AuthCtx authCtx, SerializedDataset dataset) {
        if (DatasetInspector.isSQL(dataset)) {
            return true;
        }
        if (POSSIBLY_SQLABLE_NON_SQL_DATASET_TYPES.contains(dataset.type)) {
            try {
                DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, dataset);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean hasValidSchema(Dataset dataset) {
        return dataset.getSchema() != null && !dataset.getSchema().columns.isEmpty();
    }

    public static boolean isSQLOrHiveTable(SerializedDataset dataset) {
        return DatasetInspector.isSQLTableConfig(dataset);
    }

    public static boolean isSQLTableConfig(SerializedDataset dataset) {
        if (dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            AbstractSQLDatasetHandler.AbstractSQLConfig params = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
            return "table".equals(params.mode);
        }
        return false;
    }

    public static SQLConnectionProvider.SQLConnectionData getSQLConnectionForSQLAbleDatasetOrHive(AuthCtx authCtx, Dataset dataset) throws IOException, SQLException, DKUSecurityException {
        String connection = DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, dataset);
        return SQLConnectionProvider.getConnectionData_NT(authCtx, dataset.getProjectKey(), connection);
    }

    public static AbstractSQLConnection getDSSConnectionForSQLAbleDatasetOrHive(AuthCtx authCtx, Dataset dataset) throws IOException, SQLException, DKUSecurityException {
        String connection = DatasetInspector.getSQLConnectionNameForSQLAbleDatasetOrHive(authCtx, dataset);
        return SQLConnectionProvider.getDSSConnection(authCtx, connection);
    }

    public static SQLConnectionProvider.SQLConnectionData getSQLConnectionForSQLOrHiveDataset(AuthCtx authCtx, Dataset dataset) throws IOException, SQLException, DKUSecurityException {
        assert (DatasetInspector.isSQLOrHive(dataset));
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        return SQLConnectionProvider.getConnectionData_NT(authCtx, dataset.getProjectKey(), config.connection);
    }

    public static AbstractSQLConnection getDSSConnectionForSQLOrHiveDataset(AuthCtx authCtx, Dataset dataset) throws IOException, SQLException, DKUSecurityException {
        assert (DatasetInspector.isSQLOrHive(dataset));
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        return SQLConnectionProvider.getDSSConnection(authCtx, config.connection);
    }

    public static SQLConnectionProvider.SQLConnectionData getSQLConnectionForPureSQL(AuthCtx authCtx, SerializedDataset dataset) throws IOException, SQLException, DKUSecurityException {
        assert (DatasetInspector.isSQL(dataset));
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        return SQLConnectionProvider.getConnectionData_NT(authCtx, dataset.getProjectKey(), config.connection);
    }

    public static AbstractSQLConnection getDSSConnectionForPureSQL(AuthCtx authCtx, SerializedDataset dataset) throws IOException, SQLException, DKUSecurityException {
        assert (DatasetInspector.isSQL(dataset));
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
        return SQLConnectionProvider.getDSSConnection(authCtx, config.connection);
    }

    public static boolean shouldBeConsideredAsStronglyTypedForPrepareTypeInference(Dataset dataset) {
        if (DatasetInspector.isSQLOrHive(dataset)) {
            return true;
        }
        if (DatasetInspector.isFSLike(dataset)) {
            String formatType = dataset.getFormatType();
            if (ParquetFormatMeta.META.getType().equals(formatType)) {
                return true;
            }
            if (ORCFileFormatMeta.META.getType().equals(formatType)) {
                return true;
            }
            if (AvroFormatMeta.META.getType().equals(formatType)) {
                return true;
            }
        }
        if (!dataset.isManaged()) {
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                if (column.getType().equals((Object)Type.STRING)) continue;
                return true;
            }
        }
        return dataset.isManaged();
    }

    public static boolean shouldDropOnStorageTypeChange(Dataset dataset) {
        if (dataset.getParams() instanceof AbstractSQLDatasetHandler.AbstractSQLConfig) {
            return true;
        }
        if (dataset.getParams() instanceof HDFSDatasetHandler.Config) {
            String formatType = dataset.getFormatType();
            if (ParquetFormatMeta.META.getType().equals(formatType)) {
                return true;
            }
            if (ORCFileFormatMeta.META.getType().equals(formatType)) {
                return true;
            }
            if (AvroFormatMeta.META.getType().equals(formatType)) {
                return true;
            }
        }
        return false;
    }

    public static String slufigyAndUnicize(String projectKey, String name, DatasetsDAO dao, TransactionService transactionService) throws IOException {
        assert (projectKey != null);
        if (name == null) {
            return null;
        }
        String normalized = ASCIITransliterator.transliterateToASCIIAlphanumAndUnderscore(name, "unnamed_dataset");
        Object cur = normalized;
        int i = 0;
        assert (dao != null);
        if (TransactionContext.hasAttachedTransaction()) {
            while (dao.datasetExistsCaseInsensitive(projectKey, (String)cur)) {
                cur = normalized + "_" + ++i;
            }
        } else {
            assert (transactionService != null);
            try (Transaction t = transactionService.beginRead();){
                while (dao.datasetExistsCaseInsensitive(projectKey, (String)cur)) {
                    cur = normalized + "_" + ++i;
                }
            }
        }
        return cur;
    }

    public static boolean sameConnection(SerializedDataset ... sds) {
        if (sds.length == 0) {
            logger.warn((Object)"Tested same connection with an empty set of datasets");
            return false;
        }
        String connection = null;
        for (SerializedDataset sd : sds) {
            String c2 = sd.getParams().getConnection();
            if (c2 == null || connection != null && !connection.equals(c2)) {
                return false;
            }
            connection = c2;
        }
        return true;
    }

    public static void checkDatasetConnectionPermission(SerializedDataset sds, AuthCtx liu, String deniedAction) throws IOException, DKUSecurityException {
        DatasetInspector.checkDatasetConnectionPermission(sds.getParamsAs(DatasetHandler.DatasetParams.class), liu, deniedAction);
    }

    public static void checkDatasetConnectionPermission(ManagedFolder sds, AuthCtx liu, String deniedAction) throws IOException, DKUSecurityException {
        DatasetInspector.checkDatasetConnectionPermission(sds.getParams(), liu, deniedAction);
    }

    public static void checkDatasetConnectionPermission(DatasetHandler.DatasetParams sds, AuthCtx liu, String deniedAction) throws IOException, DKUSecurityException {
        DSSConnection c2;
        if (liu == null) {
            return;
        }
        String connection = sds.getConnection();
        if (connection != null && !(c2 = ConnectionsDAO.get().getMandatoryConnectionUnsafeUnexpanded(liu, connection)).isFreelyUsableBy(liu)) {
            throw new SecurityException("You may not " + deniedAction + " connection " + connection);
        }
    }

    public static boolean checkDatasetConnectionWritePermission(AuthCtx authCtx, SerializedDataset sds) throws DKUSecurityException {
        JsonPrimitive connection = ((JsonObject)JSON.parse((String)JSON.json((Object)sds.getParams()), JsonObject.class)).getAsJsonPrimitive("connection");
        if (connection != null) {
            try {
                DSSConnection c2 = ConnectionsDAO.get().getMandatoryConnection(authCtx, connection.getAsString());
                return c2.allowWrite;
            }
            catch (IOException | IllegalArgumentException ex) {
                logger.warn((Object)("Connection can't be found but datasets still use it: " + connection.getAsString()));
                return false;
            }
        }
        return true;
    }

    public static boolean checkDatasetConnectionWritePermission(SerializedDataset sds, Map<String, DSSConnection> connections) {
        String connectionName;
        String string = connectionName = sds.getParams() == null ? null : sds.getParams().getConnection();
        if (connectionName != null) {
            DSSConnection c2 = connections.get(connectionName);
            if (c2 == null) {
                logger.warn((Object)("Connection can't be found but datasets still use it: " + connectionName));
                return false;
            }
            return c2.allowWrite;
        }
        return true;
    }

    public static ObjectCompleteMetadata getMetadata(Dataset dataset) {
        ObjectCompleteMetadata ocm = new ObjectCompleteMetadata();
        ocm.checklists = dataset.getModel().checklists;
        ocm.description = dataset.getDescription();
        ocm.tags = Sets.newHashSet((Iterable)dataset.getModel().tags);
        ocm.custom = dataset.getModel().customMeta;
        return ocm;
    }

    public static void setMetadata(Dataset dataset, ObjectCompleteMetadata ocm) {
        DatasetInspector.setMetadata(dataset.serialize(), ocm);
    }

    public static void setMetadata(SerializedDataset sd, ObjectCompleteMetadata ocm) {
        sd.checklists = ocm.checklists;
        sd.description = ocm.description;
        sd.tags = Lists.newArrayList(ocm.tags);
        sd.customMeta = ocm.custom;
    }

    public static class NotAppendableReason {
        public boolean noAppend = false;
        @Nullable
        public String datasetFormat;
        public boolean customPythonDataset = false;
    }

    public static enum SQLAbleFlavor {
        REAL_SQL,
        ATHENA,
        TRINO;

    }

    public static class SerializedDatasetType {
        String name;
        boolean fsLike;
        boolean sql;
        boolean customDataset;
        CustomDatasetDesc customDatasetDesc;
        boolean customFSProvider;
        CustomFSProviderDesc customFSProviderDesc;
        ParamDesc[] params;
        boolean hasCaseInsensitiveColumnNames;

        public SerializedDatasetType(DatasetHandler.DatasetMeta<?, ?> t) {
            this.name = t.getType();
            this.sql = DatasetInspector.isSQL(t.getType());
            this.fsLike = t.isFSLike();
            if (t instanceof CustomPythonDatasetMeta) {
                this.customDataset = true;
                this.customDatasetDesc = ((CustomPythonDatasetMeta)t).getDesc().desc;
            } else if (t instanceof CustomJavaDatasetMeta) {
                this.customDataset = true;
                this.customDatasetDesc = ((CustomJavaDatasetMeta)t).getDesc().desc;
            } else {
                this.customDataset = false;
            }
            this.customFSProvider = t instanceof CustomFSProviderDatasetMeta;
            if (this.customFSProvider) {
                this.customFSProviderDesc = ((CustomFSProviderDatasetMeta)t).getDesc().desc;
            }
            if (this.sql && t instanceof GenericSQLDatasetMeta) {
                this.hasCaseInsensitiveColumnNames = ((GenericSQLDatasetMeta)t).hasCaseInsensitiveColumns();
            }
            this.params = new ParamDesc[0];
        }
    }
}

