/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datasets.LatestPartitionsSelector;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.input.DatasetOrdering;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DatasetSelection
extends SamplingParam {
    public FilterDesc filter = new FilterDesc();
    public PartitionSelectionMethod partitionSelectionMethod = PartitionSelectionMethod.ALL;
    @Nullable
    public List<String> selectedPartitions;
    public int latestPartitionsN = 1;
    public DatasetOrdering ordering = new DatasetOrdering();

    public boolean hasPartition(Dataset dataset) {
        PartitioningScheme scheme = dataset.getPartitioningSchema();
        return scheme != null && scheme.isPartitioned() && this.partitionSelectionMethod != PartitionSelectionMethod.ALL;
    }

    public boolean hasFilter() {
        return FilterDescUtils.willFilter(this.filter);
    }

    public int getRequestedPartitionCount() {
        switch (this.partitionSelectionMethod) {
            case SELECTED: {
                return this.selectedPartitions == null ? 0 : this.selectedPartitions.size();
            }
            case LATEST_N: {
                return this.latestPartitionsN;
            }
        }
        return 0;
    }

    public String getIdentifier() {
        StringBuilder sb = new StringBuilder();
        switch (this.samplingMethod) {
            case FULL: {
                sb.append("method=full");
                break;
            }
            case HEAD_SEQUENTIAL: {
                sb.append("method=head-s");
                sb.append(",records=").append(this.maxRecords);
                break;
            }
            case RANDOM_FIXED_NB: {
                sb.append("method=random-fixednb");
                sb.append(",records=").append(this.maxRecords);
                if (this.seed == null) break;
                sb.append(",seed=").append(this.seed);
                break;
            }
            case RANDOM_FIXED_RATIO: {
                sb.append("method=random-fixedratio");
                sb.append(",ratio=").append(this.targetRatio);
                if (this.seed == null) break;
                sb.append(",seed=").append(this.seed);
                break;
            }
            case COLUMN_BASED: {
                sb.append("method=column-fixednb");
                sb.append(",column=").append(this.column);
                sb.append(",records=").append(this.maxRecords);
                break;
            }
            case CLASS_REBALANCE_TARGET_NB_APPROX: {
                sb.append("method=class-rebalance-fixednb-approx");
                sb.append(",column=").append(this.column);
                sb.append(",records=").append(this.maxRecords);
                if (this.seed == null) break;
                sb.append(",seed=").append(this.seed);
                break;
            }
            case CLASS_REBALANCE_TARGET_RATIO_APPROX: {
                sb.append("method=class-rebalance-ratio-approx");
                sb.append(",column=").append(this.column);
                sb.append(",ratio=").append(this.targetRatio);
                if (this.seed == null) break;
                sb.append(",seed=").append(this.seed);
                break;
            }
            case RANDOM_FIXED_NB_EXACT: {
                sb.append("method=random-fixednb-exact");
                sb.append(",records=").append(this.maxRecords);
                if (this.seed == null) break;
                sb.append(",seed=").append(this.seed);
                break;
            }
            case RANDOM_FIXED_RATIO_EXACT: {
                sb.append("method=random-fixedratio-exact");
                sb.append(",ratio=").append(this.targetRatio);
                if (this.seed == null) break;
                sb.append(",seed=").append(this.seed);
                break;
            }
            case STRATIFIED_TARGET_NB_EXACT: {
                sb.append("method=stratified-fixednb-exact");
                sb.append(",column=").append(this.column);
                sb.append(",records=").append(this.maxRecords);
                if (this.seed == null) break;
                sb.append(",seed=").append(this.seed);
                break;
            }
            case STRATIFIED_TARGET_RATIO_EXACT: {
                sb.append("method=stratified-ratio-exact");
                sb.append(",column=").append(this.column);
                sb.append(",ratio=").append(this.targetRatio);
                if (this.seed == null) break;
                sb.append(",seed=").append(this.seed);
                break;
            }
            case COLUMN_ORDERED: {
                sb.append("method=column-ordered");
                sb.append(",column=").append(this.column);
                sb.append(",ascending=").append(this.ascending);
                sb.append(",records=").append(this.maxRecords);
                break;
            }
        }
        switch (this.partitionSelectionMethod) {
            case SELECTED: {
                sb.append(",parts=").append(StringUtils.join(this.selectedPartitions, (String)"%"));
                break;
            }
            case ALL: {
                break;
            }
            case LATEST_N: {
                sb.append(",parts=latest-N,n=").append(this.latestPartitionsN);
            }
        }
        return sb.toString();
    }

    public List<String> getPartitionIds(AuthCtx authCtx, Dataset dataset) throws Exception {
        if (dataset.getPartitioningSchema() == null || !dataset.getPartitioningSchema().isPartitioned()) {
            return Lists.newArrayList((Object[])new String[]{"NP"});
        }
        switch (this.partitionSelectionMethod) {
            case ALL: {
                return Lists.newArrayList((Object[])new String[]{"NP"});
            }
            case SELECTED: {
                return this.selectedPartitions;
            }
            case LATEST_N: {
                List<Partition> partitions = LatestPartitionsSelector.select(authCtx, dataset, this.latestPartitionsN);
                ArrayList partitionIds = Lists.newArrayList();
                for (Partition partition : partitions) {
                    partitionIds.add(partition.id());
                }
                return partitionIds;
            }
        }
        throw new Error("Unreachable");
    }

    public static enum PartitionSelectionMethod {
        ALL,
        SELECTED,
        LATEST_N;

    }
}

