/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.PipelineInterruptedException;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetTestHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchOutput;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchUtils;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ElasticSearchDatasetHandler
implements RowOrientedDatasetHandler {
    public static final ElasticSearchDatasetMeta META = new ElasticSearchDatasetMeta();
    private final Dataset dataset;
    public final Config config;
    public final AuthCtx authCtx;
    ElasticSearchIndex esIndex = null;
    String filterQueryStringExpression;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.elasticsearch");

    public ElasticSearchDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.config = dataset.getParamsAs(Config.class).getResolved(dataset.getProjectKey());
    }

    private void initIndex() throws DKUSecurityException, IOException {
        this.initIndex(true);
    }

    private void initIndex(boolean check) {
        if (this.esIndex != null) {
            return;
        }
        ElasticSearchConnection connection = this.getConnection();
        if (check) {
            this.config.check(connection.params.dialect.hasType);
        }
        if (StringUtils.isNotBlank((String)this.config.index)) {
            this.config.index = ElasticSearchUtils.normalizeName(this.config.index, this.dataset.isManaged());
        }
        if (connection.params.dialect.hasType && StringUtils.isNotBlank((String)this.config.type) && this.dataset.isManaged()) {
            this.config.type = ElasticSearchUtils.normalizeName(this.config.type, this.dataset.isManaged());
        }
        this.esIndex = new ElasticSearchIndex(this.authCtx, connection, this.config, this.dataset);
    }

    private ElasticSearchConnection getConnection() {
        try {
            return ConnectionsDAO.get().getConnectionNoExceptionAs(this.authCtx, this.config.connection, ElasticSearchConnection.class);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Cannot access the connection", (Throwable)e);
        }
    }

    public ElasticSearchIndex getEsIndexForced() throws DKUSecurityException, IOException {
        if (this.esIndex == null) {
            this.initIndex();
        }
        return this.esIndex;
    }

    public ElasticSearchIndex getEsIndexNoCheck() throws DKUSecurityException, IOException {
        if (this.config.type == null) {
            this.config.type = "";
        }
        this.initIndex(false);
        return this.esIndex;
    }

    @Override
    public void close() throws IOException {
        if (this.esIndex != null) {
            this.esIndex.close();
        }
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        return new IndexSplit(null, false);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return new IndexSplit(null, true);
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        this.initIndex();
        return this.esIndex.listPartitions();
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return new IndexSplit(partition, false);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        assert (filter != null);
        this.initIndex();
        FilterResultWithSplits result = new FilterResultWithSplits();
        if (filter.getFilter() != null && filter.getFilter().uiData != null && "ES_QUERY_STRING".equals(filter.getFilter().uiData.mode)) {
            ElasticSearchConnection connection = this.getConnection();
            this.filterQueryStringExpression = FilterDescUtils.getElasticSearchQueryString(filter.getFilter(), connection.params.dialect);
            logger.info((Object)("Setting ES query_string filter to " + this.filterQueryStringExpression));
            result.setNeedsRefilter(false);
        }
        if (!this.esIndex.partitioned) {
            return result.withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
        }
        if (!filter.hasPartitionsFiltering()) {
            for (Partition partition : this.listPartitions()) {
                result.withMatchingPartition(partition).withSplit(this.getPartitionSplit(partition));
            }
        } else {
            for (Partition partition : filter.getPartitionsClause()) {
                result.withMatchingPartition(partition).withSplit(this.getPartitionSplit(partition));
            }
        }
        return result;
    }

    @Override
    public void createManaged() throws Exception {
        this.initIndex();
        if (!this.esIndex.partitioned) {
            this.esIndex.createIndex(this.esIndex.rootIndex, null);
            this.esIndex.updateMapping(this.esIndex.rootIndex);
        }
    }

    @Override
    public void clearAllData() throws Exception {
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.config.connection);
        this.initIndex();
        this.checkClearIsNotDangerous();
        this.esIndex.empty();
    }

    @Override
    public void clearPartitions(List<Partition> partitionIdentifiers) throws Exception {
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.config.connection);
        this.initIndex();
        this.checkClearIsNotDangerous();
        this.esIndex.removePartitions(partitionIdentifiers);
        this.esIndex.addPartitions(partitionIdentifiers);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return this.dataset.isManaged();
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public void checkConfiguration() throws IOException, DKUSecurityException {
        ElasticSearchConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, this.config.connection, ElasticSearchConnection.class);
        this.config.check(connection.params.dialect.hasType);
    }

    @Override
    public String suggestName() {
        if (StringUtils.isBlank((String)this.config.index)) {
            return null;
        }
        try {
            return this.getEsIndexNoCheck().rootIndex;
        }
        catch (DKUSecurityException | IOException e) {
            logger.error((Object)"Failed to init ES client for checking name", e);
            return null;
        }
    }

    @Override
    public long getRecords() throws Exception {
        this.initIndex();
        return this.esIndex.count();
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        this.initIndex();
        return this.esIndex.count(p);
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        try {
            this.initIndex();
            if (this.isManaged()) {
                if (this.esIndex.partitioned) {
                    String index = this.esIndex.getPartitionIndex(p);
                    Pair<Boolean, Boolean> indexAndAlias = this.esIndex.indexExistsWithAlias(index, this.esIndex.rootIndex);
                    if (((Boolean)indexAndAlias.first).booleanValue() && ((Boolean)indexAndAlias.second).booleanValue()) {
                        if (this.dataset.getParams().isNotReadyIfEmpty()) {
                            return RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p));
                        }
                        return DatasetReadiness.ready(null);
                    }
                    return DatasetReadiness.notReady(new IOException("Index " + index + " does not exist or not aliased to " + this.esIndex.rootIndex));
                }
                if (((Boolean)this.esIndex.indexExistsWithAlias((String)this.esIndex.rootIndex, null).first).booleanValue()) {
                    if (this.dataset.getParams().isNotReadyIfEmpty()) {
                        logger.info((Object)("Checking whether partition " + p.id() + " is empty"));
                        return RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p));
                    }
                    return DatasetReadiness.ready(null);
                }
                return DatasetReadiness.notReady(new IOException("Index does not exist: " + this.esIndex.rootIndex));
            }
            if (this.esIndex.indexOrAliasExist(this.esIndex.rootIndex)) {
                if (this.dataset.getParams().isNotReadyIfEmpty()) {
                    logger.info((Object)("Checking whether partition " + p.id() + " is empty"));
                    return RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p));
                }
                return DatasetReadiness.ready(null);
            }
            return DatasetReadiness.notReady(new IOException("Index or alias does not exist: " + this.esIndex.rootIndex));
        }
        catch (Exception e) {
            return DatasetReadiness.error(e);
        }
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return this.listPartitions().contains(this.esIndex.getCanonicalPartition(p));
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.config.connection);
        this.initIndex();
        if (this.isManaged()) {
            this.esIndex.deleteIndexOrIndicesForAlias(this.esIndex.rootIndex, this.dataset.getPartitioningSchema().isPartitioned());
        } else {
            this.checkClearIsNotDangerous();
            this.esIndex.deleteDocsExternal();
        }
    }

    private void checkClearIsNotDangerous() throws CodedSQLException {
        if (this.dataset.isManaged()) {
            return;
        }
        ElasticSearchConnection connection = this.getConnection();
        boolean allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.external." + connection.name + ".allowClear", false);
        try {
            Params p = ConnectionUtils.getParamsFromProperties(connection);
            allowed = p.getBoolParam("dku.connection.externalDatasets.allowClear", allowed);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!allowed) {
            throw new CodedSQLException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Clearing external (i.e., non-managed) datasets in connection " + connection.name + " is forbidden. Do you want to use a managed dataset instead?");
        }
        logger.warnV("Clearing dataset %s on external ElasticSearch connection %s, index %s", new Object[]{this.getDataset().getName(), connection.name, this.esIndex.rootIndex});
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new ElasticSearchDatasetTestHandler(this.authCtx, this);
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.config.connection);
        this.initIndex();
        return new ElasticSearchOutput(this.esIndex, targetPartition, warningsContext);
    }

    @Override
    public boolean executeFastPostCreateOperations() throws IOException {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return this.getMeta().isParallelWritable(this.dataset.getModel().readWriteOptions);
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    public static class Config
    implements DatasetHandler.DatasetParams {
        private static final long serialVersionUID = -1L;
        public String connection;
        public boolean notReadyIfEmpty;
        public String index;
        public String type;
        public String customMapping = null;
        public String rawCopyColumns = null;
        public String customQueryDsl = null;
        public long frameSize = ElasticSearchIndex.DEFAULT_FRAME;
        public ReadTemporalMode readTemporalMode = ReadTemporalMode.AS_IS;
        public boolean partitioned = false;
        public String partitioningColumn = null;
        public String partitioningIndexPattern = null;
        final UnmananagedPartitioningType unmanagedPartitioningType = UnmananagedPartitioningType.COLUMN;

        @Override
        public String getConnection() {
            return this.connection;
        }

        @Override
        public boolean isNotReadyIfEmpty() {
            return this.notReadyIfEmpty;
        }

        public Config getResolved(String projectKey) {
            return (Config)VariablesUtils.expandObjectFields(projectKey, this, new String[]{"index", "type", "customQueryDsl", "partitioningIndexPattern"});
        }

        public void check(boolean hasType) {
            if (!(!StringUtils.isBlank((String)this.index) || this.partitioned && UnmananagedPartitioningType.INDEX.equals((Object)this.unmanagedPartitioningType))) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Missing index parameter");
            }
            if (hasType && StringUtils.isBlank((String)this.type)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Missing type parameter");
            }
            if (this.partitioned && UnmananagedPartitioningType.INDEX.equals((Object)this.unmanagedPartitioningType) && StringUtils.isBlank((String)this.partitioningIndexPattern)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Missing partitioning index parameter");
            }
        }
    }

    class IndexSplit
    extends RowsInputSplit {
        public final String index;
        private final boolean discovery;
        private final Partition partition;

        IndexSplit(Partition partition, boolean discovery) throws DKUSecurityException, IOException {
            ElasticSearchDatasetHandler.this.initIndex();
            this.discovery = discovery;
            this.index = ElasticSearchUtils.normalizeName(ElasticSearchDatasetHandler.this.esIndex.getPartitionIndex(partition), ElasticSearchDatasetHandler.this.esIndex.isManaged());
            this.partition = partition;
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            ElasticSearchDatasetHandler.this.initIndex();
            ElasticSearchIndex.ESQueryBuilder esQueryBuilder = new ElasticSearchIndex.ESQueryBuilder(ElasticSearchDatasetHandler.this.filterQueryStringExpression, ElasticSearchDatasetHandler.this.config.customQueryDsl);
            try {
                ElasticSearchIndex.PushMode pushMode = this.discovery ? ElasticSearchIndex.PushMode.ALL_COLUMNS : ElasticSearchIndex.PushMode.SCHEMA_COLUMNS;
                return ElasticSearchDatasetHandler.this.esIndex.executePush(this.index, ElasticSearchDatasetHandler.this.esIndex.typeUrl, pushMode, this.partition, out, cf, rf, limit, listener, warningsContext, esQueryBuilder);
            }
            catch (PipelineInterruptedException | MemTableAppendingOutput.MemTableSizeLimitReachedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataStoreIOException("Failed to read from connection '" + ElasticSearchDatasetHandler.this.esIndex.connection.name + "'", (Throwable)e);
            }
        }

        public String getDesc() {
            return "/" + this.index + "/" + ElasticSearchDatasetHandler.this.config.type;
        }
    }

    public static class ElasticSearchDatasetMeta
    extends DatasetHandler.NonFSMeta<ElasticSearchDatasetHandler, Config> {
        @Override
        public String getType() {
            return "ElasticSearch";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return Config.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new ElasticSearchDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return false;
        }

        @Override
        public boolean isFS() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return true;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings unused, boolean useExistingParams) {
            dataset.setManaged(true);
            dataset.setType(META.getType());
            Config config = new Config();
            config.connection = targetConnection.name;
            try {
                Object index = ElasticSearchUtils.normalizeName(dataset.getName(), dataset.isManaged());
                ElasticSearchConnection.ElasticSearchManagedDatasetNamingRule namingRule = ((ElasticSearchConnection)targetConnection).params.namingRule;
                if (StringUtils.isNotBlank((String)namingRule.indexNameDatasetNamePrefix)) {
                    index = namingRule.indexNameDatasetNamePrefix + (String)index;
                }
                if (StringUtils.isNotBlank((String)namingRule.indexNameDatasetNameSuffix)) {
                    index = (String)index + namingRule.indexNameDatasetNameSuffix;
                }
                config.index = index;
            }
            catch (IllegalArgumentException e) {
                config.index = "data";
            }
            config.type = config.index;
            dataset.setParams(config);
        }
    }

    public static enum ReadTemporalMode {
        AS_DATE,
        AS_IS;

    }

    public static enum UnmananagedPartitioningType {
        COLUMN,
        INDEX;

    }
}

