/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.FTPConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FTPDatasetHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FTPDatasetTestHandler
extends FSLikeDatasetTestHandler {
    private static Logger logger = Logger.getLogger((String)"dku.input.ftp");

    public FTPDatasetTestHandler(AuthCtx authCtx, FTPDatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) {
        super(authCtx, handlerForData, handlerForName, dataset);
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult ret) throws Exception {
        BuiltinFSDatasets.FTPDatasetConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.FTPDatasetConfig.class);
        if (config.urlMode) {
            if (StringUtils.isBlank((String)config.path)) {
                throw ErrorContext.iae((String)"No URL defined");
            }
        } else {
            boolean passiveParam;
            FTPConnection ftpConn = ConnectionsDAO.get().getMandatoryConnectionAs(this.handlerForData.authCtx, config.connection, FTPConnection.class);
            if (StringUtils.isBlank((String)ftpConn.params.host)) {
                throw ErrorContext.iae((String)"Invalid host");
            }
            ProxySettings proxySettings = ftpConn.getProxySettings();
            if (proxySettings.hasProxy() && proxySettings.isHTTP() && !(passiveParam = ftpConn.params.passive)) {
                throw ErrorContext.iae((String)"HTTP proxy for FTP connections is only supported with passive mode");
            }
        }
        try {
            InputSplit sampleSplit = this.handlerForData.getSampleSplit();
            if (sampleSplit instanceof StreamsInputSplit) {
                ret.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
            }
            ret.connectionOK = true;
            return sampleSplit;
        }
        catch (Exception e) {
            logger.warn((Object)"FTP dataset test failed", (Throwable)e);
            ret.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        return FSDatasetUtils.checkDatasetName(newDatasetName);
    }
}

