/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.LoadedJavaFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.plugin.CustomFSProvider;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.security.AuthCtx;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.log4j.Logger;

public class CustomJavaFSProvider
implements FSProvider {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final LoadedJavaFSProvider loaded;
    private final JsonObject config;
    private final String root;
    private final CustomJavaFSProvidersService customJavaFSProvidersService;
    private CustomFSProvider customFSProvider;
    private static Logger logger = Logger.getLogger((String)"dip.dataset.customfsprovider");

    public CustomJavaFSProvider(LoadedJavaFSProvider loaded, JsonObject config, String root, CustomJavaFSProvidersService customJavaFSProvidersService, AuthCtx authCtx, String projectKey) {
        this.loaded = loaded;
        this.config = config;
        this.root = root;
        this.customJavaFSProvidersService = customJavaFSProvidersService;
        this.authCtx = authCtx;
        this.projectKey = projectKey;
    }

    private CustomFSProvider getCustomProvider() throws IOException, DKUSecurityException {
        if (this.customFSProvider == null) {
            logger.info((Object)"Instantiate custom FS provider");
            try {
                ClassLoader classLoader = this.customJavaFSProvidersService.getClassloader(this.loaded.getType());
                this.customFSProvider = (CustomFSProvider)new PluginClazzLoader(classLoader).loadClazz(((CustomJavaFSProviderDesc)this.loaded.getDesc()).fsProviderClass);
                PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customJavaFSProvidersService.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
                this.customFSProvider.init(this.projectKey, expandedPluginSettings.config, expandedPluginSettings.pluginConfig, this.root);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IOException("Failed to instantiate custom FS provider", e);
            }
        }
        return this.customFSProvider;
    }

    public void close() throws IOException {
        if (this.customFSProvider != null) {
            this.customFSProvider.close();
            this.customFSProvider = null;
        }
    }

    public FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings enumerationSettings) {
        try {
            return this.getCustomProvider().enumerateRecursive(prefix, enumerationSettings);
        }
        catch (Exception e) {
            return new FSEnumerationResult(){

                public boolean isSuccessful() {
                    return false;
                }

                public Iterable<FSPath> getPaths() {
                    return null;
                }

                public Throwable getError() {
                    return e;
                }

                public boolean enumerationPrefixExists() {
                    return false;
                }
            };
        }
    }

    public FSPathOrDirectory stat(String path) throws IOException, CodedException, DKUSecurityException {
        return this.getCustomProvider().stat(path);
    }

    public EnrichedInputStream read(String path) throws IOException, CodedException, DKUSecurityException {
        return this.getCustomProvider().read(path);
    }

    public OutputStream write(String path) throws IOException, CodedException, DKUSecurityException {
        return this.getCustomProvider().write(path);
    }

    public void setLastModified(String path, long lastModified) throws IOException, CodedException, DKUSecurityException {
        this.getCustomProvider().setLastModified(path, lastModified);
    }

    public void deleteRecursive(String path) throws IOException, CodedException, DKUSecurityException {
        this.getCustomProvider().deleteRecursive(path);
    }

    public boolean deleteFile(String path) throws IOException, CodedException, DKUSecurityException {
        return this.getCustomProvider().deleteFile(path);
    }

    public boolean deleteDirectory(String path) throws IOException, CodedException, DKUSecurityException {
        return this.getCustomProvider().deleteDirectory(path);
    }

    public void moveDirectory(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.getCustomProvider().moveDirectory(from, to);
    }

    public void moveFile(String from, String to) throws IOException, CodedException, DKUSecurityException {
        this.getCustomProvider().moveFile(from, to);
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, DKUSecurityException, CodedException {
        return this.getCustomProvider().getAccessInfo(withSensitiveInfo);
    }

    public FSBrowsePath browse(String path, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException, CodedException {
        return this.getCustomProvider().browse(path, strategy);
    }
}

