/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.jobsdb;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetMeta;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Function;
import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.com.google.common.collect.FluentIterable;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class JobsdbDatasetHandler
implements RowOrientedDatasetHandler {
    @Autowired
    private ReadOnlyJobsInternalDB jobsDatabaseService;
    private final JobsdbDatasetParams params;
    private final Dataset dataset;
    public static final JobsdbDatasetMeta META = new JobsdbDatasetMeta();
    private static final Logger logger = Logger.getLogger((String)"dku.datasets.metrics");

    public JobsdbDatasetHandler(Dataset dataset) {
        this.dataset = dataset;
        this.params = dataset.getParamsAs(JobsdbDatasetParams.class);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public void close() {
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new JobsdbDatasetTestHandler(this);
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
    }

    @Override
    public String suggestName() {
        switch (this.params.scope) {
            case INSTANCE: {
                return "instance_metrics";
            }
            case PROJECT: {
                return "project_only_metrics";
            }
            case PROJECT_WHOLE: {
                return "project_metrics";
            }
            case SINGLE_OBJECT: {
                if (!StringUtils.isNotBlank((String)this.params.smartName)) break;
                if (StringUtils.isNotBlank((String)this.params.filter)) {
                    return this.params.smartName + "_" + this.params.filter + "_metrics";
                }
                return this.params.smartName + "_metrics";
            }
        }
        return "metrics";
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return true;
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return false;
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public void createManaged() throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot manage a Metrics dataset");
    }

    @Override
    public void clearAllData() throws Exception {
        logger.info((Object)"Request to clear a metrics dataset: ignored.");
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.info((Object)"Request to clear partitions of a metrics dataset: ignored.");
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        logger.info((Object)"Request to clear a metrics dataset and its structure: ignored.");
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot write on a Metrics dataset");
    }

    @Override
    public boolean outputHandlesClear() {
        throw new Error("Cannot write on a Metrics dataset");
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        return this.getRecords();
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        return DatasetReadiness.ready(null);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        return new FilterResultWithSplits().withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        if (this.params.view == JobsdbDatasetParams.View.METRICS_HISTORY) {
            return new QueryBasedMetricsSplit(false);
        }
        if (this.params.view == JobsdbDatasetParams.View.METRICS_LAST) {
            return new QueryBasedMetricsSplit(true);
        }
        if (this.params.view == JobsdbDatasetParams.View.CHECKS_HISTORY) {
            return new QueryBasedChecksHistorySplit(false);
        }
        if (this.params.view == JobsdbDatasetParams.View.CHECKS_LAST) {
            return new QueryBasedChecksHistorySplit(true);
        }
        throw new IllegalArgumentException("Unknown view type for the jobs db" + String.valueOf((Object)this.params.view));
    }

    private ReadOnlyJobsInternalDB getJobsDatabaseService() {
        if (this.jobsDatabaseService == null) {
            SpringUtils.getInstance().autowire((Object)this);
        }
        return this.jobsDatabaseService;
    }

    @Override
    public long getRecords() throws Exception {
        if (this.params.view == JobsdbDatasetParams.View.METRICS_HISTORY) {
            return this.getJobsDatabaseService().getMetricHistoryCount(this.params.scope, this.resolveObjectForMetrics());
        }
        if (this.params.view == JobsdbDatasetParams.View.METRICS_LAST) {
            return this.getJobsDatabaseService().getMetricLastCount(this.params.scope, this.resolveObjectForMetrics());
        }
        if (this.params.view == JobsdbDatasetParams.View.CHECKS_HISTORY) {
            return this.getJobsDatabaseService().getCheckHistoryCount(this.params.scope, this.resolveObjectForMetrics());
        }
        if (this.params.view == JobsdbDatasetParams.View.CHECKS_LAST) {
            return this.getJobsDatabaseService().getCheckLastCount(this.params.scope, this.resolveObjectForMetrics());
        }
        throw new IllegalArgumentException("Unknown view type for the jobs db" + String.valueOf((Object)this.params.view));
    }

    public AnyLoc resolveObjectForMetrics() {
        if (StringUtils.isBlank((String)this.params.smartName)) {
            return new AnyLoc(this.dataset.getProjectKey(), null);
        }
        return AnyLoc.resolveSmart(this.dataset.getProjectKey(), this.params.smartName);
    }

    public static Schema getSchema(JobsdbDatasetParams.RetrievalScope scope, JobsdbDatasetParams.View view) {
        ArrayList columns = Lists.newArrayList();
        if (scope != JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT) {
            columns.add(new SchemaColumn("projectKey", Type.STRING));
            columns.add(new SchemaColumn("objectId", Type.STRING));
        }
        if (view == JobsdbDatasetParams.View.METRICS_HISTORY || view == JobsdbDatasetParams.View.METRICS_LAST) {
            columns.add(new SchemaColumn("partition", Type.STRING));
            columns.add(new SchemaColumn("metricId", Type.STRING));
            columns.add(new SchemaColumn("timeComputed", Type.DATE));
            columns.add(new SchemaColumn("valueType", Type.STRING));
            columns.add(new SchemaColumn("stringValue", Type.STRING).withForcedMeaning("Text"));
            columns.add(new SchemaColumn("longValue", Type.BIGINT));
            columns.add(new SchemaColumn("doubleValue", Type.DOUBLE));
            columns.add(new SchemaColumn("booleanValue", Type.BOOLEAN));
            columns.add(new SchemaColumn("dateValue", Type.DATE));
        }
        if (view == JobsdbDatasetParams.View.CHECKS_HISTORY || view == JobsdbDatasetParams.View.CHECKS_LAST) {
            columns.add(new SchemaColumn("partition", Type.STRING));
            columns.add(new SchemaColumn("name", Type.STRING));
            columns.add(new SchemaColumn("timeComputed", Type.DATE));
            columns.add(new SchemaColumn("outcome", Type.STRING));
            columns.add(new SchemaColumn("message", Type.STRING));
        }
        return new Schema((List)columns, false);
    }

    private String quoteIdentifier(String identifier) {
        return this.getJobsDatabaseService().getDialect().quoteIdentifier(identifier);
    }

    private String quoteString(String str) {
        return this.getJobsDatabaseService().getDialect().quoteString(str);
    }

    private String quotedNullString() {
        return this.quoteString("__null__");
    }

    private String buildPartitionFilter() {
        if (StringUtils.isNotBlank((String)this.params.partition)) {
            return FluentIterable.from((Object[])this.params.partition.split(",")).transform((Function)new Function<String, Object>(){

                public Object apply(String s) {
                    return JobsdbDatasetHandler.this.quoteIdentifier("PARTITION") + " = " + JobsdbDatasetHandler.this.quoteString(s);
                }
            }).join(Joiner.on((String)" OR "));
        }
        return null;
    }

    class QueryBasedMetricsSplit
    extends RowsInputSplit {
        long rowsPushed = 0L;
        private final boolean last;

        QueryBasedMetricsSplit(boolean last) {
            this.last = last;
        }

        @Override
        public long push(final ProcessorOutput out, ColumnFactory cf, final RowFactory rf, final ExtractionLimit limit, final InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            final Column projectKeyColumn = JobsdbDatasetHandler.this.params.scope == JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT ? null : cf.column("projectKey");
            final Column objectIdColumn = JobsdbDatasetHandler.this.params.scope == JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT ? null : cf.column("objectId");
            final Column partitionColumn = cf.column("partition");
            final Column metricIdColumn = cf.column("metricId");
            final Column timeComputeColumn = cf.column("timeComputed");
            final Column valueTypeColumn = cf.column("valueType");
            final Column stringValueColumn = cf.column("stringValue");
            final Column longValueColumn = cf.column("longValue");
            final Column booleanValueColumn = cf.column("booleanValue");
            final Column dateValueColumn = cf.column("dateValue");
            final Column doubleValueColumn = cf.column("doubleValue");
            final long rowsBefore = listener == null ? 0L : listener.getReadRecords();
            final AnyLoc loc = JobsdbDatasetHandler.this.resolveObjectForMetrics();
            final Boolean booleanMeaning = new Boolean();
            final Date dateMeaning = new Date();
            final DoubleMeaning doubleMeaning = new DoubleMeaning();
            final LongMeaning longMeaning = new LongMeaning();
            logger.info((Object)("List metrics of " + loc.getFullName()));
            final String partitionFilter = JobsdbDatasetHandler.this.buildPartitionFilter();
            ReadOnlyJobsInternalDB.MetricDataPointConsumer consumer = new ReadOnlyJobsInternalDB.MetricDataPointConsumer(){

                @Override
                public void setParameters(PreparedStatement select) throws SQLException {
                    int nextIndex = 1;
                    if (StringUtils.isNotBlank((String)JobsdbDatasetHandler.this.params.filter)) {
                        select.setString(nextIndex++, JobsdbDatasetHandler.this.params.filter);
                    }
                    switch (JobsdbDatasetHandler.this.params.scope) {
                        case INSTANCE: {
                            break;
                        }
                        case PROJECT: {
                            select.setString(nextIndex++, loc.getProjectKey());
                            break;
                        }
                        case PROJECT_WHOLE: {
                            select.setString(nextIndex++, loc.getProjectKey());
                            break;
                        }
                        case SINGLE_OBJECT: {
                            select.setString(nextIndex++, loc.getProjectKey());
                            ReadOnlyJobsInternalDB.setNotNullStringParameter(select, nextIndex++, loc.getId(), "__null__");
                        }
                    }
                }

                @Override
                public boolean handle(ReadOnlyJobsInternalDB.MetricDataPoint point) throws Exception {
                    Row r = rf.row();
                    if (projectKeyColumn != null) {
                        r.put(projectKeyColumn, point.projectKey);
                    }
                    if (objectIdColumn != null) {
                        r.put(objectIdColumn, point.objectId);
                    }
                    r.put(partitionColumn, point.partition);
                    r.put(metricIdColumn, point.metric.getId());
                    r.put(timeComputeColumn, DKUtils.isoFormatReadableByDateFormat((long)point.time));
                    r.put(valueTypeColumn, point.type.name());
                    r.put(stringValueColumn, point.value);
                    try {
                        switch (point.type) {
                            case BIGINT: 
                            case INT: 
                            case SMALLINT: 
                            case TINYINT: {
                                r.put(longValueColumn, longMeaning.permissiveLongValue(point.value));
                                break;
                            }
                            case BOOLEAN: {
                                r.put(booleanValueColumn, booleanMeaning.parse(point.value));
                                break;
                            }
                            case DATE: {
                                r.put(dateValueColumn, DKUtils.isoFormatReadableByDateFormat((long)dateMeaning.longValue(point.value)));
                                break;
                            }
                            case DOUBLE: 
                            case FLOAT: {
                                r.put(doubleValueColumn, doubleMeaning.doubleValue(point.value));
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++QueryBasedMetricsSplit.this.rowsPushed;
                    if (QueryBasedMetricsSplit.this.rowsPushed % 100L == 0L) {
                        if (listener != null) {
                            listener.setData(0L, 0L, rowsBefore + QueryBasedMetricsSplit.this.rowsPushed);
                        }
                        FutureProgressState.checkInterrupt();
                        if (QueryBasedMetricsSplit.this.rowsPushed % 2000L == 0L) {
                            logger.info((Object)("Read " + QueryBasedMetricsSplit.this.rowsPushed + " records from DB"));
                        }
                    }
                    out.emitRow(r);
                    return limit == null || limit.maxRecords <= 0L || QueryBasedMetricsSplit.this.rowsPushed < limit.maxRecords;
                }

                @Override
                public String getFilterClause(boolean last) {
                    ArrayList<CallSite> elts = new ArrayList<CallSite>();
                    if (StringUtils.isNotBlank((String)JobsdbDatasetHandler.this.params.filter)) {
                        elts.add((CallSite)((Object)((last ? "s." : "h.") + JobsdbDatasetHandler.this.quoteIdentifier("METRIC_ID") + " = ?")));
                    }
                    if (partitionFilter != null) {
                        elts.add((CallSite)((Object)("(" + partitionFilter + ")")));
                    }
                    switch (JobsdbDatasetHandler.this.params.scope) {
                        case INSTANCE: {
                            break;
                        }
                        case PROJECT: {
                            elts.add((CallSite)((Object)("s." + JobsdbDatasetHandler.this.quoteIdentifier("PROJECT_KEY") + " = ? and s." + JobsdbDatasetHandler.this.quoteIdentifier("OBJECT_ID") + " = " + JobsdbDatasetHandler.this.quotedNullString())));
                            break;
                        }
                        case PROJECT_WHOLE: {
                            elts.add((CallSite)((Object)("s." + JobsdbDatasetHandler.this.quoteIdentifier("PROJECT_KEY") + " = ?")));
                            break;
                        }
                        case SINGLE_OBJECT: {
                            elts.add((CallSite)((Object)("s." + JobsdbDatasetHandler.this.quoteIdentifier("PROJECT_KEY") + " = ? AND s." + JobsdbDatasetHandler.this.quoteIdentifier("OBJECT_ID") + " = ?")));
                        }
                    }
                    return StringUtils.join(elts, (String)" AND ");
                }

                @Override
                public boolean caresAboutOrder() {
                    return false;
                }
            };
            if (this.last) {
                JobsdbDatasetHandler.this.getJobsDatabaseService().readLastMetrics(consumer);
            } else {
                JobsdbDatasetHandler.this.getJobsDatabaseService().readMetrics(consumer);
            }
            return this.rowsPushed;
        }

        public String getDesc() {
            return "JobsDb_metrics";
        }
    }

    class QueryBasedChecksHistorySplit
    extends RowsInputSplit {
        long rowsPushed = 0L;
        private final boolean last;

        public QueryBasedChecksHistorySplit(boolean last) {
            this.last = last;
        }

        @Override
        public long push(final ProcessorOutput out, ColumnFactory cf, final RowFactory rf, final ExtractionLimit limit, final InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            final long rowsBefore = listener == null ? 0L : listener.getReadRecords();
            final AnyLoc loc = JobsdbDatasetHandler.this.resolveObjectForMetrics();
            final Column projectKeyColumn = JobsdbDatasetHandler.this.params.scope == JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT ? null : cf.column("projectKey");
            final Column objectIdColumn = JobsdbDatasetHandler.this.params.scope == JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT ? null : cf.column("objectId");
            final Column partitionColumn = cf.column("partition");
            final Column nameColumn = cf.column("name");
            final Column timeComputeColumn = cf.column("timeComputed");
            final Column outcomeColumn = cf.column("outcome");
            final Column messageColumn = cf.column("message");
            logger.info((Object)("List checks of " + loc.getFullName()));
            final String partitionFilter = JobsdbDatasetHandler.this.buildPartitionFilter();
            ReadOnlyJobsInternalDB.CheckDataPointConsumer consumer = new ReadOnlyJobsInternalDB.CheckDataPointConsumer(){

                @Override
                public void setParameters(PreparedStatement select) throws SQLException {
                    int nextIndex = 1;
                    if (StringUtils.isNotBlank((String)JobsdbDatasetHandler.this.params.filter)) {
                        select.setString(nextIndex++, JobsdbDatasetHandler.this.params.filter);
                    }
                    switch (JobsdbDatasetHandler.this.params.scope) {
                        case INSTANCE: {
                            break;
                        }
                        case PROJECT: {
                            select.setString(nextIndex++, loc.getProjectKey());
                            break;
                        }
                        case PROJECT_WHOLE: {
                            select.setString(nextIndex++, loc.getProjectKey());
                            break;
                        }
                        case SINGLE_OBJECT: {
                            select.setString(nextIndex++, loc.getProjectKey());
                            ReadOnlyJobsInternalDB.setNotNullStringParameter(select, nextIndex++, loc.getId(), "__null__");
                        }
                    }
                }

                @Override
                public boolean handle(ReadOnlyJobsInternalDB.CheckDataPoint point) throws Exception {
                    Row r = rf.row();
                    if (projectKeyColumn != null) {
                        r.put(projectKeyColumn, point.projectKey);
                    }
                    if (objectIdColumn != null) {
                        r.put(objectIdColumn, point.objectId);
                    }
                    r.put(partitionColumn, point.partition);
                    DataQualityRule rule = point.check;
                    rule.updateDisplayName();
                    r.put(nameColumn, rule.getDisplayName());
                    r.put(timeComputeColumn, DKUtils.isoFormatReadableByDateFormat((long)point.time));
                    r.put(outcomeColumn, point.outcome.name());
                    r.put(messageColumn, point.message);
                    ++QueryBasedChecksHistorySplit.this.rowsPushed;
                    if (QueryBasedChecksHistorySplit.this.rowsPushed % 100L == 0L) {
                        if (listener != null) {
                            listener.setData(0L, 0L, rowsBefore + QueryBasedChecksHistorySplit.this.rowsPushed);
                        }
                        FutureProgressState.checkInterrupt();
                        if (QueryBasedChecksHistorySplit.this.rowsPushed % 2000L == 0L) {
                            logger.info((Object)("Read " + QueryBasedChecksHistorySplit.this.rowsPushed + " records from DB"));
                        }
                    }
                    out.emitRow(r);
                    return limit == null || limit.maxRecords <= 0L || QueryBasedChecksHistorySplit.this.rowsPushed < limit.maxRecords;
                }

                @Override
                public String getFilterClause(boolean last) {
                    ArrayList<CallSite> elts = new ArrayList<CallSite>();
                    if (StringUtils.isNotBlank((String)JobsdbDatasetHandler.this.params.filter)) {
                        elts.add((CallSite)((Object)((last ? "s." : "h.") + JobsdbDatasetHandler.this.quoteIdentifier("NAME") + " = ?")));
                    }
                    if (partitionFilter != null) {
                        elts.add((CallSite)((Object)("(" + partitionFilter + ")")));
                    }
                    switch (JobsdbDatasetHandler.this.params.scope) {
                        case INSTANCE: {
                            break;
                        }
                        case PROJECT: {
                            elts.add((CallSite)((Object)("s." + JobsdbDatasetHandler.this.quoteIdentifier("PROJECT_KEY") + " = ? and s." + JobsdbDatasetHandler.this.quoteIdentifier("OBJECT_ID") + " = " + JobsdbDatasetHandler.this.quotedNullString())));
                            break;
                        }
                        case PROJECT_WHOLE: {
                            elts.add((CallSite)((Object)("s." + JobsdbDatasetHandler.this.quoteIdentifier("PROJECT_KEY") + " = ?")));
                            break;
                        }
                        case SINGLE_OBJECT: {
                            elts.add((CallSite)((Object)("s." + JobsdbDatasetHandler.this.quoteIdentifier("PROJECT_KEY") + " = ? AND s." + JobsdbDatasetHandler.this.quoteIdentifier("OBJECT_ID") + " = ?")));
                        }
                    }
                    return StringUtils.join(elts, (String)" AND ");
                }

                @Override
                public boolean caresAboutOrder() {
                    return false;
                }
            };
            if (this.last) {
                JobsdbDatasetHandler.this.getJobsDatabaseService().readLastChecks(consumer);
            } else {
                JobsdbDatasetHandler.this.getJobsDatabaseService().readChecks(consumer);
            }
            return this.rowsPushed;
        }

        public String getDesc() {
            return "JobsDb_checks";
        }
    }
}

