/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.twitter;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.DelegateFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetTestHandler;
import com.dataiku.dip.datasets.twitter.TwitterDatasetConfig;
import com.dataiku.dip.datasets.twitter.TwitterDatasetUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import java.io.IOException;

public class TwitterDatasetHandler
extends DelegateFSDatasetHandler {
    public static final TwitterDatasetMeta META = new TwitterDatasetMeta();

    public TwitterDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    @Override
    protected void buildReal() throws IOException {
        this.setRealDataset(TwitterDatasetUtils.generateTwitterOutputDataset(this.dataset));
        assert (DatasetInspector.isFS(this.getRealDataset()));
        this.setRealHandler((AbstractFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.getRealDataset()));
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
        assert (this.dataset.getParams() instanceof TwitterDatasetConfig);
    }

    @Override
    public String suggestName() {
        TwitterDatasetConfig config = this.dataset.getParamsAs(TwitterDatasetConfig.class);
        if (config.keywords != null && config.keywords.size() > 0) {
            return "twitter-" + config.keywords.get(0);
        }
        return "twitter";
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new FilesystemDatasetTestHandler(this.authCtx, (FilesystemDatasetHandler)this.getRealHandler(), (DatasetHandler)this, this.getRealDataset());
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        this.createManaged();
        return false;
    }

    public static class TwitterDatasetMeta
    extends DatasetHandler.NonFSMeta<TwitterDatasetHandler, TwitterDatasetConfig> {
        @Override
        public String getType() {
            return "Twitter";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return TwitterDatasetConfig.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            return new TwitterDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return true;
        }

        @Override
        public boolean isFS() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isParallelWritable() {
            return false;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings unused, boolean useExistingParams) {
            throw new Error("unreachable");
        }
    }
}

