/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.discussions;

import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionsInternalDB;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.DiscussionsUnreadFullIdsChanged;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiscussionsCacheService {
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private DiscussionsInternalDB discussionsDao;
    private boolean cacheReady = false;
    private Map<String, Set<String>> unreadCache = new HashMap<String, Set<String>>();
    private Map<TaggableObjectsService.TaggableObjectRef, Set<String>> countsCache = new HashMap<TaggableObjectsService.TaggableObjectRef, Set<String>>();
    static DKULogger logger = DKULogger.getLogger((String)"dku.discussions.cache");

    @PostConstruct
    public void init() {
        this.recomputeCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getUnreadCount(String login, boolean waitsReady) {
        if (!waitsReady && !this.cacheReady) {
            return null;
        }
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            return this.getUnreadForUser(login).size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUnreadDiscussionsFullIds(String login, boolean waitsReady) {
        if (!waitsReady && !this.cacheReady) {
            return null;
        }
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            return new HashSet<String>(this.getUnreadForUser(login));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getDiscussionsCount(TaggableObjectsService.TaggableObjectRef tor, boolean waitsReady) {
        if (!waitsReady && !this.cacheReady) {
            return null;
        }
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            return this.getCountsForObject(tor).size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDiscussionsFullIds(TaggableObjectsService.TaggableObjectRef tor, boolean waitsReady) {
        if (!waitsReady && !this.cacheReady) {
            return null;
        }
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            return new HashSet<String>(this.getCountsForObject(tor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String projectKey, String workspaceKey, String discussionId, String login) {
        DiscussionsUnreadFullIdsChanged evt = null;
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            Set<String> userCache = this.getUnreadForUser(login);
            String fullId = this.getCacheKey(projectKey, workspaceKey, discussionId);
            if (userCache.contains(fullId)) {
                userCache.remove(fullId);
                evt = new DiscussionsUnreadFullIdsChanged(login, new HashSet<String>(userCache));
            }
        }
        if (evt != null) {
            this.pubSub.publish(evt);
        }
    }

    private String getCacheKey(String projectKey, String workspaceKey, String discussionId) {
        if (StringUtils.isNotBlank((String)workspaceKey)) {
            return String.join((CharSequence)".", projectKey, discussionId, workspaceKey);
        }
        return String.join((CharSequence)".", projectKey, discussionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(TaggableObjectsService.TaggableObjectRef tor, String discussionId, String author) throws NotFoundException, SQLException {
        Discussion discussion = this.discussionsDao.getDiscussion(tor.projectKey, tor.workspaceKey, discussionId);
        if (discussion.closedOn == 0L) {
            Set<String> watchers = this.interestsService.getEffectiveWatchingUsers_NT(tor.type, tor.projectKey, tor.id, author, tor.workspaceKey);
            ArrayList<DiscussionsUnreadFullIdsChanged> events = new ArrayList<DiscussionsUnreadFullIdsChanged>(watchers.size());
            DiscussionsCacheService discussionsCacheService = this;
            synchronized (discussionsCacheService) {
                String fullId = this.getCacheKey(tor.projectKey, tor.workspaceKey, discussionId);
                Set<String> objCountsCache = this.getCountsForObject(tor);
                objCountsCache.add(fullId);
                for (String login : watchers) {
                    Set<String> userCache = this.getUnreadForUser(login);
                    if (userCache.contains(fullId)) continue;
                    userCache.add(fullId);
                    events.add(new DiscussionsUnreadFullIdsChanged(login, new HashSet<String>(userCache)));
                }
            }
            for (DiscussionsUnreadFullIdsChanged e : events) {
                this.pubSub.publish(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> importDiscussion_NoEvent(Discussion discussion) throws NotFoundException, SQLException {
        HashSet<String> affectedUsers = new HashSet<String>();
        if (discussion.closedOn == 0L) {
            Set<String> watchers = this.interestsService.getEffectiveWatchingUsers_NT(discussion.objectType, discussion.projectKey, discussion.objectId, null, discussion.workspaceKey);
            DiscussionsCacheService discussionsCacheService = this;
            synchronized (discussionsCacheService) {
                String fullId = this.getCacheKey(discussion.projectKey, discussion.workspaceKey, discussion.id);
                Set<String> objCountsCache = this.getCountsForObject(new TaggableObjectsService.TaggableObjectRef(discussion.projectKey, discussion.objectType, discussion.objectId, discussion.workspaceKey));
                objCountsCache.add(fullId);
                for (String login : watchers) {
                    Set<String> userCache = this.getUnreadForUser(login);
                    if (userCache.contains(fullId)) continue;
                    userCache.add(fullId);
                    affectedUsers.add(login);
                }
            }
        }
        return affectedUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> deleteDiscussion(TaggableObjectsService.TaggableObjectRef tor, String discussionId, boolean sendEvents) {
        ArrayList<DiscussionsUnreadFullIdsChanged> events = new ArrayList<DiscussionsUnreadFullIdsChanged>();
        HashSet<String> affectedUsers = new HashSet<String>();
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            String fullId = this.getCacheKey(tor.projectKey, tor.workspaceKey, discussionId);
            Set<String> objCountsCache = this.getCountsForObject(tor);
            objCountsCache.remove(fullId);
            for (Map.Entry<String, Set<String>> e : this.unreadCache.entrySet()) {
                String login = e.getKey();
                Set<String> userCache = e.getValue();
                if (!userCache.contains(fullId)) continue;
                userCache.remove(fullId);
                affectedUsers.add(login);
                if (!sendEvents) continue;
                events.add(new DiscussionsUnreadFullIdsChanged(login, new HashSet<String>(userCache)));
            }
        }
        for (DiscussionsUnreadFullIdsChanged e : events) {
            this.pubSub.publish(e);
        }
        return affectedUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProject(String projectKey) {
        HashMap<String, DiscussionsUnreadFullIdsChanged> events = new HashMap<String, DiscussionsUnreadFullIdsChanged>();
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            for (TaggableObjectsService.TaggableObjectRef taggableObjectRef : this.countsCache.keySet()) {
                if (!taggableObjectRef.projectKey.equals(projectKey)) continue;
                this.countsCache.remove(taggableObjectRef);
            }
            for (Map.Entry entry : this.unreadCache.entrySet()) {
                String login = (String)entry.getKey();
                Set userCache = (Set)entry.getValue();
                Iterator it = userCache.iterator();
                boolean hasRemoved = false;
                while (it.hasNext()) {
                    String discussionFullId = (String)it.next();
                    if (!discussionFullId.startsWith(projectKey + ".")) continue;
                    it.remove();
                    hasRemoved = true;
                }
                if (!hasRemoved) continue;
                events.put(login, new DiscussionsUnreadFullIdsChanged(login, new HashSet<String>(userCache)));
            }
        }
        for (DiscussionsUnreadFullIdsChanged e : events.values()) {
            this.pubSub.publish(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String login) {
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            this.unreadCache.remove(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchChanged(String login, String projectKey, String workspaceKey) throws Exception {
        HashSet<String> newUnreadFullIds;
        HashSet<String> unreadFullIds;
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            unreadFullIds = new HashSet<String>(this.getUnreadForUser(login));
            if (StringUtils.isNotBlank((String)workspaceKey)) {
                this.refreshUnreadCacheForWorkspaceAndUser(login, workspaceKey);
            } else {
                this.refreshUnreadCacheForProjectAndUser(login, projectKey);
            }
            newUnreadFullIds = new HashSet<String>(this.getUnreadForUser(login));
        }
        if (newUnreadFullIds == null && unreadFullIds != null && !unreadFullIds.isEmpty() || newUnreadFullIds != null && !newUnreadFullIds.equals(unreadFullIds)) {
            this.pubSub.publish(new DiscussionsUnreadFullIdsChanged(login, newUnreadFullIds));
        }
    }

    public void close(TaggableObjectsService.TaggableObjectRef tor, String discussionId, boolean closed) {
        if (closed) {
            this.deleteDiscussion(tor, discussionId, true);
        } else {
            this.recomputeCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeTaggableObjectRef(ITaggingService.TaggableType type, String projectKey, String oldName, String newName) {
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            HashMap<TaggableObjectsService.TaggableObjectRef, Set<String>> toAdd = new HashMap<TaggableObjectsService.TaggableObjectRef, Set<String>>();
            Iterator<Map.Entry<TaggableObjectsService.TaggableObjectRef, Set<String>>> it = this.countsCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TaggableObjectsService.TaggableObjectRef, Set<String>> entry = it.next();
                TaggableObjectsService.TaggableObjectRef ref = entry.getKey();
                if (!projectKey.equals(ref.projectKey) || ref.type != type || !oldName.equals(ref.id)) continue;
                it.remove();
                toAdd.put(new TaggableObjectsService.TaggableObjectRef(projectKey, type, newName, ref.workspaceKey), entry.getValue());
            }
            this.countsCache.putAll(toAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeCache() {
        DiscussionsCacheService discussionsCacheService = this;
        synchronized (discussionsCacheService) {
            try {
                logger.info((Object)"Read all watches to fill unread cache");
                Map<String, Map<TaggableObjectsService.TaggableObjectRef, InterestsInternalDB.RawInterest>> watchesPerUser = this.interestsService.getAllWatches();
                logger.info((Object)"Read all discussions to fill unread cache");
                Map<TaggableObjectsService.TaggableObjectRef, List<Discussion>> discussions = this.discussionsDao.getAllDiscussions();
                logger.info((Object)"Read all discussions acks to fill unread cache");
                Map<String, Map<String, Long>> lastReadTimePerUser = this.discussionsDao.getAllLastReadTimes();
                logger.info((Object)"Fill discussions count cache");
                this.fillDiscussionsCount(discussions);
                logger.info((Object)"Fill unread discussions cache");
                this.fillUnreadDiscussionsCache(watchesPerUser, lastReadTimePerUser, discussions);
                this.cacheReady = true;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to recompute unread discussions cache", (Throwable)e);
            }
        }
    }

    private void refreshUnreadCacheForProjectAndUser(String user, String projectKey) throws Exception {
        HashMap lastReadTimes = this.discussionsDao.getAllLastReadTimes().get(user);
        if (lastReadTimes == null) {
            lastReadTimes = Maps.newHashMap();
        }
        List<InterestsInternalDB.TaggableObjectRefWithInterest> interests = this.interestsService.getUserInterestsForProject_NT(user, projectKey);
        HashMap watches = Maps.newHashMap();
        for (InterestsInternalDB.TaggableObjectRefWithInterest torwi : interests) {
            watches.put(new TaggableObjectsService.TaggableObjectRef(torwi.projectKey, torwi.objectType, torwi.objectId, torwi.workspaceKey), new InterestsInternalDB.RawInterest(torwi.watching, torwi.starred));
        }
        List<Discussion> discussions = this.discussionsDao.getDiscussionsForProjectNoReplies(projectKey);
        this.fillUnreadDiscussionsCacheForUser(discussions, watches, lastReadTimes, user);
    }

    private void refreshUnreadCacheForWorkspaceAndUser(String user, String workspaceKey) throws Exception {
        HashMap lastReadTimes = this.discussionsDao.getAllLastReadTimes().get(user);
        if (lastReadTimes == null) {
            lastReadTimes = Maps.newHashMap();
        }
        List<InterestsInternalDB.TaggableObjectRefWithInterest> interests = this.interestsService.getUserInterestsForWorkspace_NT(user, workspaceKey);
        HashMap watches = Maps.newHashMap();
        for (InterestsInternalDB.TaggableObjectRefWithInterest torwi : interests) {
            watches.put(new TaggableObjectsService.TaggableObjectRef(torwi.projectKey, torwi.objectType, torwi.objectId, torwi.workspaceKey), new InterestsInternalDB.RawInterest(torwi.watching, torwi.starred));
        }
        List<Discussion> discussions = this.discussionsDao.getDiscussionsForWorkspaceNoReplies(workspaceKey);
        this.fillUnreadDiscussionsCacheForUser(discussions, watches, lastReadTimes, user);
    }

    private void fillUnreadDiscussionsCache(Map<String, Map<TaggableObjectsService.TaggableObjectRef, InterestsInternalDB.RawInterest>> watchesPerUser, Map<String, Map<String, Long>> lastReadTimePerUser, Map<TaggableObjectsService.TaggableObjectRef, List<Discussion>> discussions) {
        for (Map.Entry<String, Map<TaggableObjectsService.TaggableObjectRef, InterestsInternalDB.RawInterest>> entry : watchesPerUser.entrySet()) {
            String user = entry.getKey();
            Map<TaggableObjectsService.TaggableObjectRef, InterestsInternalDB.RawInterest> watches = entry.getValue();
            Map<String, Long> lastReadTimes = lastReadTimePerUser.get(user);
            if (lastReadTimes == null) {
                lastReadTimes = new HashMap<String, Long>();
            }
            for (List<Discussion> convs : discussions.values()) {
                this.fillUnreadDiscussionsCacheForUser(convs, watches, lastReadTimes, user);
            }
        }
    }

    private void fillUnreadDiscussionsCacheForUser(List<Discussion> discussions, Map<TaggableObjectsService.TaggableObjectRef, InterestsInternalDB.RawInterest> watches, Map<String, Long> lastReadTimes, String user) {
        TaggableObjectsService.TaggableObjectRef tor;
        Set<String> userCache = this.getUnreadForUser(user);
        HashSet<String> deepWatchedProjects = new HashSet<String>();
        for (Map.Entry<TaggableObjectsService.TaggableObjectRef, InterestsInternalDB.RawInterest> entry : watches.entrySet()) {
            tor = entry.getKey();
            if (tor.type != ITaggingService.TaggableType.PROJECT || entry.getValue().watching != InterestsInternalDB.Watching.YES) continue;
            deepWatchedProjects.add(tor.projectKey);
        }
        for (Discussion discussion : discussions) {
            tor = new TaggableObjectsService.TaggableObjectRef(discussion.projectKey, discussion.objectType, discussion.objectId, discussion.workspaceKey);
            String fullId = this.getCacheKey(discussion.projectKey, discussion.workspaceKey, discussion.id);
            if ((deepWatchedProjects.contains(tor.projectKey) || watches.containsKey(tor)) && discussion.closedOn == 0L && !this.wasRead(discussion, lastReadTimes)) {
                userCache.add(fullId);
                continue;
            }
            userCache.remove(fullId);
        }
    }

    private void fillDiscussionsCount(Map<TaggableObjectsService.TaggableObjectRef, List<Discussion>> discussions) {
        for (Map.Entry<TaggableObjectsService.TaggableObjectRef, List<Discussion>> e : discussions.entrySet()) {
            for (Discussion c2 : e.getValue()) {
                if (c2.closedOn != 0L) continue;
                if (!this.countsCache.containsKey(e.getKey())) {
                    this.countsCache.put(e.getKey(), new HashSet());
                }
                this.countsCache.get(e.getKey()).add(c2.projectKey + "." + c2.id);
            }
        }
    }

    private boolean wasRead(Discussion discussion, Map<String, Long> lastReadTimes) {
        long lastReply = discussion.lastReplyTime;
        if (lastReply == 0L) {
            return true;
        }
        String fullId = this.getCacheKey(discussion.projectKey, discussion.workspaceKey, discussion.id);
        Long lastRead = lastReadTimes.get(fullId);
        if (lastRead == null) {
            return false;
        }
        return lastRead >= lastReply;
    }

    private Set<String> getUnreadForUser(String login) {
        if (!this.unreadCache.containsKey(login)) {
            this.unreadCache.put(login, new HashSet());
        }
        return this.unreadCache.get(login);
    }

    private Set<String> getCountsForObject(TaggableObjectsService.TaggableObjectRef tor) {
        if (!this.countsCache.containsKey(tor)) {
            this.countsCache.put(tor, new HashSet());
        }
        return this.countsCache.get(tor);
    }
}

