/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.discussions;

import com.dataiku.dip.dao.InterestsInternalDB;
import com.dataiku.dip.discussions.DiscussionsCacheService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermInSetQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InboxService {
    private static final int MAX_TERMS_LENGTH = 65536;
    private static final int MAX_SHOULD_LENGTH = 1024;
    @Autowired
    private IInternalDataCatalogService catalogService;
    @Autowired
    private DiscussionsCacheService unreadDiscussionsService;
    @Autowired
    private InterestsService interestsService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.discussions.inbox");

    public InboxSearchResponse search(String query, Map<String, List<String>> facetMap, AuthCtx authCtx, @Nullable String explainDocId) throws Exception {
        if (facetMap == null) {
            facetMap = new HashMap<String, List<String>>();
        }
        facetMap.put("_type", Lists.newArrayList((Object[])new String[]{IndexableType.DISCUSSION.index()}));
        List<InterestsInternalDB.TaggableObjectRefWithInterest> watchedItems = this.interestsService.getUserInterests_NT((String)authCtx.getIdentifier(), (int)0, null, (int)Integer.MAX_VALUE, (boolean)false).interests;
        BooleanQuery.Builder objFilterLucene = new BooleanQuery.Builder();
        int nbOfShoulds = 0;
        HashSet deepWatchedProjects = Sets.newHashSet();
        for (InterestsInternalDB.TaggableObjectRefWithInterest tor : watchedItems) {
            if (tor.objectType != ITaggingService.TaggableType.PROJECT || tor.watching != InterestsInternalDB.Watching.YES || facetMap.containsKey("projectKey.raw") && !facetMap.get("projectKey.raw").contains(tor.projectKey)) continue;
            deepWatchedProjects.add(tor.projectKey);
        }
        Object[] deepWatchedProjectsList = new String[deepWatchedProjects.size()];
        deepWatchedProjects.toArray(deepWatchedProjectsList);
        for (int i = 0; i < deepWatchedProjectsList.length; i += 65536) {
            if (nbOfShoulds >= 1024) {
                logger.warn((Object)"Cannot retrieve all the discussions");
                break;
            }
            String[] deepWatchedProjectsSubList = (String[])ArrayUtils.subarray((Object[])deepWatchedProjectsList, (int)i, (int)(i + 65536));
            List discussionList = Arrays.stream(deepWatchedProjectsSubList).map(BytesRef::new).collect(Collectors.toList());
            objFilterLucene.add((Query)new TermInSetQuery("projectKey.raw", discussionList), BooleanClause.Occur.SHOULD);
            ++nbOfShoulds;
        }
        HashSet torIds = Sets.newHashSet();
        for (InterestsInternalDB.TaggableObjectRefWithInterest tor : watchedItems) {
            if (deepWatchedProjects.contains(tor.projectKey) || facetMap.containsKey("projectKey.raw") && !facetMap.get("projectKey.raw").contains(tor.projectKey) || facetMap.containsKey("objectType") && !facetMap.get("objectType").contains(tor.objectType.toString().toLowerCase())) continue;
            torIds.add(InboxService.objectKey(tor));
        }
        Object[] torIdsList = new String[torIds.size()];
        torIds.toArray(torIdsList);
        for (int i = 0; i < torIdsList.length; i += 65536) {
            if (nbOfShoulds >= 1024) {
                logger.warn((Object)"Cannot retrieve all the discussions");
                break;
            }
            String[] torIdsSubList = (String[])ArrayUtils.subarray((Object[])torIdsList, (int)i, (int)(i + 65536));
            List discussionList = Arrays.stream(torIdsSubList).map(BytesRef::new).collect(Collectors.toList());
            objFilterLucene.add((Query)new TermInSetQuery("tor", discussionList), BooleanClause.Occur.SHOULD);
            ++nbOfShoulds;
        }
        LuceneResponseWrapper resultsLucene = this.catalogService.searchInternal(query, facetMap, authCtx, IInternalDataCatalogService.Options.getDefaultOptions().withExplainDocId(explainDocId).withExplainDocType(IndexableType.DISCUSSION.index()), (Query)objFilterLucene.build());
        InboxSearchResponse response = new InboxSearchResponse();
        response.setResults(resultsLucene);
        response.unreadDiscussionFullIds = this.unreadDiscussionsService.getUnreadDiscussionsFullIds(authCtx.getIdentifier(), true);
        return response;
    }

    private static String objectKey(InterestsInternalDB.TaggableObjectRefWithInterest tor) {
        return String.format("%s.%s.%s.%s", StringUtils.defaultString((String)tor.projectKey, (String)""), tor.objectType.name(), tor.objectId, StringUtils.defaultString((String)tor.workspaceKey, (String)""));
    }

    public static class InboxSearchResponse {
        JsonObject results;
        Set<String> unreadDiscussionFullIds = new HashSet<String>();

        public void setResults(LuceneResponseWrapper results) {
            this.results = (JsonObject)JSON.parse((String)results.serializeHits(), JsonObject.class);
        }
    }
}

