/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.recipes.nlp.rag_embedding.RAGEmbeddingRecipeCreator;
import javax.annotation.Nullable;

public class VLMExtractor {
    private static final String VLM_DEFAULT_EXTRACTION_PROMPT = "Generate a concise summary, up to %d characters, derived from the screenshot(s) of document page(s) provided.\nBegin with a brief overview and highlight crucial words, facts, or concepts to enhance both semantic and keyword searchability.\nOmit any references to the original source.\n";

    private VLMExtractor() {
        throw new IllegalStateException("Utility class");
    }

    public static String getVlmDefaultExtractionPrompt(@Nullable Integer maxTokensLimit) {
        return String.format(VLM_DEFAULT_EXTRACTION_PROMPT, RAGEmbeddingRecipeCreator.adaptDefaultChunkSizeCharacters(maxTokensLimit));
    }

    public static class VLMExtractorSettings {
        public int windowSize;
        public int windowOverlap;
        public String llmId;
        public String llmPrompt;

        public String toString() {
            return "windowSize=" + this.windowSize + ", windowOverlap=" + this.windowOverlap + ", llmId=" + this.llmId + ", llmPrompt='" + this.llmPrompt + "'";
        }
    }

    public static class VLMInputs {
        public InputRefs.ImagesRef imagesRef;
    }

    public static class VLMExtractorRequest {
        public VLMInputs inputs = new VLMInputs();
        public VLMExtractorSettings settings = new VLMExtractorSettings();

        public VLMExtractorRequest() {
        }

        public VLMExtractorRequest(InputRefs.ImagesRef imagesRef, VLMExtractorSettings settings) {
            this.inputs.imagesRef = imagesRef;
            this.settings = settings;
        }
    }
}

