/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eventserver;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.FilesBasedConnectionsDAO;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.impl.FilesBasedUsersDAO;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.eventserver.ConfigurationServlet;
import com.dataiku.dip.eventserver.EventServlet;
import com.dataiku.dip.eventserver.ProcessingQueue;
import com.dataiku.dip.eventserver.StatsServlet;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.NoopFutureKernelsManager;
import com.dataiku.dip.license.DKULicenseStatusService;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.security.UserBasicService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.security.model.CredentialsService;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.DKUNoGitTransactionService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.MainUtils;
import com.dataiku.dip.variables.BackendVariablesService;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Connector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import jakarta.servlet.Servlet;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;

public class EventServerMain {
    private static Logger logger;

    public static void main(String[] args) throws Exception {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.EVENTSERVER);
        DKUApp.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.EVENTSERVER);
        long init = System.currentTimeMillis();
        try {
            if (System.getenv("DKU_EVENTSERVER_PORT") == null) {
                throw new IllegalArgumentException("Missing DKU_EVENTSERVER_PORT environment variable");
            }
            if (System.getenv("DKUINSTALLDIR") == null) {
                throw new IllegalArgumentException("Missing DKUINSTALLDIR environment variable");
            }
            MainLoggingConfigurator.configureLimits();
            MainUtils.printHello((String)"eventserver");
            BuiltinsLoader.load();
            DKUtils.forceInit(FormatParams.class);
            ScriptStep.loadClass();
            logger.info((Object)"Initial load complete");
            try (AnnotationConfigApplicationContext appContext = new AnnotationConfigApplicationContext();){
                appContext.register(new Class[]{SpringUtils.class});
                appContext.register(new Class[]{ProcessingQueue.class});
                appContext.register(new Class[]{AuthCtxCreationService.class});
                appContext.register(new Class[]{FutureService.class});
                appContext.register(new Class[]{NoopFutureKernelsManager.class});
                appContext.register(new Class[]{AchievementsService.class});
                appContext.register(new Class[]{PubSubService.class});
                appContext.register(new Class[]{DKUNoGitTransactionService.class});
                appContext.register(new Class[]{DKULicenseStatusService.class});
                appContext.register(new Class[]{BackendVariablesService.class});
                appContext.register(new Class[]{ScenarioRunContext.class});
                appContext.register(new Class[]{RegularPasswordEncryptionService.class});
                appContext.register(new Class[]{SharedSecretAuthService.class});
                appContext.register(new Class[]{FilesBasedConnectionsDAO.class});
                appContext.register(new Class[]{GeneralSettingsDAO.class});
                appContext.register(new Class[]{FilesBasedUsersDAO.class});
                appContext.register(new Class[]{UserBasicService.class});
                appContext.register(new Class[]{NodesDirectoryService.class});
                appContext.register(new Class[]{CredentialsService.class});
                appContext.register(new Class[]{AWSClientBrokerService.class});
                appContext.refresh();
                appContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new CommonAnnotationBeanPostProcessor());
                long servicesReady = System.currentTimeMillis();
                logger.info((Object)("Services ready after " + (servicesReady - init) + "ms"));
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        logger.info((Object)"Event server shutdown requested, shutting down event handlers");
                        ((ProcessingQueue)SpringUtils.getBean(ProcessingQueue.class)).shutdown();
                    }
                });
                DSSMetrics.registerJVMMetrics();
                DSSMetrics.startJMXReporter();
                SharedSecretUtils.getSharedSecret((boolean)true);
                Integer backendPort = Integer.parseInt(System.getenv("DKU_EVENTSERVER_PORT"));
                logger.info((Object)("Starting on port " + backendPort));
                Server server = new Server(backendPort.intValue());
                HttpConfiguration httpConfig = JettyUtils.createHttpConfiguration();
                HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
                ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{http});
                connector.setIdleTimeout(-1L);
                connector.setPort(backendPort.intValue());
                server.setConnectors((Connector[])new ServerConnector[]{connector});
                ServletContextHandler sch = ServletUtils.createServletContext((int)100000000, (String)"/");
                logger.info((Object)"Creating the servlets");
                sch.addServlet(new ServletHolder((Servlet)new EventServlet()), "/events/*");
                sch.addServlet(new ServletHolder((Servlet)new ConfigurationServlet()), "/configure/*");
                sch.addServlet(new ServletHolder((Servlet)new StatsServlet()), "/stats/*");
                JettyUtils.addHandlers((Server)server, (ServletContextHandler)sch);
                logger.info((Object)"Loaded the servlets");
                server.start();
                long serverStarted = System.currentTimeMillis();
                logger.info((Object)("Server started after " + (serverStarted - servicesReady) + "ms"));
                server.join();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Server start failed", (Throwable)e);
            System.exit(1);
        }
    }

    static {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        logger = Logger.getLogger((String)"dku");
    }
}

