/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelIntrinsicPerf;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ExportTimeseriesResiduals
implements ExportInput {
    private final FullModelId fullModelId;
    private ColumnFactory columnFactory;
    private RowFactory rowFactory;
    private Set<String> identifierColumns = Set.of();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.ml.timeseries.residuals.export");

    public ExportTimeseriesResiduals(FullModelId fullModelId) {
        this.fullModelId = fullModelId;
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) throws Exception {
        this.rowFactory = new StreamRowFactory();
        this.columnFactory = cf;
        File residualsFolder = DKUFileUtils.getWithin((File)this.fullModelId.getMainFolder(), (String[])new String[]{"residuals"});
        Map identifiersMapping = (Map)JSON.parseFile((File)DKUFileUtils.getWithinFollowLink((File)residualsFolder, (String[])new String[]{"identifiers_mapping.json"}), Map.class);
        try {
            this.identifierColumns = new TreeSet(JSON.parseToMap((String)((String)identifiersMapping.keySet().toArray()[0])).keySet());
        }
        catch (JsonSyntaxException e) {
            logger.info((Object)"No identifiers columns. Single-ts residuals export.");
        }
    }

    @Override
    public long getInputSize() {
        try {
            PredictionModelIntrinsicPerf iperf = FullModelId.getPredictionIntrinsicPerf(this.fullModelId.getModelFolder(), PredictionMLTask.PredictionType.TIMESERIES_FORECAST);
            return iperf.modelInputNRows;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ExportInput.InputDescription describe() {
        ExportInput.InputDescription description = new ExportInput.InputDescription();
        description.name = "Timeseries residuals";
        description.projectKey = this.fullModelId.getProjectKey();
        description.description = "Export this model's residuals";
        return description;
    }

    @Override
    public Schema getSchema() throws Exception {
        Schema schema = new Schema();
        this.identifierColumns.forEach(idCol -> schema.addColumn(idCol, Type.STRING));
        schema.addColumn("dates", Type.DATE);
        schema.addColumn("target", Type.STRING);
        schema.addColumn("fittedValues", Type.DOUBLE);
        schema.addColumn("residuals", Type.DOUBLE);
        schema.addColumn("stdResiduals", Type.DOUBLE);
        schema.addColumn("theoreticalQuantiles", Type.DOUBLE);
        return schema;
    }

    @Override
    public void stream(ProcessorOutput output) throws Exception {
        CSVFormatConfig config = CSVFormatConfig.getStandardTabUNIXFormat();
        File residualsFolder = DKUFileUtils.getWithin((File)this.fullModelId.getMainFolder(), (String[])new String[]{"residuals"});
        List residualsFiles = DKUFileUtils.listFiles((File)residualsFolder).stream().filter(f -> f.getName().endsWith(".csv.gz")).collect(Collectors.toList());
        ArrayList<Column> schemaColumns = new ArrayList<Column>();
        for (SchemaColumn sc : this.getSchema().columns) {
            schemaColumns.add(this.columnFactory.column(sc.getName()));
        }
        for (File residualsFile : residualsFiles) {
            InputStream inputStream = DKUFileUtils.readWithAutoDecompress((File)residualsFile);
            RFC4180CSVParser csvParser = new RFC4180CSVParser((LineReader)new InputStreamLineReader(inputStream, config.charset), config.getSeparatorChar());
            ArrayList<String> csvRow = new ArrayList<String>();
            while (csvParser.next(csvRow)) {
                int csvRowNumCols = csvRow.size();
                Row row = this.rowFactory.row();
                for (int i = 0; i < csvRowNumCols; ++i) {
                    row.put((Column)schemaColumns.get(i), (String)csvRow.get(i));
                }
                output.emitRow(row);
            }
        }
        output.lastRowEmitted();
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return DSSFuturePayloadUtils.forFMI(this.fullModelId);
    }

    @Override
    public void close() {
    }
}

