/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.expressions;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.Pair;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.functions.Get;
import com.google.refine.expr.functions.dataiku.Numval;
import com.google.refine.expr.functions.dataiku.Rand;
import com.google.refine.expr.functions.dataiku.Strval;
import com.google.refine.expr.functions.dataiku.Val;
import com.google.refine.expr.functions.date.Now;
import com.google.refine.expr.functions.math.Pi;
import com.google.refine.grel.Control;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.ast.ControlCallExpr;
import com.google.refine.grel.ast.FieldAccessorExpr;
import com.google.refine.grel.ast.FunctionCallExpr;
import com.google.refine.grel.ast.LiteralExpr;
import com.google.refine.grel.ast.OperatorCallExpr;
import com.google.refine.grel.ast.VariableExpr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;

public abstract class GrelTranslator {
    public ControlFunctionRegistry registry;
    protected Expression originalExpression;
    protected boolean translateFully;
    protected Evaluable root;
    protected boolean isFullyTranslated;
    protected GrelMapping mapping;

    public GrelTranslator(GrelMapping mapping, ControlFunctionRegistry registry) {
        this.mapping = mapping;
        this.registry = registry;
    }

    public GrelTranslator(GrelMapping mapping) {
        this(mapping, GrelControlFunctionRegistry.getInstance());
    }

    protected boolean isConstant(Evaluable ev) {
        if (ev instanceof LiteralExpr) {
            return true;
        }
        if (ev instanceof VariableExpr || ev instanceof FieldAccessorExpr) {
            return false;
        }
        Evaluable[] args = new Evaluable[]{};
        if (ev instanceof ControlCallExpr) {
            args = ((ControlCallExpr)ev)._args;
        } else if (ev instanceof FunctionCallExpr) {
            FunctionCallExpr f = (FunctionCallExpr)ev;
            if (f._function instanceof Val || f._function instanceof Numval || f._function instanceof Strval || f._function instanceof Now || f._function instanceof Rand) {
                return false;
            }
            args = f._args;
        } else if (ev instanceof OperatorCallExpr) {
            args = ((OperatorCallExpr)ev)._args;
        }
        for (Evaluable arg : args) {
            if (this.isConstant(arg)) continue;
            return false;
        }
        return true;
    }

    protected Evaluable precompute(Evaluable ev, Properties bindings) {
        Evaluable[] args = new Evaluable[]{};
        if (ev instanceof ControlCallExpr) {
            args = ((ControlCallExpr)ev)._args;
        } else if (ev instanceof FunctionCallExpr) {
            FunctionCallExpr f = (FunctionCallExpr)ev;
            args = f._args;
            if (f._function instanceof Val || f._function instanceof Numval || f._function instanceof Strval) {
                VariableExpr variableExpr;
                if (args.length != 1 && f._function instanceof Numval) {
                    throw ErrorContext.iaef((String)"%s takes exactly one argument. Offset argument is not available in this context.", (Object)this.registry.getFunctionName(f._function), (Object[])new Object[0]);
                }
                if (args.length != 1 && args.length != 2) {
                    throw ErrorContext.iaef((String)"%s takes one or two argument. Offset argument is not available in this context.", (Object)this.registry.getFunctionName(f._function), (Object[])new Object[0]);
                }
                try {
                    Object arg0Evaluated = args[0].evaluate(null);
                    if (arg0Evaluated instanceof EvalError) {
                        throw ErrorContext.iaef((String)"%s cannot be translated to SQL, cannot statically evaluate its argument: %s", (Object)this.registry.getFunctionName(f._function), (Object[])new Object[]{((EvalError)arg0Evaluated).message});
                    }
                    variableExpr = new VariableExpr(arg0Evaluated.toString());
                }
                catch (NullPointerException e) {
                    throw ErrorContext.iaef((String)"%s cannot be translated to SQL, its first argument contains a variable", (Object)this.registry.getFunctionName(f._function), (Object[])new Object[0]);
                }
                if (StringUtils.isEmpty((String)variableExpr._name)) {
                    throw ErrorContext.iaef((String)"%s needs a non-empty argument", (Object)this.registry.getFunctionName(f._function), (Object[])new Object[0]);
                }
                SchemaColumn knownType = this.originalExpression.getSchemaColumnIfKnown(variableExpr._name);
                Evaluable castedVariableExpr = knownType != null && f._function instanceof Strval && knownType.getType() != Type.STRING ? new FunctionCallExpr(new Evaluable[]{variableExpr}, this.registry.getFunction("toString")) : (knownType != null && f._function instanceof Numval && !knownType.getType().isNumeric() ? new FunctionCallExpr(new Evaluable[]{variableExpr}, this.registry.getFunction("toNumber")) : variableExpr);
                if (args.length == 2) {
                    Evaluable castedDefaultValue = f._function instanceof Strval ? new FunctionCallExpr(new Evaluable[]{args[1]}, this.registry.getFunction("toString")) : args[1];
                    ControlCallExpr hasValue = new ControlCallExpr(new Evaluable[]{variableExpr}, this.registry.getControl("isNonBlank"));
                    ControlCallExpr res = new ControlCallExpr(new Evaluable[]{hasValue, castedVariableExpr, castedDefaultValue}, this.registry.getControl("if"));
                    return res;
                }
                return castedVariableExpr;
            }
            if (f._function instanceof Get && bindings != null) {
                if (args.length > 1 && GrelTranslator.isVariablesExpr(args[0])) {
                    return GrelTranslator.evaluateVariable(f, bindings);
                }
            } else if (f._function instanceof Pi) {
                if (args.length > 0) {
                    throw ErrorContext.iaef((String)"%s does not take any argument", (Object)this.registry.getFunctionName(f._function), (Object[])new Object[0]);
                }
                return new LiteralExpr(Math.PI);
            }
        } else if (ev instanceof OperatorCallExpr) {
            args = ((OperatorCallExpr)ev)._args;
        } else if (ev instanceof FieldAccessorExpr && bindings != null && GrelTranslator.isVariablesExpr(((FieldAccessorExpr)ev)._inner)) {
            return GrelTranslator.evaluateVariable(ev, bindings);
        }
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (this.isConstant(args[i])) {
                    Object precomputed = args[i].evaluate(new Properties());
                    if (precomputed instanceof EvalError) {
                        throw new IllegalArgumentException(((EvalError)precomputed).message);
                    }
                    args[i] = new LiteralExpr(precomputed);
                    continue;
                }
                args[i] = this.precompute(args[i], bindings);
            }
            if (ev instanceof ControlCallExpr) {
                return new ControlCallExpr(args, ((ControlCallExpr)ev)._control);
            }
            if (ev instanceof FunctionCallExpr) {
                return new FunctionCallExpr(args, ((FunctionCallExpr)ev)._function);
            }
            if (ev instanceof OperatorCallExpr) {
                return new OperatorCallExpr(args, ((OperatorCallExpr)ev)._op);
            }
        }
        return ev;
    }

    protected Evaluable prune(Evaluable e) {
        if (e instanceof LiteralExpr || e instanceof VariableExpr) {
            return e;
        }
        if (e instanceof OperatorCallExpr) {
            OperatorCallExpr op = (OperatorCallExpr)e;
            if (!this.mapping.isTranslatable(op._op, op._args)) {
                this.isFullyTranslated = false;
                if (this.translateFully) {
                    throw new NonTranslatableOperatorException(op._op);
                }
                return null;
            }
            ArrayList<Evaluable> prunedTerms = new ArrayList<Evaluable>(op._args.length);
            for (Evaluable term : op._args) {
                Evaluable prunedTerm = this.prune(term);
                if (prunedTerm != null) {
                    prunedTerms.add(prunedTerm);
                    continue;
                }
                if (op._op.equals("&&")) continue;
                return null;
            }
            if (prunedTerms.isEmpty()) {
                return null;
            }
            return new OperatorCallExpr(prunedTerms.toArray(new Evaluable[0]), op._op);
        }
        if (e instanceof FunctionCallExpr || e instanceof ControlCallExpr) {
            Evaluable[] args;
            String functionName;
            if (e instanceof FunctionCallExpr) {
                FunctionCallExpr f = (FunctionCallExpr)e;
                functionName = this.registry.getFunctionName(f._function);
                args = f._args;
            } else {
                ControlCallExpr c2 = (ControlCallExpr)e;
                functionName = this.registry.getControlName(c2._control);
                args = c2._args;
            }
            if (!this.mapping.isTranslatable(functionName, args)) {
                this.isFullyTranslated = false;
                if (this.translateFully) {
                    throw new NonTranslatableOperatorException(functionName);
                }
                return null;
            }
            for (int i = 0; i < args.length; ++i) {
                Evaluable prunedArg = this.prune(args[i]);
                if (prunedArg == null) {
                    return null;
                }
                args[i] = prunedArg;
            }
            return e;
        }
        this.isFullyTranslated = false;
        if (this.translateFully) {
            throw new NonTranslatableOperatorException("<unknwown>");
        }
        return null;
    }

    protected String getGrelName(Function function) {
        return this.registry.getFunctionName(function);
    }

    protected String getGrelName(Control ctrl) {
        return this.registry.getControlName(ctrl);
    }

    protected boolean preprocessExpression(Expression expression) {
        if (expression == null || expression.getString() == null || expression.getString().isEmpty()) {
            throw new IllegalArgumentException("Empty expression");
        }
        try {
            this.isFullyTranslated = true;
            this.originalExpression = expression;
            this.root = this.prune(this.precompute(expression.evaluable, ExpressionUtils.createBindings(expression.variablesContext)));
        }
        catch (NonTranslatableOperatorException e) {
            throw new IllegalArgumentException("Operator cannot be translated to SQL: " + e.getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expression: \"" + expression.getString() + "\" is invalid: " + e.getMessage(), e);
        }
        return this.isFullyTranslated;
    }

    private static boolean isVariablesExpr(Evaluable expr) {
        return expr instanceof VariableExpr && "variables".equals(((VariableExpr)expr)._name);
    }

    private static Evaluable evaluateVariable(Evaluable ev, Properties bindings) {
        Object v = ev.evaluate(bindings);
        if (ExpressionUtils.isError(v)) {
            throw new IllegalArgumentException(v.toString());
        }
        return new LiteralExpr(v);
    }

    public static abstract class GrelMapping {
        protected Map<String, QueryUtils.OperatorType> operatorsMap = new HashMap<String, QueryUtils.OperatorType>();
        protected Map<String, Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>>> conditionalOperatorsMap = new HashMap<String, Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>>>();
        protected Map<String, ArgsPreparation> preparationsMap = new HashMap<String, ArgsPreparation>();
        protected Map<String, DynamicOp> dynamicOpsMap = new HashMap<String, DynamicOp>();

        public GrelMapping withOp(String opGrelName, QueryUtils.OperatorType dssOpType) {
            this.operatorsMap.put(opGrelName, dssOpType);
            return this;
        }

        public GrelMapping withOp(String opGrelName, Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>> predicate) {
            this.conditionalOperatorsMap.put(opGrelName, predicate);
            return this;
        }

        public GrelMapping withOp(String opGrelName, QueryUtils.OperatorType dssOpType, ArgsPreparation preparation) {
            this.operatorsMap.put(opGrelName, dssOpType);
            this.preparationsMap.put(opGrelName, preparation);
            return this;
        }

        public GrelMapping withDynamicOp(String opGrelName, DynamicOp dynamicOp) {
            this.dynamicOpsMap.put(opGrelName, dynamicOp);
            return this;
        }

        public ExpressionBuilder[] getOperatorDssArgs(String opGrelName, ExpressionBuilder[] args) {
            if (this.preparationsMap.containsKey(opGrelName)) {
                return this.preparationsMap.get(opGrelName).prepare(args);
            }
            return args;
        }

        public DynamicOp getDynamicOp(String opGrelName) {
            return this.dynamicOpsMap.get(opGrelName);
        }

        public QueryUtils.OperatorType getOperatorDssName(String opGrelName, Evaluable[] evaluableArgs) {
            if (this.conditionalOperatorsMap.containsKey(opGrelName)) {
                Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>> pair = this.conditionalOperatorsMap.get(opGrelName);
                if (((Predicate)pair.second).test(evaluableArgs)) {
                    return (QueryUtils.OperatorType)((Object)pair.first);
                }
            }
            return this.operatorsMap.get(opGrelName);
        }

        public boolean isTranslatable(String operationName, Evaluable[] args) {
            return this.getDynamicOp(operationName) != null || this.getOperatorDssName(operationName, args) != null;
        }

        public abstract String translateToString(QueryAst.Expr var1);

        public static interface ArgsPreparation {
            public ExpressionBuilder[] prepare(ExpressionBuilder[] var1);
        }

        public static interface DynamicOp {
            public ExpressionBuilder translate(String var1, Evaluable[] var2, ExpressionBuilder[] var3);
        }
    }

    public static class NonTranslatableOperatorException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public NonTranslatableOperatorException(String operatorName) {
            super(operatorName);
        }
    }

    public static class TranslationResult<T> {
        public final boolean isFullyTranslated;
        public final T result;

        public TranslationResult(T result, boolean isFullyTranslated) {
            this.result = result;
            this.isFullyTranslated = isFullyTranslated;
        }
    }
}

