/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.excel.model.ExcelWorkbook;
import com.dataiku.dip.formats.excel.model.ExcelWorkbookBinary;
import com.dataiku.dip.formats.excel.model.ExcelWorkbookClassic;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.StreamingReader;
import com.dataiku.dss.shadelibpoi.org.apache.poi.EncryptedDocumentException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.OPCPackage;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.PackageAccess;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.PackagePart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.PackageRelationship;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.Decryptor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.EncryptionInfo;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFRelation;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbookFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ExcelFilesAnalyzer {
    private static final int XLSX_READER_BUFFER_SIZE = 65536;
    private static final byte[] XLS_SIGNATURE = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] XLSX_SIGNATURE = new byte[]{80, 75, 3, 4};
    private static final Logger logger = Logger.getLogger((String)"dku.format.excel");

    public static boolean isExcelFileType(String filename) {
        String lowerCaseFilename = filename.toLowerCase(Locale.ROOT);
        for (String validExtension : new String[]{".xlsx", ".xls", ".xltx", ".xlsm", ".xlt", ".xltm", ".xlsb"}) {
            if (!lowerCaseFilename.endsWith(validExtension)) continue;
            return true;
        }
        return false;
    }

    public static List<String> listSheetNames(InputStream is, @Nullable String password) throws Exception {
        try (ExcelWorkbook wb = ExcelFilesAnalyzer.readWorkbook(is, password);){
            List<String> list = wb.listSheetNames();
            return list;
        }
    }

    public static ExcelWorkbook readWorkbook(EnrichedInputStream eis, @Nullable String password) throws IOException, InterruptedException, CodedException, DKUSecurityException, EncryptedFileException {
        try (InputStream inputStream = eis.decompressedStream();){
            ExcelWorkbook excelWorkbook = ExcelFilesAnalyzer.readWorkbook(inputStream, password);
            return excelWorkbook;
        }
    }

    public static ExcelWorkbook readWorkbook(InputStream inputStream, String password) throws IOException, EncryptedFileException {
        BufferedInputStream is = new BufferedInputStream(inputStream, 8192);
        ExcelFileType excelFileType = ExcelFilesAnalyzer.detectExcelFileType(is);
        File tmpFile = ExcelFilesAnalyzer.createTemporaryFile(is);
        try {
            if (excelFileType == ExcelFileType.XLS) {
                return ExcelFilesAnalyzer.readOLE2Workbook(tmpFile, password);
            }
            return ExcelFilesAnalyzer.readOOXMLWorkbook(tmpFile, password);
        }
        catch (EncryptedFileException | IOException | RuntimeException e) {
            ExcelFilesAnalyzer.deleteTemporaryFile(tmpFile);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private static ExcelWorkbook readOLE2Workbook(File tmpFile, String password) throws IOException, EncryptedFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ExcelWorkbook readOOXMLWorkbook(File tmpFile, String password) throws IOException, EncryptedFileException {
        try {
            Workbook workbook = StreamingReader.builder().bufferSize(65536).password(password).open(tmpFile);
            return new ExcelWorkbookClassic(workbook, tmpFile);
        }
        catch (RuntimeException streamingException) {
            logger.debug((Object)"Unable to read XLSX file using streaming reader. Falling back to classic reader");
            try {
                OPCPackage pkg = OPCPackage.open((File)tmpFile, (PackageAccess)PackageAccess.READ);
                if (ExcelFilesAnalyzer.isContentTypeXLSB(pkg)) {
                    logger.debug((Object)"Detected XLSB file. Using dedicated reader");
                    return new ExcelWorkbookBinary(pkg, tmpFile);
                }
                return new ExcelWorkbookClassic((Workbook)XSSFWorkbookFactory.createWorkbook((OPCPackage)pkg), tmpFile);
            }
            catch (EncryptedDocumentException e) {
                logger.error((Object)"Failed to open encrypted OOXML Excel file", (Throwable)e);
                throw new EncryptedFileException(e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)"Failed to open OOXML Excel file", (Throwable)e);
                throw new IOException("Failed to open Excel file", e);
            }
        }
    }

    private static File decryptPackage(POIFSFileSystem fs, String password) throws IOException, EncryptedFileException {
        InputStream dataStream;
        Decryptor d = Decryptor.getInstance((EncryptionInfo)new EncryptionInfo(fs));
        try {
            if (!d.verifyPassword(password)) {
                throw new EncryptedFileException("Invalid password");
            }
            dataStream = d.getDataStream(fs);
        }
        catch (GeneralSecurityException ex) {
            throw new IOException("Unable to decrypt encrypted OLE2 encrypted XLSX file", ex);
        }
        return ExcelFilesAnalyzer.createTemporaryFile(dataStream);
    }

    private static boolean isContentTypeXLSB(OPCPackage pkg) {
        try {
            PackageRelationship coreRel = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
            if (coreRel != null) {
                PackagePart pp = pkg.getPart(coreRel);
                return pp != null && pp.getContentType().equals(XSSFRelation.XLSB_BINARY_WORKBOOK.getContentType());
            }
        }
        catch (RuntimeException e) {
            logger.trace((Object)"Unable to determine content type", (Throwable)e);
        }
        return false;
    }

    private static File createTemporaryFile(InputStream is) throws IOException {
        Path tempFilePath = Files.createTempFile("xls-reader", "tmp", new FileAttribute[0]);
        try {
            Files.copy(is, tempFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            ExcelFilesAnalyzer.deleteTemporaryFile(tempFilePath.toFile());
            throw e;
        }
        return tempFilePath.toFile();
    }

    private static void deleteTemporaryFile(File tmpFile) {
        try {
            DKUFileUtils.forceDelete((File)tmpFile);
        }
        catch (IOException e) {
            logger.error((Object)("Unable to delete temporary file: " + tmpFile.getAbsolutePath()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExcelFileType detectExcelFileType(InputStream bis) throws IOException {
        int signatureLength = Math.max(XLSX_SIGNATURE.length, XLS_SIGNATURE.length);
        bis.mark(signatureLength);
        try {
            byte[] signature = new byte[signatureLength];
            int bytesRead = bis.read(signature);
            if (bytesRead < signatureLength) {
                throw new IOException(String.format("Unable to read Excel file signature. Could only read %d bytes from stream", bytesRead));
            }
            if (Arrays.equals(Arrays.copyOfRange(signature, 0, XLSX_SIGNATURE.length), XLSX_SIGNATURE)) {
                ExcelFileType excelFileType = ExcelFileType.XLSX;
                return excelFileType;
            }
            if (Arrays.equals(Arrays.copyOfRange(signature, 0, XLS_SIGNATURE.length), XLS_SIGNATURE)) {
                ExcelFileType excelFileType = ExcelFileType.XLS;
                return excelFileType;
            }
            logger.warn((Object)"Unable to detect Excel file type");
            ExcelFileType excelFileType = ExcelFileType.XLSX;
            return excelFileType;
        }
        finally {
            bis.reset();
        }
    }

    public static enum ExcelFileType {
        XLSX,
        XLS;

    }

    public static class EncryptedFileException
    extends Exception {
        public EncryptedFileException(String message) {
            super(message);
        }
    }
}

