/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.SerializedDatasetAdapter;
import com.dataiku.dip.datasets.custompython.CustomJavaDatasetMeta;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetMeta;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetMeta;
import com.dataiku.dip.datasets.sample.SampleDatasetMeta;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnavailableDSSObjectException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DatasetHandlerFactory {
    public static final String CUSTOM_PYTHON = "CustomPython";
    public static final String CUSTOM_JAVA = "CustomJava";
    public static final String SAMPLE = "Sample";
    public static final String FS_PROVIDER = "fsprovider";
    private static final Map<String, DatasetHandler.DatasetMeta<?, ?>> datasetLibrary = new LinkedHashMap();

    public static DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        DatasetHandler.DatasetMeta<?, ?> datasetMeta = DatasetHandlerFactory.getMeta(dataset);
        if (dataset.getOverrideTable() != null) {
            VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
            VariablesContext vc = vs.getContext(dataset.getProjectKey());
            SerializedDataset sd = dataset.serialize();
            SerializedDataset modifiedSD = dataset.getOverrideTable().overrideObject(vc, sd, SerializedDataset.class);
            Dataset modifiedDataset = Dataset.fromSerialized(dataset.getFullName(), modifiedSD);
            return datasetMeta.build(authCtx, modifiedDataset);
        }
        return datasetMeta.build(authCtx, dataset);
    }

    public static DatasetHandler.DatasetMeta<?, ?> getMeta(Dataset dataset) {
        return DatasetHandlerFactory.getMeta(dataset.getType());
    }

    public static synchronized DatasetHandler.DatasetMeta<?, ?> getMeta(String type) {
        if (datasetLibrary.containsKey(type)) {
            return datasetLibrary.get(type);
        }
        if (type.startsWith(FS_PROVIDER)) {
            throw UnavailableDSSObjectException.fromObjectTypeAndType(FS_PROVIDER, type);
        }
        if (type.startsWith(CUSTOM_PYTHON)) {
            throw UnavailableDSSObjectException.fromObjectTypeAndType(CUSTOM_PYTHON, type);
        }
        if (type.startsWith(CUSTOM_JAVA)) {
            throw UnavailableDSSObjectException.fromObjectTypeAndType(CUSTOM_JAVA, type);
        }
        if (type.startsWith(SAMPLE)) {
            throw UnavailableDSSObjectException.fromObjectTypeAndType(SAMPLE, type);
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_TYPE, "Unknown dataset type " + type);
    }

    public static synchronized Iterable<DatasetHandler.DatasetMeta<?, ?>> getAllMeta() {
        return new ArrayList(datasetLibrary.values());
    }

    public static synchronized boolean hasParamsClass(String type) {
        return datasetLibrary.containsKey(type);
    }

    public static Class<? extends DatasetHandler.DatasetParams> getParamsClass(String type) {
        return DatasetHandlerFactory.getMeta(type).paramsClass();
    }

    public static <T extends DatasetTestHandler> T buildTestHandlerAs(AuthCtx authCtx, Dataset dataset, Class<T> clazz) throws IOException, CodedException, DKUSecurityException {
        DatasetHandler dh = DatasetHandlerFactory.build(authCtx, dataset);
        if (dh instanceof UploadedFilesDatasetHandler) {
            ((UploadedFilesDatasetHandler)dh).setForFormatTestOnly();
        }
        DatasetTestHandler testHandler = (DatasetTestHandler)clazz.cast(dh.buildTestHandler());
        SpringUtils.getInstance().autowire((Object)testHandler);
        return (T)testHandler;
    }

    public static synchronized void registerDatasetType(DatasetHandler.DatasetMeta<?, ?> meta) {
        SerializedDatasetAdapter.registerType(meta.getType(), meta.paramsClass());
        datasetLibrary.put(meta.getType(), meta);
    }

    public static synchronized void deregisterDatasetType(String type) {
        SerializedDatasetAdapter.deregisterType(type);
        datasetLibrary.remove(type);
    }

    public static String nameFromFileName(String filename) {
        String ret;
        Object[] extChunks = StringUtils.split((String)filename, (String)".");
        if (extChunks.length == 1) {
            ret = extChunks[0];
        } else if (extChunks.length >= 2) {
            int nbChuksToRemove;
            for (nbChuksToRemove = 1; Arrays.asList("7z", "tar", "bz2", "gz", "rar", "zip", "zipx").contains(extChunks[extChunks.length - nbChuksToRemove].toLowerCase()) && nbChuksToRemove < extChunks.length - 1; ++nbChuksToRemove) {
            }
            ret = StringUtils.join((Object[])ArrayUtils.subarray((Object[])extChunks, (int)0, (int)(extChunks.length - nbChuksToRemove)));
        } else {
            return null;
        }
        if (ret.startsWith("/") && ret.length() > 1) {
            ret = ret.substring(1);
        }
        return ret;
    }

    public static void checkDuplicateDatasetMeta(String pluginId, String componentId, String datasetType, Class<? extends DatasetHandler.DatasetMeta> metaClass) throws IOException {
        for (DatasetHandler.DatasetMeta<?, ?> datasetMeta : DatasetHandlerFactory.getAllMeta()) {
            String datasetMetaPluginId;
            if (!datasetMeta.getType().equals(datasetType)) continue;
            if (!metaClass.isInstance(datasetMeta)) {
                String otherDatasetDescr = datasetMeta instanceof CustomPythonDatasetMeta || datasetMeta instanceof CustomJavaDatasetMeta || datasetMeta instanceof CustomFSProviderDatasetMeta ? "another custom dataset" : "another dataset";
                throw new IOException("The dataset type '" + datasetType + "' is already registered by " + otherDatasetDescr);
            }
            if (datasetMeta instanceof CustomPythonDatasetMeta) {
                datasetMetaPluginId = ((CustomPythonDatasetMeta)datasetMeta).getDesc().getOwnerPluginId();
            } else if (datasetMeta instanceof CustomJavaDatasetMeta) {
                datasetMetaPluginId = ((CustomJavaDatasetMeta)datasetMeta).getDesc().getOwnerPluginId();
            } else if (datasetMeta instanceof CustomFSProviderDatasetMeta) {
                datasetMetaPluginId = ((CustomFSProviderDatasetMeta)datasetMeta).getDesc().getOwnerPluginId();
            } else if (datasetMeta instanceof SampleDatasetMeta) {
                datasetMetaPluginId = ((SampleDatasetMeta)datasetMeta).getLoadedDesc().getOwnerPluginId();
            } else {
                throw new IOException("Unknown custom dataset type");
            }
            if (datasetMetaPluginId.equals(pluginId)) continue;
            throw new IOException("The dataset identifier '" + componentId + "' is already registered by another dataset in the plugin " + datasetMetaPluginId + ".");
        }
    }

    static {
        DKUtils.forceInit(SerializedDataset.class);
    }
}

