/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.RowFactoryWithContextInfo;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.StringOutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.BoundedBufferedLineReader;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.BOMInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;

public class LineFormatExtractor
extends ArchiveCapableFormatExtractor {
    private Config conf;
    public static final FormatMeta<LineFormatExtractor, Config> META = new FormatMeta<LineFormatExtractor, Config>(){

        @Override
        public String getType() {
            return "line";
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return Config.class;
        }

        @Override
        public LineFormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            if (params == null) {
                throw ErrorContext.iae((String)"Dataset format has no parameters");
            }
            return new LineFormatExtractor((Config)params);
        }

        @Override
        public String getLabel() {
            return "One record per line";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.TEXT_POSITION_BASED_FIXED_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{new ParamDesc("charset", "charset").withMandatory(false).withLabel("Charset"), FormatFactory.getStandardCompressionMethods(), ParamDesc.intP("maxLineChars", "Maximum characters per line", "Will fail if line length exceeds this value. 0 means no limit.").withCanBeEmpty(true).withMandatory(false).withMaxI(Integer.MAX_VALUE)};
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new LineOutputFormatter(((Config)params).charset);
        }
    };

    public LineFormatExtractor(Config conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput out, ColumnFactory cf, RowFactory rowFactory, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        Column c2;
        Schema schema;
        InputStream is = isn.getInputStream();
        RowFactoryWithContextInfo rf = new RowFactoryWithContextInfo(rowFactory, isn);
        if (this.conf.charset.equalsIgnoreCase("utf8")) {
            is = new BOMInputStream(is);
        }
        if ((schema = this.getSchema()) == null) {
            c2 = cf.column("line");
        } else {
            List cols = schema.getColumns();
            if (cols.size() != 1) {
                throw new RuntimeException("The input dataset must have 1 column (" + cols.size() + " defined in schema)");
            }
            c2 = cf.column(((SchemaColumn)cols.get(0)).getName());
        }
        long emittedLines = 0L;
        try (BoundedBufferedLineReader br = new BoundedBufferedLineReader((Reader)new InputStreamReader(is, this.conf.charset), this.conf.getMaxLineChars());){
            String str;
            while ((str = br.readLine()) != null) {
                if (!observer.checkLimit(emittedLines)) {
                    boolean bl = false;
                    return bl;
                }
                Row r = rf.row();
                r.put(c2, str);
                out.emitRow(r);
                if (++emittedLines % 500L != 0L) continue;
                observer.onInterval(emittedLines);
            }
            observer.onEnd(emittedLines);
        }
        return true;
    }

    public static class Config
    implements FormatParams {
        public String charset = "utf8";
        public static final int DEFAULT_MAX_LINE_CHARS = 500000000;
        private Integer maxLineChars = null;

        public Integer getMaxLineChars() {
            return this.maxLineChars;
        }

        public void setMaxLineChars(int maxLineChars) {
            this.maxLineChars = maxLineChars;
        }
    }

    public static class LineOutputFormatter
    extends StringOutputFormatter {
        public LineOutputFormatter(String charset) {
            super(charset);
        }

        public void cancel(OutputStream os) throws Exception {
        }

        public void setOutputSchema(Schema schema) {
        }

        public void header(ColumnFactory cf, Writer wr) throws Exception {
        }

        public void format(Row row, ColumnFactory cf, Writer wr) throws Exception {
            String line = row.get(cf.column("line"));
            if (line != null) {
                wr.write(line);
            }
            wr.write("\n");
        }

        public void footer(ColumnFactory cf, Writer wr) throws Exception {
        }
    }
}

