/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.orcfile;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.hive.HiveFileOutputWriter;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.output.CanListFilesWrittenTo;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.io.Writable;

public class ORCFileOutput
implements Output,
CanListFilesWrittenTo {
    private final Partition targetPartition;
    private final int targetSplit;
    private final ORCFileFormatConfig config;
    private final WarningsContext warningsContext;
    private final Dataset dataset;
    private final HDFSProvider provider;

    public ORCFileOutput(HDFSProvider provider, Dataset dataset, Partition targetPartition, int targetSplit, ORCFileFormatConfig config, WarningsContext warningsContext) {
        this.provider = provider;
        this.dataset = dataset;
        this.targetPartition = targetPartition;
        this.targetSplit = targetSplit;
        this.config = (ORCFileFormatConfig)Preconditions.checkNotNull((Object)config);
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException {
        assert (mode == Output.WriteMode.APPEND);
        return new ORCFileOutputWriter();
    }

    public List<String> list(OutputWriter writer) throws IOException, InterruptedException {
        return ((HiveFileOutputWriter)writer).gatherWritesInProgress();
    }

    public List<String> recoverList() throws IOException, CodedException, DKUSecurityException {
        return HiveFileOutputWriter.gatherPathsWrittenToAndNotCommitted(this.provider, this.targetSplit);
    }

    public class ORCFileOutputWriter
    extends HiveFileOutputWriter {
        public ORCFileOutputWriter() throws DKUSecurityException, IOException {
            super(ORCFileOutput.this.provider, ORCFileOutput.this.dataset, ORCFileOutput.this.targetPartition, ORCFileOutput.this.targetSplit, ORCFileOutput.this.warningsContext, ORCFileOutput.this.config);
        }

        @Override
        protected String getFileExtension() {
            return "orc";
        }

        @Override
        protected HiveOutputFormat<? extends Writable, ? extends Writable> getFileOutputFormat() {
            return new OrcOutputFormat();
        }
    }
}

