/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.remote;

import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.input.remote.RemoteFileUtils;
import com.dataiku.dip.input.remote.SSHRemote;
import com.dataiku.dip.util.DKUIOUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Joiner;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class SFTPRemote
extends SSHRemote {
    private static Logger logger = Logger.getLogger((String)"dku.remotefiles.sftp");

    public SFTPRemote(String host, String username, boolean usePublicKey, String passphrase, String passwd, int port, int timeout) throws IOException {
        super(host, username, usePublicKey, passphrase, passwd, port, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RemoteFileUtils.EnumerationResult enumeratePaths(List<String> paths, int depth) throws IOException {
        RemoteFileUtils.EnumerationResult result = new RemoteFileUtils.EnumerationResult();
        if (paths.isEmpty()) {
            return result;
        }
        try {
            logger.info((Object)"Opening SFTP channel");
            ChannelSftp channel = (ChannelSftp)this.session.openChannel("sftp");
            channel.connect();
            SSHRemote.TimeoutWatcher watcher = new SSHRemote.TimeoutWatcher(this.timeout);
            Object curErrMsg = "";
            try {
                LinkedList<Object> dirs = new LinkedList<Object>();
                for (String path : paths) {
                    logger.debug((Object)("checking path: " + path));
                    curErrMsg = "SFTP error checking " + path;
                    SftpATTRS attrs = channel.stat(path);
                    watcher.progress();
                    if (attrs.isReg()) {
                        result.files.add(new RemoteFileUtils.RemoteFile(path, attrs.getSize(), (long)attrs.getMTime() * 1000L));
                        continue;
                    }
                    if (!attrs.isDir()) continue;
                    if (depth == 0) {
                        result.files.add(new RemoteFileUtils.RemoteFile(path));
                        continue;
                    }
                    dirs.add(path);
                }
                while (!dirs.isEmpty()) {
                    String dir = (String)dirs.remove();
                    logger.debug((Object)("Enumerating directory: " + dir));
                    curErrMsg = "SFTP error enumerating " + dir;
                    for (Object o : channel.ls(dir)) {
                        watcher.progress();
                        ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)o;
                        SftpATTRS attrs = entry.getAttrs();
                        String name = entry.getFilename();
                        String fullName = dir + (dir.endsWith("/") ? "" : "/") + name;
                        if (attrs.isReg()) {
                            result.files.add(new RemoteFileUtils.RemoteFile(fullName, attrs.getSize(), (long)attrs.getMTime() * 1000L));
                            continue;
                        }
                        if (!attrs.isDir() || ".".equals(name) || "..".equals(name)) continue;
                        if (depth == -1) {
                            dirs.add(fullName);
                            continue;
                        }
                        result.files.add(new RemoteFileUtils.RemoteFile(fullName));
                    }
                }
            }
            catch (SftpException e) {
                logger.warn(curErrMsg, (Throwable)e);
                result.error = true;
                result.msg.add((String)curErrMsg + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            finally {
                channel.disconnect();
                watcher.done();
            }
        }
        catch (JSchException e) {
            logger.error((Object)"SSH error", (Throwable)e);
            throw new IOException("SSH error", e);
        }
        return result;
    }

    @Override
    protected void download(String remoteFile, OutputStream localFile) throws IOException {
        try {
            logger.debug((Object)("Downloading file " + remoteFile));
            ChannelSftp channel = (ChannelSftp)this.session.openChannel("sftp");
            channel.connect();
            SSHRemote.TimeoutWatcher watcher = new SSHRemote.TimeoutWatcher(this.timeout);
            try {
                SftpATTRS attrs = channel.stat(remoteFile);
                InputStream in = channel.get(remoteFile);
                long filesize = attrs.getSize();
                SSHRemote.DownloadProgressCopyCallback update = new SSHRemote.DownloadProgressCopyCallback(watcher, filesize);
                long n = DKUIOUtils.copyLarge(in, localFile, filesize, update);
                if (n != filesize) {
                    throw new IOException("unexpected end of input stream reading SFTP file contents : " + n + " should be " + filesize);
                }
                watcher.progress();
                localFile.close();
            }
            catch (SftpException e) {
                throw new IOException("SFTP error downloading " + remoteFile, e);
            }
            finally {
                channel.disconnect();
                watcher.done();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("timeout downloading file");
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
    }

    public void mkdir(String path) throws IOException {
        logger.debug((Object)("Stats for remote file " + path));
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.mkdir(path);
        }
        catch (SftpException e) {
            throw new IOException("SFTP error", e);
        }
        finally {
            channel.disconnect();
        }
    }

    @Override
    public void mkdirs(String prefix) throws IOException {
        logger.debug((Object)("Stats for remote file " + prefix));
        ChannelSftp channel = this.openSftpChannel();
        try {
            String init = "";
            String path = prefix;
            while (path.startsWith("/")) {
                init = "/";
                path = path.substring(1);
            }
            List<String> chunks = Arrays.asList(path.split("/+"));
            for (int i = 0; i < chunks.size(); ++i) {
                String prefixPath = init + Joiner.on((char)'/').join(chunks.subList(0, i + 1));
                RemoteFileUtils.RemoteFile stat = this.get(prefixPath);
                if (stat == null) {
                    channel.mkdir(prefixPath);
                    continue;
                }
                if (stat.isDirectory()) continue;
                throw new IOException("File aready exists: " + prefixPath);
            }
        }
        catch (SftpException e) {
            throw new IOException("SFTP error", e);
        }
        finally {
            channel.disconnect();
        }
    }

    @Override
    public RemoteFileUtils.RemoteFile get(String path) throws IOException {
        logger.debug((Object)("Stats for remote file '" + path + "'"));
        ChannelSftp channel = this.openSftpChannel();
        try {
            SftpATTRS attrs = channel.stat(path);
            RemoteFileUtils.RemoteFile remoteFile = attrs.isDir() ? new RemoteFileUtils.RemoteFile(path) : new RemoteFileUtils.RemoteFile(path, attrs.getSize(), (long)attrs.getMTime() * 1000L);
            return remoteFile;
        }
        catch (SftpException e) {
            if (e.id == 2) {
                RemoteFileUtils.RemoteFile remoteFile = null;
                return remoteFile;
            }
            throw new IOException("SFTP error", e);
        }
        finally {
            channel.disconnect();
        }
    }

    @Override
    public List<RemoteFileUtils.RemoteFile> list(String path) throws IOException {
        logger.debug((Object)("Listing '" + path + "'"));
        ChannelSftp channel = this.openSftpChannel();
        ArrayList<RemoteFileUtils.RemoteFile> result = new ArrayList<RemoteFileUtils.RemoteFile>();
        EnumerationAbortHook abortHook = new EnumerationAbortHook();
        try {
            try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)abortHook);){
                for (ChannelSftp.LsEntry entry : channel.ls(path)) {
                    if (abortHook.marker) {
                        throw new InterruptedException();
                    }
                    if (SFTPRemote.skip(entry.getFilename())) continue;
                    if (entry.getAttrs().isDir()) {
                        result.add(new RemoteFileUtils.RemoteFile(entry.getFilename()));
                        continue;
                    }
                    if (entry.getAttrs().isReg()) {
                        result.add(new RemoteFileUtils.RemoteFile(entry.getFilename(), entry.getAttrs().getSize(), (long)entry.getAttrs().getMTime() * 1000L));
                        continue;
                    }
                    if (!entry.getAttrs().isLink()) continue;
                }
            }
            catch (SftpException e) {
                throw new IOException("SFTP error", e);
            }
            finally {
                channel.disconnect();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to interrupt listing", e);
        }
        return result;
    }

    @Override
    public void forceRemove(String path) throws IOException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            this.removeRecursive(channel, path, channel.stat(path));
        }
        catch (SftpException e) {
            if (e.id == 2) {
                return;
            }
            throw new IOException("SFTP error #" + e.id, e);
        }
        finally {
            channel.disconnect();
        }
    }

    private void removeRecursive(ChannelSftp channel, String path, SftpATTRS attrs) throws SftpException {
        if (!attrs.isDir()) {
            channel.rm(path);
        } else {
            for (ChannelSftp.LsEntry entry : channel.ls(path)) {
                if (".".equals(entry.getFilename()) || "..".equals(entry.getFilename())) continue;
                this.removeRecursive(channel, path + "/" + entry.getFilename(), entry.getAttrs());
            }
            channel.rmdir(path);
        }
    }

    @Override
    public void rename(String fromPath, String toPath) throws IOException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.rename(fromPath, toPath);
        }
        catch (SftpException e) {
            throw new IOException("SFTP error", e);
        }
        finally {
            channel.disconnect();
        }
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        logger.debug((Object)("Opening stream for remote file " + path));
        ChannelSftp channel = this.openSftpChannel();
        try {
            return new SSHRemote.FilterInputStreamClosingChannel(channel.get(path), (Channel)channel);
        }
        catch (SftpException e) {
            throw new IOException("SFTP error", e);
        }
    }

    @Override
    public OutputStream getOutputStream(String path) throws IOException {
        logger.debug((Object)("Opening stream for remote file " + path));
        ChannelSftp channel = this.openSftpChannel();
        try {
            return new SSHRemote.FilterOutputStreamClosingChannel(channel.put(path), (Channel)channel);
        }
        catch (SftpException e) {
            throw new IOException("SFTP error", e);
        }
    }

    private ChannelSftp openSftpChannel() throws IOException {
        ChannelSftp channel;
        try {
            channel = (ChannelSftp)this.session.openChannel("sftp");
            channel.connect();
        }
        catch (JSchException e) {
            throw new IOException("Couldn't open SFTP channel", e);
        }
        return channel;
    }

    @Override
    public void setLastModified(String path, long lastModified) throws IOException {
        logger.debug((Object)("setMtime for remote file " + path));
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.setMtime(path, (int)(lastModified / 1000L));
        }
        catch (SftpException e) {
            throw new IOException("SFTP error", e);
        }
        finally {
            channel.disconnect();
        }
    }

    public void chmod(int permissions, String path) throws IOException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.chmod(permissions, path);
        }
        catch (SftpException e) {
            throw new IOException("SFTP error", e);
        }
        finally {
            channel.disconnect();
        }
    }

    private static class EnumerationAbortHook
    implements Runnable {
        protected volatile boolean marker = false;

        private EnumerationAbortHook() {
        }

        @Override
        public void run() {
            this.marker = true;
        }
    }
}

