/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.tracker;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.integrations.AbstractHttpIntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.integrations.tracker.GithubIssueNumberSniffer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DefaultRedirectStrategyWithIPBlacklist;
import com.dataiku.dip.security.IPBlacklistVerifier;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.MentionEnabledEvent;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.RedirectStrategy;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPatch;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.StringEntity;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpConnectionParams;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpParams;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class GithubIntegrationHandler
extends AbstractHttpIntegrationEventHandler {
    public static final IntegrationMeta META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "github";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return GithubIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException {
            return new GithubIntegrationHandler(messaging.getConfigurationAs(GithubIntegrationParams.class));
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
        }
    };
    private final GithubIntegrationParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.sender.github");

    public GithubIntegrationHandler(GithubIntegrationParams params) throws IOException {
        this.params = params;
    }

    @Override
    public void handleEvent(DSSEvent event, InfoMessage.InfoMessages messages) throws IOException {
        if (event instanceof MentionEnabledEvent) {
            MentionEnabledEvent e = (MentionEnabledEvent)event;
            this.handleIssuesInMessage(e.getMessage());
        }
    }

    private void handleIssuesInMessage(String msg) throws IOException {
        if (StringUtils.isNotBlank((String)msg)) {
            GithubIssueNumberSniffer sniffer = new GithubIssueNumberSniffer();
            sniffer.sniff(msg);
            Set<String> toClose = sniffer.getIssuesToClose();
            Set<String> toComment = sniffer.getIssuesToComment();
            logger.info((Object)("Got issues to close : " + JSON.json(toClose)));
            logger.info((Object)("Got issues to comment : " + JSON.json(toComment)));
            for (String issue : toClose) {
                this.closeIssueWithComment(issue, msg);
            }
            for (String issue : toComment) {
                this.commentIssue(issue, msg);
            }
        }
    }

    private void closeIssueWithComment(String issue, String message) throws IOException {
        try (AbstractHttpIntegrationEventHandler.AutoCloseableClient client = this.getClient(this.params.useProxy, (RedirectStrategy)this.createRedirectStrategyWithIPBlacklist());){
            this.postComment(client, issue, message);
            this.closeIssue(client, issue);
        }
    }

    private void commentIssue(String issue, String message) throws IOException {
        try (AbstractHttpIntegrationEventHandler.AutoCloseableClient client = this.getClient(this.params.useProxy, (RedirectStrategy)this.createRedirectStrategyWithIPBlacklist());){
            this.postComment(client, issue, message);
        }
    }

    private void closeIssue(AbstractHttpIntegrationEventHandler.AutoCloseableClient client, String issue) throws IOException {
        HttpPatch patch = new HttpPatch("https://api.github.com/repos/" + this.params.repository + "/issues/" + issue);
        JsonObject obj = new JsonObject();
        obj.addProperty("state", "closed");
        patch.setEntity((HttpEntity)new StringEntity(obj.toString(), ContentType.APPLICATION_JSON));
        patch.addHeader("Authorization", GithubIntegrationHandler.basicAccessAuthHeader(this.params.username, this.params.accessToken));
        this.execute(client, (HttpRequestBase)patch);
    }

    private void postComment(AbstractHttpIntegrationEventHandler.AutoCloseableClient client, String issue, String message) throws IOException {
        HttpPost post = new HttpPost("https://api.github.com/repos/" + this.params.repository + "/issues/" + issue + "/comments");
        JsonObject obj = new JsonObject();
        obj.addProperty("body", message);
        post.setEntity((HttpEntity)new StringEntity(obj.toString(), ContentType.APPLICATION_JSON));
        post.addHeader("Authorization", GithubIntegrationHandler.basicAccessAuthHeader(this.params.username, this.params.accessToken));
        this.execute(client, (HttpRequestBase)post);
    }

    private void execute(AbstractHttpIntegrationEventHandler.AutoCloseableClient client, HttpRequestBase req) throws IOException {
        HttpConnectionParams.setConnectionTimeout((HttpParams)req.getParams(), (int)20000);
        HttpConnectionParams.setSoTimeout((HttpParams)req.getParams(), (int)20000);
        IPBlacklistVerifier.validateUriNotBlacklisted(req.getURI().toString(), this.params.useProxy);
        HttpResponse resp = client.execute((HttpUriRequest)req);
        int code = resp.getStatusLine().getStatusCode();
        if (code != 200 && code != 201 && code != 204) {
            logger.warn((Object)("MESSAGE/ " + IOUtils.toString((InputStream)resp.getEntity().getContent())));
            throw new IOException("API call on Github failed : " + resp.getStatusLine().getStatusCode() + " with reason " + resp.getStatusLine().getReasonPhrase());
        }
        EntityUtils.consumeQuietly((HttpEntity)resp.getEntity());
    }

    private DefaultRedirectStrategyWithIPBlacklist createRedirectStrategyWithIPBlacklist() {
        ProxySettings proxySettings = new ProxySettings();
        if (this.params.useProxy) {
            proxySettings = ApplicationConfigurator.getProxySettings();
        }
        return new DefaultRedirectStrategyWithIPBlacklist(proxySettings);
    }

    public static class GithubIntegrationParams
    implements IntegrationParams {
        public boolean useProxy = true;
        public String username;
        public String accessToken;
        public String repository;
    }
}

