/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.RSecretProtectedKernel;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import java.io.File;
import java.io.IOException;

public abstract class AbstractImpersonableSecretProtectedRKernel<L extends SecretProtectedKernelLink>
extends RSecretProtectedKernel<L> {
    private final APITicketService.Ticket ticket;

    protected AbstractImpersonableSecretProtectedRKernel(L link, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, APITicketService.Ticket ticket, boolean useProjectLibs, File workDir, boolean impersonate, String projectKey, AuthCtx authCtx, String envName) {
        super(authCtx, link, useProjectLibs, projectKey, envName, impersonate, workDir, cgrouppableProcessType);
        this.ticket = ticket;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb) throws DKUSecurityException, IOException, InterruptedException {
        if (this.ticket != null) {
            pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        }
        if (this.impersonated) {
            InsecureProcessesLaunchService insecureProcessesLaunchService = (InsecureProcessesLaunchService)SpringUtils.getBean(InsecureProcessesLaunchService.class);
            return insecureProcessesLaunchService.launch(this.authCtx, this.projectKey, this.cgrouppableProcessType, this.workDir, pb);
        }
        RegularProcess p = new RegularProcess(pb, this.workDir, this.cgrouppableProcessType, this.authCtx, this.projectKey);
        p.start();
        return p;
    }
}

