/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.mistralai;

import com.dataiku.dip.connections.MistralAIConnection;
import com.dataiku.dip.utils.DKULogger;
import org.apache.commons.lang.StringUtils;

public class MistralAIPricing {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.mistralai.pricing");

    private MistralAIPricing() {
    }

    private static double costPer1kFromCostPer1M(double costPer1M) {
        return costPer1M * 0.001;
    }

    public static double getMistralAIPromptCostPer1kTokens(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(MistralAIConnection.HardcodedMistralAIModel.MISTRAL_SMALL.id)) {
            return MistralAIPricing.costPer1kFromCostPer1M(0.1);
        }
        if (model.equals(MistralAIConnection.HardcodedMistralAIModel.MISTRAL_MEDIUM.id)) {
            return MistralAIPricing.costPer1kFromCostPer1M(0.4);
        }
        if (model.equals(MistralAIConnection.HardcodedMistralAIModel.MISTRAL_LARGE.id)) {
            return MistralAIPricing.costPer1kFromCostPer1M(2.0);
        }
        logger.warn((Object)("Unknown prompt pricing for Mistral AI model: " + model));
        return 0.0;
    }

    public static double getMistralAICompletionCostPer1kTokens(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(MistralAIConnection.HardcodedMistralAIModel.MISTRAL_SMALL.id)) {
            return MistralAIPricing.costPer1kFromCostPer1M(0.3);
        }
        if (model.equals(MistralAIConnection.HardcodedMistralAIModel.MISTRAL_MEDIUM.id)) {
            return MistralAIPricing.costPer1kFromCostPer1M(2.0);
        }
        if (model.equals(MistralAIConnection.HardcodedMistralAIModel.MISTRAL_LARGE.id)) {
            return MistralAIPricing.costPer1kFromCostPer1M(6.0);
        }
        logger.warn((Object)("Unknown prompt output pricing for Mistral AI model: " + model));
        return 0.0;
    }

    public static double getMistralAIEmbeddingCostPer1kTokens(String model) {
        if (StringUtils.isBlank((String)model)) {
            return 0.0;
        }
        if (model.equals(MistralAIConnection.HardcodedMistralAIModel.MISTRAL_EMBED.id)) {
            return MistralAIPricing.costPer1kFromCostPer1M(0.1);
        }
        logger.warn((Object)("Unknown embedding input pricing for Mistral AI model: " + model));
        return 0.0;
    }
}

