/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai;

import com.dataiku.common.rpc.ExternalJSONAPIClient;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.OpenAIConnection;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.AbstractLLMClient;
import com.dataiku.dip.llm.online.LLMChatMessageUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMQueryRunner;
import com.dataiku.dip.llm.online.RemoteFineTuningClient;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.openai.OpenAIChatAPI;
import com.dataiku.dip.llm.online.openai.OpenAIFineTuningClient;
import com.dataiku.dip.llm.online.openai.RawOpenAIClient;
import com.dataiku.dip.llm.utils.OnlineLLMUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class OpenAIClient
extends AbstractLLMClient
implements LLMClient {
    private final OpenAIConnection connection;
    private final LLMQueryRunner queryRunner;
    private RawOpenAIClient raw;
    private OpenAIConnection.OpenAIModel model;
    private ComputeResourceUsage.InternalLLMUsageData usageData = new ComputeResourceUsage.LLMUsageData();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.openai");

    public static boolean isRetryableException(Throwable t) {
        if (t instanceof ExternalJSONAPIClient.JSONAPIClientException) {
            ExternalJSONAPIClient.JSONAPIClientException exception = (ExternalJSONAPIClient.JSONAPIClientException)t;
            if (exception.httpCode == 500 && exception.responseText != null && exception.responseText.contains("\"Something went wrong\"")) {
                return true;
            }
        }
        return OnlineLLMUtils.isRetryableException(t);
    }

    public OpenAIClient(OpenAIConnection connection, LLMModelHandle<OpenAIConnection.OpenAIModel> modelHandle, String apiKey, @Nullable String projectKey, AuthCtx authCtx) {
        super(modelHandle.getEnrichedRef());
        this.connection = connection;
        Params connectionProperties = ConnectionUtils.getParamsFromProperties(connection.getDkuProperties());
        boolean trustAllSSLCertificates = connectionProperties.getBoolParam("dku.connection.llm.trustAllSSLCertificates", false);
        boolean forceContentLength = connectionProperties.getBoolParam("dku.connection.llm.forceContentLength", false);
        this.queryRunner = new LLMQueryRunner(this.getProviderId(), modelHandle, connection.params.networkSettings, OpenAIClient::isRetryableException);
        this.raw = RawOpenAIClient.forOpenAI(connection.params.customURL, apiKey, connection.params.organizationId, connection.params.customHeaders, projectKey, this.queryRunner.getHttpClientNetworkSettings(), connection.getProxySettings(), trustAllSSLCertificates, connection.useMaxCompletionToken(), forceContentLength, authCtx, connection);
        this.model = modelHandle.getModel();
    }

    @Override
    public void close() {
        this.raw.close();
    }

    @Override
    public boolean supportNativeBatch() {
        return false;
    }

    @Override
    public boolean requiresCostLimiting() {
        return true;
    }

    @Override
    public String getProviderId() {
        return "OpenAI";
    }

    @Override
    public int getMaxParallelism() {
        return this.connection.params.maxParallelism;
    }

    @Override
    public int getBatchSize(AbstractLLMConnection.QueryType queryType, LLMStructuredRef llmRef) {
        switch (queryType) {
            case textEmbedding: {
                if (this.model.getBatchSize().isPresent()) {
                    logger.info((Object)"Using user defined batch size");
                    return this.model.getBatchSize().getAsInt();
                }
                return 10;
            }
        }
        return 1;
    }

    @Override
    public AbstractLLMConnection getConnection() {
        return this.connection;
    }

    public RawOpenAIClient getRaw() {
        return this.raw;
    }

    public String getModelName() {
        return this.model.getId();
    }

    public OpenAIConnection.OpenAIModel getModel() {
        return this.model;
    }

    @Override
    public List<LLMClient.ChatMessage> getFormattedPrompt(List<LLMClient.ChatMessage> chatMessages) {
        if (this.model.modelType == OpenAIConnection.OpenAIModelType.COMPLETION_CHAT_NO_SYSTEM_PROMPT) {
            chatMessages = LLMChatMessageUtils.convertMessageRole(chatMessages, "system", "user");
        }
        if (this.model.isChatModel()) {
            return chatMessages;
        }
        ArrayList<LLMClient.ChatMessage> formattedPromptMessages = new ArrayList<LLMClient.ChatMessage>();
        LLMClient.ChatMessage formattedPrompt = new LLMClient.ChatMessage();
        formattedPrompt.setTextOnly(chatMessages.stream().map(m -> m.getText()).collect(Collectors.joining("\n")));
        formattedPrompt.role = "prompt";
        formattedPromptMessages.add(formattedPrompt);
        return formattedPromptMessages;
    }

    @Override
    public List<LLMClient.SimpleCompletionResponse> completeBatch(List<LLMClient.SingleCompletionQuery> queries, LLMClient.CompletionSettings settings) throws Exception {
        ArrayList<LLMClient.SimpleCompletionResponse> ret = new ArrayList<LLMClient.SimpleCompletionResponse>();
        for (LLMClient.SingleCompletionQuery query : queries) {
            logger.info((Object)("OpenAI single complete query: " + JSON.json((Object)query.getTrimmedImagesCopy())));
            long before = System.currentTimeMillis();
            CoreCompletionSettings ccs = this.getCoreCompletionSettings(settings);
            LLMClient.SimpleCompletionResponse scr = this.queryRunner.run(() -> {
                LLMClient.SimpleCompletionResponse response = null;
                if (this.model.isChatModel()) {
                    List<LLMClient.ChatMessage> chatMessages = this.getFormattedPrompt(query.messages);
                    try {
                        if (this.model.api == OpenAIChatAPI.RESPONSES) {
                            response = this.raw.completeResponsesAPI(this.getModelName(), chatMessages, ccs, this.model);
                        }
                        response = this.raw.chatComplete(this.getModelName(), chatMessages, ccs, this.model);
                    }
                    catch (LLMClient.LLMException e) {
                        e.includeInUsageData(this.usageData, System.currentTimeMillis() - before);
                        throw e;
                    }
                } else {
                    String prompt = query.messages.stream().map(m -> m.getText()).collect(Collectors.joining("\n"));
                    response = this.raw.complete(this.getModelName(), prompt, ccs);
                }
                response.estimatedCost = this.model.getEstimatedCompletionCost(response.promptTokens, response.completionTokens);
                return response;
            });
            scr.includeInUsageData(this.usageData, System.currentTimeMillis() - before);
            ret.add(scr);
        }
        return ret;
    }

    @Override
    public void streamComplete(LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings, LLMClient.StreamedCompletionResponseConsumer consumer) throws Exception {
        CoreCompletionSettings ccs = this.getCoreCompletionSettings(settings);
        logger.info((Object)("OpenAI streamed complete: " + JSON.json((Object)query)));
        Stopwatch stopwatch = Stopwatch.createStarted();
        LLMClient.StreamedCompletionResponseConsumerProxy wrappedConsumer = new LLMClient.StreamedCompletionResponseConsumerProxy(consumer, (ExceptionUtils.ThrowingConsumer<LLMClient.StreamedCompletionResponseFooter, Exception>)((ExceptionUtils.ThrowingConsumer)footer -> footer.includeInUsageData(this.usageData, stopwatch.elapsed(TimeUnit.MILLISECONDS))));
        if (!this.model.isChatModel()) {
            throw new IllegalArgumentException("Streaming not supported on legacy-completion OpenAI endpoints");
        }
        List<LLMClient.ChatMessage> chatMessages = this.getFormattedPrompt(query.messages);
        this.queryRunner.run(() -> {
            try {
                if (this.model.api == OpenAIChatAPI.RESPONSES) {
                    this.raw.streamResponsesAPI(wrappedConsumer, this.model, chatMessages, ccs);
                } else {
                    this.raw.streamChatComplete(wrappedConsumer, this.model, chatMessages, ccs);
                }
            }
            catch (LLMClient.LLMException e) {
                e.includeInUsageData(this.usageData, stopwatch.elapsed(TimeUnit.MILLISECONDS));
                throw e;
            }
            return null;
        });
    }

    @Override
    public List<LLMClient.SimpleEmbeddingResponse> embedBatch(List<LLMClient.EmbeddingQuery> queries, LLMClient.EmbeddingSettings settings) throws Exception {
        if (LLMClient.TextOverflowMode.TRUNCATE.equals((Object)settings.textOverflowMode)) {
            logger.warn((Object)"Truncation for long texts overflow is not supported yet for OpenAI, defaulting to Failure mode");
        }
        ArrayList<LLMClient.SimpleEmbeddingResponse> ret = new ArrayList<LLMClient.SimpleEmbeddingResponse>();
        long before = System.currentTimeMillis();
        List batchTexts = queries.stream().map(query -> query.text).collect(Collectors.toList());
        logger.info((Object)("OpenAI Embed sending the following batch : " + JSON.json(batchTexts)));
        List EmbeddingResponses = this.queryRunner.run(() -> this.raw.embed(this.getModelName(), batchTexts));
        this.usageData.incrementTotalComputationTimeMS(Long.valueOf(System.currentTimeMillis() - before));
        for (LLMClient.SimpleEmbeddingResponse scr : EmbeddingResponses) {
            scr.estimatedCost = this.model.getEstimatedEmbeddingCost(scr.promptTokens, 0);
            scr.includeInUsageData(this.usageData);
            ret.add(scr);
        }
        return ret;
    }

    @Override
    public LLMClient.ImageGenerationResponse generateImages(LLMClient.ImageGenerationQuery query) throws Exception {
        long before = System.currentTimeMillis();
        LLMClient.ImageGenerationResponse resp = this.queryRunner.run(() -> this.raw.generateImage(this.model.imageHandlingMode, this.model.getId(), query));
        long computationTimeMS = System.currentTimeMillis() - before;
        resp.estimatedCost = this.model.getEstimatedImageGenerationCost(query);
        this.usageData.incrementTotalComputationTimeMS(Long.valueOf(computationTimeMS));
        this.usageData.incrementEstimatedCostUSD(Double.valueOf(resp.estimatedCost));
        return resp;
    }

    @Override
    public ComputeResourceUsage getTotalCRU(ComputeResourceUsage.LLMUsageType usageType, LLMStructuredRef llmRef) {
        ComputeResourceUsage cru = new ComputeResourceUsage();
        cru.setupLLMUsage(usageType, llmRef.connection, llmRef.type.toString(), llmRef.id);
        cru.llmUsage.setFromInternal(this.usageData);
        return cru;
    }

    @Override
    public boolean supportsStream() {
        return true;
    }

    @Override
    public RemoteFineTuningClient newFineTuningClient() {
        return new OpenAIFineTuningClient(this);
    }
}

