/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai.api.chatcompletions;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class OpenAIChatQuery {
    public List<Message> messages;
    @Nullable
    public String model;
    @Nullable
    public Boolean stream;
    @Nullable
    @SerializedName(value="max_completion_tokens")
    public Integer maxCompletionTokens;
    @Nullable
    @SerializedName(value="max_tokens")
    public Integer maxTokens;
    @Nullable
    public Double temperature;
    @Nullable
    @SerializedName(value="top_p")
    public Double topP;
    @Nullable
    public List<String> stop;
    @Nullable
    @SerializedName(value="frequency_penalty")
    public Double frequencyPenalty;
    @Nullable
    @SerializedName(value="presence_penalty")
    public Double presencePenalty;
    @Nullable
    @SerializedName(value="logit_bias")
    public Map<String, Double> logitBias;
    @Nullable
    @SerializedName(value="logprobs")
    public Boolean logProbs;
    @Nullable
    @SerializedName(value="response_format")
    public OpenAIResponseFormat responseFormat;
    @Nullable
    @SerializedName(value="top_logprobs")
    public Integer topLogProbs;
    @Nullable
    @SerializedName(value="tool_choice")
    public ToolChoice toolChoice;
    @Nullable
    public List<FunctionTool> tools;
    @Nullable
    @SerializedName(value="stream_options")
    public StreamOptions streamOptions;

    public static class SchemaData {
        @Nullable
        public String description;
        public String name;
        public JsonObject schema;
        @Nullable
        public Boolean strict;
    }

    public static class OpenAIResponseFormatJSONSchema
    extends OpenAIResponseFormat {
        @SerializedName(value="json_schema")
        public SchemaData jsonSchema = new SchemaData();
    }

    public static class OpenAIResponseFormatJSONObject
    extends OpenAIResponseFormat {
    }

    public static class OpenAIResponseFormatText
    extends OpenAIResponseFormat {
    }

    @PolyJSON(value={@Mapping(type="text", value=OpenAIResponseFormatText.class), @Mapping(type="json_object", value=OpenAIResponseFormatJSONObject.class), @Mapping(type="json_schema", value=OpenAIResponseFormatJSONSchema.class)})
    public static abstract class OpenAIResponseFormat {
    }

    public static class FunctionToolDesc {
        public String name;
        @Nullable
        public String description;
        @Nullable
        public JsonObject parameters;
    }

    public static class FunctionTool {
        public final String type = "function";
        public FunctionToolDesc function;
    }

    public static class ToolChoiceFunction {
        public String name;
    }

    public static class EnforcedToolChoice
    implements ToolChoice {
        public final String type = "function";
        public ToolChoiceFunction function;
    }

    public static enum ConstantToolChoice implements ToolChoice
    {
        none,
        auto,
        any,
        required;

    }

    public static interface ToolChoice {
    }

    public static class ToolCallFunction {
        public String name;
        public String arguments;
    }

    public static class ToolCall {
        public final String type = "function";
        public String id;
        public ToolCallFunction function;
    }

    public static class ImageURL {
        public String url;
    }

    public static class ImageContentPart
    implements MessageContentPart {
        public final String type = "image_url";
        @SerializedName(value="image_url")
        public ImageURL imageUrl;
    }

    public static class TextContentPart
    implements MessageContentPart {
        public final String type = "text";
        public String text;
    }

    public static interface MessageContentPart {
    }

    public static class ToolMessage
    implements Message {
        public final String role = "tool";
        public String content;
        @SerializedName(value="tool_call_id")
        public String toolCallId;
    }

    public static class AssistantMessage
    implements Message {
        public final String role = "assistant";
        @Nullable
        public String content;
        @Nullable
        @SerializedName(value="tool_calls")
        public List<ToolCall> toolCalls;
    }

    public static class CompositeUserMessage
    implements Message {
        public final String role = "user";
        public List<MessageContentPart> content;
    }

    public static class UserMessage
    implements Message {
        public final String role = "user";
        public String content;
    }

    public static class SystemMessage
    implements Message {
        public final String role = "system";
        public String content;
    }

    public static interface Message {
    }

    public static class StreamOptions {
        @SerializedName(value="include_usage")
        public Boolean includeUsage;
    }
}

