/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.drift.TextDriftParams;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public class TabularModelEvaluation
extends AbstractModelEvaluation {
    public static final String TYPE = "tabular";
    @Nullable
    @JSON.FileTransient
    public FullModelId modelRef;
    @Nullable
    public KernelsModelEvaluationStoresService.EvaluateRecipeParams evaluateRecipeParams;
    @Nullable
    public JsonObject modelParams;
    @Nullable
    public ModelType modelType;
    public boolean hasDriftReference;
    public JsonObject trainDataParams;
    public AbstractModelEvaluation.DataType trainDataType;
    public PredictionMLTask.PredictionType predictionType;
    public String predictionVariable;
    public String targetVariable;
    public String weightsVariable;
    public boolean outputProbabilities;
    public List<EvaluationModelInfoProba> probaColumns;
    public boolean thresholdAutoOptimized;
    public double activeClassifierThreshold;
    public double referenceClassifierThreshold;
    public MetricParams metricParams = new MetricParams();
    public FullModelId smvToFilterLogsOn;
    public boolean skipScoring;
    public boolean hasModel = true;
    public boolean hasTextDrift = false;
    public TextDriftParams textDriftParams;

    public <T extends EvaluatedModel> T getModelParamsAs(Class<T> clazz) {
        return (T)((EvaluatedModel)JSON.parse((JsonElement)this.modelParams, clazz));
    }

    @Override
    public void setTransientReference(FullModelEvaluationId ref) {
        super.setTransientReference(ref);
        assert (ModelType.ANALYSIS_MODEL != this.modelType);
        if (this.modelType == ModelType.SAVED_MODEL) {
            EvaluatedDSSModel esm = this.getModelParamsAs(EvaluatedDSSModel.class);
            AnyLoc savedModelRef = DatasetLocUtils.DatasetLoc.resolveSmart(ref.getProjectKey(), esm.ref);
            this.modelRef = new FullModelId(savedModelRef.getProjectKey(), savedModelRef.getId(), esm.versionId);
        }
    }

    public FullModelId getBackingFullModelId() {
        if (ModelType.SAVED_MODEL == this.modelType) {
            EvaluatedDSSModel esm = this.getModelParamsAs(EvaluatedDSSModel.class);
            AnyLoc ref = AnyLoc.resolveSmart(this.ref.getProjectKey(), esm.ref);
            return new FullModelId(ref.getProjectKey(), ref.getId(), esm.versionId);
        }
        return null;
    }

    @Override
    public boolean onDSSSavedModel() {
        return this.modelType == ModelType.SAVED_MODEL;
    }

    @Override
    public Schema getDataSchema() throws IOException {
        Schema outputSchema = this.ref.getScoredSchema();
        if (this.predictionVariable != null) {
            outputSchema.removeColumn(this.predictionVariable);
        }
        if (this.weightsVariable != null) {
            outputSchema.removeColumn(this.weightsVariable);
        }
        if (this.targetVariable != null) {
            outputSchema.removeColumn(this.targetVariable);
        }
        if (this.probaColumns != null) {
            for (EvaluationModelInfoProba probaColumn : this.probaColumns) {
                outputSchema.removeColumn(probaColumn.column);
            }
        }
        for (SchemaColumn column : outputSchema.getColumns()) {
            if (!column.getType().isInteger()) continue;
            column.setType(Type.FLOAT);
        }
        return outputSchema;
    }

    public static class EvaluatedModel {
        public String name;
    }

    public static enum ModelType {
        ANALYSIS_MODEL,
        SAVED_MODEL,
        EXTERNAL;

    }

    public static class EvaluatedDSSModel
    extends EvaluatedModel {
        public String ref;
        public String versionId;
        public String partitionName;
        public String description;
        public String versionName;
        public long trainEndTime;
        public boolean isPartitioned;
        public boolean isEnsembled;
    }

    public static class EvaluationModelInfoProba {
        public int index;
        public String column;

        public EvaluationModelInfoProba() {
        }

        public EvaluationModelInfoProba(int index, String column) {
            this.index = index;
            this.column = column;
        }
    }

    public static class EvaluatedExternalModel
    extends EvaluatedModel {
        public String description;
    }
}

