/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.ProbeQueryBuilder;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLProbeEngine
extends JdbcEngine
implements ProbeQueryBuilder.ProbeQueryBuilderEngine {
    private final DatasetHandler datasetHandler;

    public SQLProbeEngine(Dataset dataset, DatasetHandler datasetHandler, Partition partition, JdbcEngine.SQLMetricsEngineConfig config) {
        super(dataset, partition);
        this.datasetHandler = datasetHandler;
    }

    public DatasetHandler getDatasetHandler() {
        return this.datasetHandler;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, SQLException, DKUSecurityException {
        this.connectionData = DatasetInspector.getSQLConnectionForSQLAbleDatasetOrHive(authCtx, this.dataset);
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        MetricComputation primerComputation = computations.get(0);
        MetricComputer.SQLQueryEngineComputer computer = (MetricComputer.SQLQueryEngineComputer)primerComputation.computer;
        ProbeQueryBuilder builder = new ProbeQueryBuilder();
        return builder.buildQuery(authCtx, this, computer.getQuery(primerComputation.probe), computer.getVariables(primerComputation.probe, authCtx, this.dataset.getProjectKey()));
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult res, List<MetricComputation> computations) throws Exception {
        Probe sqlProbe = computations.get((int)0).probe;
        MetricBuilder metricBuilder = (MetricBuilder)((Object)ProbeType.getProbeType(sqlProbe.getType()));
        HashMap metricsValues = Maps.newHashMap();
        if (res.rows != null && res.rows.size() > 0) {
            for (int i = 0; i < res.columns.size(); ++i) {
                QueryRunResult.ScriptRunResultColumn column = res.columns.get(i);
                String v = res.rows.get(0)[i];
                Metric metric = metricBuilder.build(column.name, column.dssType, sqlProbe);
                metricsValues.put(metric, v);
            }
        }
        return metricsValues;
    }

    public static class SQLProbeEngineRun
    extends MetricsEngineRun {
        public SQLProbeEngineRun() {
            super(MetricsEngineDesc.SQLQueryEngine);
        }

        public SQLProbeEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.SQLQueryEngine, cost, computations, pass);
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new SQLProbeEngineRun(cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            return false;
        }
    }
}

