/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class CheckProbeType
extends ProbeType {
    public static final String TYPE = "check";
    private transient Map<CheckMetrics, MetricMetadata> metadataPerType = Maps.newHashMap();

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        return Lists.newArrayList();
    }

    public CheckProbeType() {
        this.type = TYPE;
        this.metadataPerType.put(CheckMetrics.CHECK, new MetricMetadata().withName("Check"));
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        return Lists.newArrayList();
    }

    @Override
    public ProbeType trimForSave() {
        return new CheckProbeType();
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return CheckProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(0).withName("Check results");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    public static enum CheckMetrics {
        CHECK;

    }

    public static class CheckProbeConfiguration
    implements ProbeConfiguration {
    }

    public static class CheckMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof CheckMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            CheckMetric checkMetric = (CheckMetric)metric;
            return Metric.buildMetricIdFromParts(CheckProbeType.TYPE, checkMetric.getMetricType().name(), checkMetric.getCheckName());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() < 3 || !parts.get(0).equals(CheckProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new CheckMetric(CheckMetrics.valueOf(parts.get(1)), parts.get(2));
        }
    }

    public static class CheckMetric
    extends Metric {
        public CheckMetrics metricType;
        public String checkName;

        public CheckMetric(CheckMetrics metricType, String checkName) {
            super(CheckProbeType.TYPE, Type.STRING);
            this.metricType = metricType;
            this.checkName = checkName;
            this.id = Metric.serializeMetric(this);
        }

        public CheckMetrics getMetricType() {
            return this.metricType;
        }

        public String getCheckName() {
            return this.checkName;
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        @Override
        public MetricMetadata getMeta() {
            return new MetricMetadata().withName("Check " + this.checkName);
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return new Probe(this.getType()).withConfiguration(new CheckProbeConfiguration()).withMeta(ProbeType.getProbeType(CheckProbeType.TYPE).getMeta());
        }
    }
}

