/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.ExtensibleOutputWriter;
import com.dataiku.dip.output.FileNamingAbleOutputWriter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public abstract class PathBasedExtensibleOutputWriter
extends ExtensibleOutputWriter {
    protected String basePath;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.output.pathwriter");

    public PathBasedExtensibleOutputWriter(AuthCtx authCtx, String projectKey, String basePath, int splitId, int nbChunks, String formatType, FormatParams formatParams, Schema schema, WarningsContext warningsContext, Output.WriteMode writeMode, String compress, SerializedDataset.ReadWriteOptions readWriteOptions) {
        super(authCtx, projectKey, splitId, nbChunks, formatType, formatParams, schema, warningsContext, writeMode, compress, readWriteOptions);
        this.basePath = basePath;
    }

    protected abstract boolean fileExists(String var1) throws CodedException, IOException, DKUSecurityException;

    protected abstract boolean isTransactionalMode();

    protected abstract OutputStream writeToStream(String var1) throws IOException, CodedException, DKUSecurityException;

    public void init(ColumnFactory cf) throws IOException, CodedException, DKUSecurityException {
        this.cf = cf;
        for (SchemaColumn sc : this.schema.getColumns()) {
            cf.column(sc.getName());
        }
        logger.info((Object)"INIT Resplittable");
        for (ExtensibleOutputWriter.SplitChunk chunk : this.chunks) {
            this.initOneChunk(chunk);
        }
    }

    private void initOneChunk(ExtensibleOutputWriter.SplitChunk chunk) throws CodedException, IOException, DKUSecurityException {
        int chunkId = chunk.id;
        String fileName = null;
        String extension = this.makeExtension();
        String chunkBaseName = this.makeChunkBaseName(chunkId);
        if (this.fileNamingMode == FileNamingAbleOutputWriter.FileNamingMode.EXTENT) {
            fileName = chunkBaseName + extension;
            if (this.fileExists(PathUtils.concatLNT((String[])new String[]{this.basePath, fileName}))) {
                String extent;
                int extentId = 0;
                while (this.fileExists(extent = PathUtils.concatLNT((String[])new String[]{this.basePath, fileName = chunkBaseName + "-e" + extentId + extension}))) {
                    ++extentId;
                }
            }
        } else {
            fileName = this.fileNamingMode == FileNamingAbleOutputWriter.FileNamingMode.FIXED ? chunkBaseName + "-" + this.fixedChunkId + extension : chunkBaseName + "-" + DKUDateUtils.isoFormatFileFriendlyLocalNow() + extension;
        }
        if (this.isTransactionalMode()) {
            chunk.finalFilePath = PathUtils.concatLNT((String[])new String[]{this.basePath, fileName});
            fileName = "_tmp." + fileName;
            chunk.tmpFilePath = PathUtils.concatLNT((String[])new String[]{this.basePath, fileName});
        } else {
            chunk.tmpFilePath = chunk.finalFilePath = PathUtils.concatLNT((String[])new String[]{this.basePath, fileName});
        }
        logger.infoV("Writing base=%s split=%s chunk=%s -> target = %s", new Object[]{this.basePath, this.splitId, chunkId, fileName});
        chunk.fos = this.writeToStream(chunk.tmpFilePath);
        if (fileName.endsWith(".gz")) {
            chunk.countingStream = new CountingOutputStream(chunk.fos);
            chunk.finalOutputStream = new GZIPOutputStream((OutputStream)chunk.countingStream);
        } else {
            chunk.countingStream = new CountingOutputStream(chunk.fos);
            chunk.finalOutputStream = chunk.countingStream;
        }
        this.onChunkInitDone(chunkId, chunk.finalFilePath);
    }

    @Override
    public ExtensibleOutputWriter.SplitChunk reopenChunk(ExtensibleOutputWriter.SplitChunk chunk) throws Exception {
        this.closeChunk(chunk);
        int idx = this.activeChunks.indexOf(chunk);
        chunk = this.makeNewChunk(this.authCtx, this.projectKey, this.formatType, this.formatParams, this.schema, this.warningsContext);
        this.initOneChunk(chunk);
        this.chunks.add(chunk);
        if (idx >= 0) {
            this.activeChunks.set(idx, chunk);
        } else {
            this.activeChunks.add(chunk);
        }
        if (this.headerEmitted) {
            chunk.formatter.header(this.cf, chunk.finalOutputStream);
        }
        return chunk;
    }
}

