/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.pivot.backend.EngineSelector;
import com.dataiku.dip.pivot.backend.dss.LinoPivotTablesService;
import com.dataiku.dip.pivot.backend.dss.aggregators.PercentilesAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.ColumnSummary;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.sql.SQLPivotTablesService;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.analysis.MultiCorrelator;
import com.dataiku.dip.shaker.model.ChartsOnDatasetDataSpec;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PivotTablesService {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.reports");
    @Autowired
    private SQLPivotTablesService sqlService;
    @Autowired
    private LinoPivotTablesService linoService;

    public static void expandSampleSettingsFromScriptIfNeeded(ChartsOnDatasetDataSpec dataSpec) {
        if (dataSpec.copySelectionFromScript && dataSpec.engineType != SerializedShakerScript.ChartsEngine.SQL && dataSpec.engineType != SerializedShakerScript.ChartsEngine.SPARKSQL) {
            dataSpec.sampleSettings = (SerializedShakerScript.RefreshableStreamableSelection)JSON.parse((String)JSON.json((Object)dataSpec.script.explorationSampling), SerializedShakerScript.RefreshableStreamableSelection.class);
            if (dataSpec.sampleSettings.selection.samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT) {
                dataSpec.sampleSettings.selection.samplingMethod = SamplingParam.SamplingMethod.RANDOM_FIXED_NB;
            } else if (dataSpec.sampleSettings.selection.samplingMethod == SamplingParam.SamplingMethod.STRATIFIED_TARGET_NB_EXACT) {
                dataSpec.sampleSettings.selection.samplingMethod = SamplingParam.SamplingMethod.RANDOM_FIXED_NB;
            } else if (dataSpec.sampleSettings.selection.samplingMethod == SamplingParam.SamplingMethod.STRATIFIED_TARGET_RATIO_EXACT) {
                dataSpec.sampleSettings.selection.samplingMethod = SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO;
            } else if (dataSpec.sampleSettings.selection.samplingMethod == SamplingParam.SamplingMethod.TAIL_SEQUENTIAL) {
                dataSpec.sampleSettings.selection.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
            }
        } else if (dataSpec.sampleSettings == null) {
            dataSpec.sampleSettings = new SerializedShakerScript.RefreshableStreamableSelection();
        }
    }

    public ColumnSummary getColumnSummary_NT(AuthCtx authCtx, Dataset dataset, DSSConnection connection, ChartsOnDatasetDataSpec dataSpec) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        PivotTablesService.expandSampleSettingsFromScriptIfNeeded(dataSpec);
        if (dataset.getPartitioningSchema() != null && !dataset.getPartitioningSchema().isPartitioned() && dataSpec.sampleSettings.selection != null) {
            dataSpec.sampleSettings.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
        }
        try {
            EngineSelector.checkEngineOK(authCtx, dataset, connection, dataSpec.script.steps, dataSpec.engineType);
        }
        catch (Exception e) {
            logger.warn((Object)"Getting column summary with SQL failed, fallback to Lino", (Throwable)e);
            dataSpec.engineType = SerializedShakerScript.ChartsEngine.LINO;
        }
        logger.info((Object)("Getting columns summary dataset=" + dataset.getFullName()));
        switch (dataSpec.engineType) {
            case LINO: {
                return this.linoService.getColumnSummary_NT(authCtx, dataset, dataSpec.script, dataSpec.sampleSettings, dataSpec.script.steps);
            }
            case SQL: 
            case SPARKSQL: {
                if (dataSpec.sampleSettings.selection != null) {
                    dataSpec.sampleSettings.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
                }
                try {
                    return this.sqlService.getColumnSummary_NT(authCtx, dataset, dataSpec.script, dataSpec.sampleSettings, dataSpec.script.steps, dataSpec.engineType);
                }
                catch (Exception e) {
                    logger.warn((Object)"Getting column summary with SQL failed, fallback to Lino", (Throwable)e);
                    return this.linoService.getColumnSummary_NT(authCtx, dataset, dataSpec.script, dataSpec.sampleSettings, dataSpec.script.steps);
                }
            }
        }
        throw new Error("unreachable");
    }

    public FutureResponse<Response> getResponse_NT(AuthCtx authCtx, Dataset dataset, DSSConnection connection, String requestedSampleId, ChartsOnDatasetDataSpec dataSpec, PivotTableRequest request) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        PivotTablesService.expandSampleSettingsFromScriptIfNeeded(dataSpec);
        if (dataset.getPartitioningSchema() != null && !dataset.getPartitioningSchema().isPartitioned() && dataSpec.sampleSettings.selection != null) {
            dataSpec.sampleSettings.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
        }
        EngineSelector.checkEngineOK(authCtx, dataset, connection, dataSpec.script.steps, request, dataSpec.engineType);
        FilterUtils.expandRelativeDateFilters(request);
        if (request instanceof PivotTableAggregatedRequest) {
            for (Aggregation aggregation : ((PivotTableAggregatedRequest)request).aggregations) {
                if (aggregation.function != Aggregation.Function.PERCENTILE) continue;
                PercentilesAggregator.percentileValueCheck(aggregation.percentile);
            }
        }
        switch (dataSpec.engineType) {
            case LINO: {
                return this.linoService.getResponse_NT(authCtx, dataset, requestedSampleId, dataSpec.script, dataSpec.sampleSettings, dataSpec.script.steps, request);
            }
            case SQL: 
            case SPARKSQL: {
                if (dataSpec.sampleSettings.selection != null) {
                    dataSpec.sampleSettings.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
                }
                return this.sqlService.getResponse_NT(request, requestedSampleId, dataset, dataSpec.script, dataSpec.script.steps, dataSpec.sampleSettings, authCtx, dataSpec.engineType);
            }
        }
        throw new Error("unreachable");
    }

    public void invalidateCache(Dataset ds) throws IOException {
        File cacheFolder = ApplicationConfigurator.getFile((String)("caches/shaker-full-pivot-lino/" + ds.getProjectKey() + "_" + ds.getName()));
        DKUFileUtils.deleteDirectory((File)cacheFolder);
        this.sqlService.invalidateDataset(ds.getFullName());
    }

    public void invalidateCacheForProject(String projectKey) throws IOException {
        File cacheFolder = ApplicationConfigurator.getFile((String)"caches/shaker-full-pivot-lino/");
        File[] cachedDatasetDirs = cacheFolder.listFiles((dir, name) -> name.startsWith(projectKey + "_"));
        if (cachedDatasetDirs != null) {
            for (File datasetDir : cachedDatasetDirs) {
                DKUFileUtils.deleteDirectory((File)datasetDir);
            }
        }
        this.sqlService.invalidateProject(projectKey);
    }

    public static class Response {
        public MultiCorrelator.MultiCorrelation correlationResponse;
        public PivotTableResponse pivotResponse;
        public String updatedSampleId;
        public EngineSelector.EngineWithReason engine;
    }
}

