/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.automaticbin;

import com.dataiku.dip.pivot.backend.common.automaticbin.AxesBinningModes;
import com.dataiku.dip.pivot.backend.common.automaticbin.BinningModeComputer;
import com.dataiku.dip.pivot.backend.common.automaticbin.ComputedBinningModes;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ComputedBinningModesIterator
implements Iterator<AxesBinningModes> {
    private static final int NO_ELEMENT_INDEX = -1;
    private final ComputedBinningModes invalidBinningModes;
    private Integer currentAutomaticAxisIndexToProcess;
    private final Set<Integer> processedAxesIndices = new HashSet<Integer>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.charts.automaticbin");

    ComputedBinningModesIterator(ComputedBinningModes invalidBinningModes) {
        this.invalidBinningModes = invalidBinningModes;
    }

    @Override
    public boolean hasNext() {
        return this.getAutomaticAxisIndexToProcess() != -1;
    }

    private Integer getAutomaticAxisIndexToProcess() {
        if (this.currentAutomaticAxisIndexToProcess != null) {
            return this.currentAutomaticAxisIndexToProcess;
        }
        if (this.invalidBinningModes.isEmpty()) {
            logger.debug((Object)"No computed binning mode to process.");
            return -1;
        }
        this.currentAutomaticAxisIndexToProcess = -1;
        Iterator<Integer> descendingAutomaticAxesIndicesIterator = this.invalidBinningModes.getDescendingAxesIndicesIterator();
        while (this.currentAutomaticAxisIndexToProcess == -1 && descendingAutomaticAxesIndicesIterator.hasNext()) {
            boolean isLastValidAggregationLevel;
            Integer lastAutomaticAxisIndex = descendingAutomaticAxesIndicesIterator.next();
            if (this.processedAxesIndices.contains(lastAutomaticAxisIndex)) {
                logger.debugV("Attempt to reduce cardinality for automatic axis (index=%s) already failed: moving to next automatic axis.", new Object[]{lastAutomaticAxisIndex});
                continue;
            }
            ComputedBinningModes.AxisComputedBinningMode invalidBinningMode = this.invalidBinningModes.get(lastAutomaticAxisIndex);
            if (invalidBinningMode.getNumberOfBin() <= 1) {
                logger.debugV("Not enough bins in computed binning mode for automatic axis (index=%s): skipping next bigger binning analysis for this automatic axis.", new Object[]{lastAutomaticAxisIndex});
                this.processedAxesIndices.add(lastAutomaticAxisIndex);
                continue;
            }
            int indexOfInvalidMode = BinningModeComputer.VALID_AGGREGATION_LEVELS.indexOf((Object)invalidBinningMode.getMode());
            boolean bl = isLastValidAggregationLevel = indexOfInvalidMode == BinningModeComputer.VALID_AGGREGATION_LEVELS.size() - 1;
            if (isLastValidAggregationLevel) {
                logger.debugV("Could not find a bigger binning mode for automatic axis (index=%s): moving to next automatic axis.", new Object[]{lastAutomaticAxisIndex});
                this.processedAxesIndices.add(lastAutomaticAxisIndex);
                continue;
            }
            this.currentAutomaticAxisIndexToProcess = lastAutomaticAxisIndex;
        }
        if (this.currentAutomaticAxisIndexToProcess == -1) {
            logger.warn((Object)"Could not find any bigger binning mode for automatic axes.");
        }
        return this.currentAutomaticAxisIndexToProcess;
    }

    @Override
    public AxesBinningModes next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Integer automaticAxisIndex = this.getAutomaticAxisIndexToProcess();
        this.currentAutomaticAxisIndexToProcess = null;
        ComputedBinningModes.AxisComputedBinningMode invalidBinningMode = this.invalidBinningModes.get(automaticAxisIndex);
        int indexOfInvalidMode = BinningModeComputer.VALID_AGGREGATION_LEVELS.indexOf((Object)invalidBinningMode.getMode());
        AxesBinningModes result = new AxesBinningModes((int)automaticAxisIndex, BinningModeComputer.VALID_AGGREGATION_LEVELS.get(indexOfInvalidMode + 1));
        logger.debugV("Next bigger binning mode for axis found: %s", new Object[]{result});
        this.processedAxesIndices.add(automaticAxisIndex);
        return result;
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }
}

