/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.automaticbin;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import gnu.trove.list.array.TLongArrayList;

public class TimeInterval {
    private long start = Long.MAX_VALUE;
    private long end = Long.MIN_VALUE;

    public void addTimestamp(long timestamp) {
        this.start = Math.min(timestamp, this.start);
        this.end = Math.max(timestamp, this.end);
    }

    public ReadableInstant startTime() {
        return this.toUTCReadableInstant(this.start);
    }

    public ReadableInstant endTime() {
        return this.toUTCReadableInstant(this.end);
    }

    public String toString() {
        return String.format("[start=%s, end=%s]", this.startTime(), this.endTime());
    }

    private ReadableInstant toUTCReadableInstant(long timestamp) {
        return new DateTime(timestamp, DateTimeZone.UTC);
    }

    public TLongArrayList toTLongArrayList() {
        TLongArrayList result = new TLongArrayList();
        if (this.start == Long.MAX_VALUE && this.end == Long.MIN_VALUE) {
            return result;
        }
        result.add(this.start);
        result.add(this.end);
        return result;
    }
}

