/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.common.datebinner.BinInterval;
import com.dataiku.dip.pivot.backend.common.datebinner.IDateBinner;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.DateAxisParams;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.google.common.annotations.VisibleForTesting;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.List;

public class DateAxisHandler
implements AxisHandler {
    private final IDateBinner dateBinner;
    private TLongSet binIds = new TLongHashSet(100);
    private Column col;
    private AnyTemporal anyTemporalType = new AnyTemporal();
    private BinInterval binInterval;
    private List<AxisElt> axisElts;

    DateAxisHandler(Column col, DateAxisParams.BinningMode mode) {
        this.col = col;
        this.dateBinner = mode.getDateBinner();
    }

    @VisibleForTesting
    void binify(long ts) {
        long binId = this.dateBinner.getBinId(ts);
        if (this.binIds.contains(binId)) {
            return;
        }
        this.binIds.add(binId);
    }

    @Override
    public void observe(Row row) {
        String v = row.get(this.col);
        if (v == null || v.isEmpty()) {
            return;
        }
        long ts = this.anyTemporalType.longValue(v);
        if (ts == Long.MAX_VALUE) {
            return;
        }
        this.binify(ts);
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            double d;
            if (filters != null && !filters[i] || Double.isNaN(d = block.doubles[i])) continue;
            this.binify((long)d);
        }
    }

    @Override
    public int getNbBins() {
        return this.getBinInterval().getNbBins();
    }

    @VisibleForTesting
    public BinInterval getBinInterval() {
        if (this.binInterval == null) {
            this.binInterval = this.dateBinner.getBinIntervalFromBinIds(this.binIds);
        }
        return this.binInterval;
    }

    @Override
    public void getBins(ColumnBlock block, int[] ret, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            int binIndex;
            if (filters != null && !filters[i]) {
                ret[i] = 0;
                continue;
            }
            double d = block.doubles[i];
            if (Double.isNaN(d)) {
                ret[i] = -1;
                continue;
            }
            long ts = (long)d;
            long binId = this.dateBinner.getBinId(ts);
            ret[i] = binIndex = (int)(binId - this.getBinInterval().getMinBin());
        }
    }

    @Override
    public List<AxisElt> getAxisElts() {
        if (this.axisElts == null) {
            this.axisElts = this.dateBinner.getNaturallyOrderedAxisElementsFromBinIdRange(this.binIds);
        }
        return this.axisElts;
    }
}

