/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.common.datebinner.IDateBinner;
import com.dataiku.dip.pivot.backend.dss.PivotTableUtils;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.AverageAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.BiFuncAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.BiFuncGenericAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.CountAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.CountDistinctAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.PercentilesAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.SimpleCustomAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.SumAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.TensorCustomAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.VarianceAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.EmptyCustomBinsException;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.NumericalAxisElt;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class PivotUtils {
    public static final String DKU_NO_VALUE = "___dku_no_value___";
    public static final String TOTAL_VALUE = "___dku_total_value___";
    public static final String DKU_NO_VALUE_LABEL = "No value";
    public static final long DKU_NO_VALUE_BIN = -1L;
    public static final String DKU_OTHERS_VALUE = "___dku_others_value___";
    public static final String SQL_COLUMN_ALIAS_PREFIX = "dku_aggr_";
    public static final String AGGREGATORS_DIRECTORY = "aggregators";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    public static AbstractAggregator<?> buildAggregator(VariablesContext variablesContext, LinoReader linoReader, boolean formulaValidation, Aggregation req, Object ... args) {
        Aggregation.Function function = req.function;
        switch (function) {
            case COUNT: {
                if (args.length == 0) {
                    return new CountAggregator(req);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new CountAggregator(req, (Integer)args[0]);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new CountAggregator(req, (int[])args[0]);
            }
            case COUNTD: {
                if (args.length == 0) {
                    return new CountDistinctAggregator(req);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new CountDistinctAggregator(req, (Integer)args[0]);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new CountDistinctAggregator(req, (int[])args[0]);
            }
            case SUM: {
                if (args.length == 0) {
                    return new SumAggregator(req);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new SumAggregator(req, (Integer)args[0]);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new SumAggregator(req, (int[])args[0]);
            }
            case AVG: {
                if (args.length == 0) {
                    return new AverageAggregator(req);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new AverageAggregator(req, (Integer)args[0]);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new AverageAggregator(req, (int[])args[0]);
            }
            case MIN: {
                if (args.length == 0) {
                    return new BiFuncAggregator(req, Math::min, Double.POSITIVE_INFINITY);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new BiFuncAggregator(req, (Integer)args[0], Math::min, (Double)Double.POSITIVE_INFINITY);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new BiFuncAggregator(req, (int[])args[0], Math::min, (Double)Double.POSITIVE_INFINITY);
            }
            case MAX: {
                if (args.length == 0) {
                    return new BiFuncAggregator(req, Math::max, Double.NEGATIVE_INFINITY);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new BiFuncAggregator(req, (Integer)args[0], Math::max, (Double)Double.NEGATIVE_INFINITY);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new BiFuncAggregator(req, (int[])args[0], Math::max, (Double)Double.NEGATIVE_INFINITY);
            }
            case OBJECT_MIN: {
                if (args.length == 0) {
                    return new BiFuncGenericAggregator(req, BiFuncGenericAggregator.Type.MIN);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new BiFuncGenericAggregator(req, (Integer)args[0], BiFuncGenericAggregator.Type.MIN);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new BiFuncGenericAggregator(req, (int[])args[0], BiFuncGenericAggregator.Type.MIN);
            }
            case OBJECT_MAX: {
                if (args.length == 0) {
                    return new BiFuncGenericAggregator(req, BiFuncGenericAggregator.Type.MAX);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new BiFuncGenericAggregator(req, (Integer)args[0], BiFuncGenericAggregator.Type.MAX);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new BiFuncGenericAggregator(req, (int[])args[0], BiFuncGenericAggregator.Type.MAX);
            }
            case MEDIAN: 
            case PERCENTILE: {
                if (args.length == 0) {
                    return new PercentilesAggregator(req);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new PercentilesAggregator(req, (Integer)args[0]);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new PercentilesAggregator(req, (int[])args[0]);
            }
            case STDEV_POPULATION: 
            case STDEV: 
            case VARIANCE_POPULATION: 
            case VARIANCE: {
                if (args.length == 0) {
                    return new VarianceAggregator(req);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new VarianceAggregator(req, (Integer)args[0]);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new VarianceAggregator(req, (int[])args[0]);
            }
            case CUSTOM: {
                if (args.length == 0) {
                    return new SimpleCustomAggregator(req, variablesContext, formulaValidation, linoReader);
                }
                if (args.length == 1 && args[0] instanceof Integer) {
                    return new SimpleCustomAggregator(req, (Integer)args[0], variablesContext, linoReader);
                }
                if (args.length != 1 || !(args[0] instanceof int[])) break;
                return new TensorCustomAggregator(req, (int[])args[0], variablesContext, linoReader);
            }
            default: {
                throw new IllegalArgumentException("Unexpected value for aggregator function: " + String.valueOf((Object)function));
            }
        }
        throw new IllegalArgumentException("Invalid arguments for aggregator function: " + String.valueOf((Object)function));
    }

    public static AbstractAggregator<?> buildAggregator(VariablesContext variablesContext, LinoReader linoReader, Aggregation req, Object ... args) {
        return PivotUtils.buildAggregator(variablesContext, linoReader, false, req, args);
    }

    public static boolean aggregationProduceAlphanumericalResult(Aggregation.Function aggregation, TensorType inferredType) {
        if (Aggregation.Function.OBJECT_MAX.equals((Object)aggregation) || Aggregation.Function.OBJECT_MIN.equals((Object)aggregation)) {
            return true;
        }
        return Aggregation.Function.CUSTOM.equals((Object)aggregation) && !TensorType.NUMERICAL.equals((Object)inferredType);
    }

    public static void cleanupAggregators(List<AbstractAggregator<?>> aggregators) {
        for (AbstractAggregator<?> aggregator : aggregators) {
            try {
                aggregator.close();
            }
            catch (Exception e) {
                logger.error((Object)("Cannot close aggregator: " + String.valueOf(aggregator)));
            }
        }
    }

    public static Comparator<FilterFacet.Val> buildStringComparator(ChartFilter.FilterSortingOptions sortingOptions) {
        Comparator nullsAwareStringComparator = sortingOptions.isAscending() ? Comparator.nullsLast(String::compareTo) : Comparator.nullsFirst(String::compareTo);
        Comparator<FilterFacet.Val> naturalOrderComparator = Comparator.comparing(PivotUtils::extractKeyForComparator, nullsAwareStringComparator);
        return PivotUtils.buildGenericComparator(naturalOrderComparator, sortingOptions);
    }

    public static Comparator<FilterFacet.Val> buildDoubleComparator(ChartFilter.FilterSortingOptions sortingOptions) {
        Comparator<FilterFacet.Val> naturalComparator = Comparator.comparingDouble(val -> {
            if (DKU_NO_VALUE.equals(val.id)) {
                return sortingOptions.isAscending() ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            return Double.parseDouble(val.id);
        });
        return PivotUtils.buildGenericComparator(naturalComparator, sortingOptions);
    }

    public static Comparator<FilterFacet.Val> buildDateComparator(ChartFilter.FilterSortingOptions sortingOptions, IDateBinner dateBinner) {
        Comparator<FilterFacet.Val> naturalOrderComparator = Comparator.comparingLong(val -> {
            if (DKU_NO_VALUE.equals(val.id)) {
                return sortingOptions.isAscending() ? Long.MAX_VALUE : Long.MIN_VALUE;
            }
            return dateBinner.getSqlValueFromBinId(Long.parseLong(val.id));
        });
        return PivotUtils.buildGenericComparator(naturalOrderComparator, sortingOptions);
    }

    public static Comparator<FilterFacet.Val> buildGenericComparator(Comparator<FilterFacet.Val> naturalOrderComparator, ChartFilter.FilterSortingOptions sortingOptions) {
        Comparator<FilterFacet.Val> valueComparator = null;
        Comparator<FilterFacet.Val> boostedEncounteredValues = Comparator.comparingInt(val -> val.count > 0L ? 0 : 1);
        if (!sortingOptions.isAscending()) {
            boostedEncounteredValues = boostedEncounteredValues.reversed();
        }
        if (sortingOptions.getType() == ChartFilter.FilterSortingType.NATURAL_ORDER) {
            valueComparator = boostedEncounteredValues.thenComparing(naturalOrderComparator);
        }
        if (sortingOptions.getType() == ChartFilter.FilterSortingType.COUNT) {
            valueComparator = boostedEncounteredValues.thenComparingLong(val -> val.count).thenComparingLong(val -> val.rowCount != null ? val.rowCount : 0L).thenComparing(naturalOrderComparator);
        }
        if (valueComparator != null && !sortingOptions.isAscending()) {
            valueComparator = valueComparator.reversed();
        }
        return valueComparator;
    }

    public static String extractKeyForComparator(FilterFacet.Val val) {
        if (DKU_NO_VALUE.equals(val.id)) {
            return null;
        }
        return val.id;
    }

    public static List<Double> getValidatedCustomBins(AxisDef axis) {
        List<Double> customBins = axis.numParams.customBinValues;
        if (customBins == null || customBins.isEmpty()) {
            String message = Boolean.TRUE.equals(axis.isRBND) ? String.format("Please add some custom bins to your reusable dimension named \"%s\" (based on \"%s\").", axis.name, axis.column) : String.format("Please add some custom bins to your dimension \"%s\".", axis.column);
            throw new EmptyCustomBinsException(message);
        }
        customBins.sort(Double::compareTo);
        return customBins;
    }

    public static List<AxisElt> getCustomBinsAxisElts(List<Double> validatedCustomBins, double min, double max) {
        ArrayList<AxisElt> ret = new ArrayList<AxisElt>();
        PivotTableUtils.NumberFormatter formatter = new PivotTableUtils.NumberFormatter(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, validatedCustomBins.size() + 1, false);
        NumericalAxisElt lessThanElt = new NumericalAxisElt();
        double minBin = validatedCustomBins.get(0);
        lessThanElt.sortValue = validatedCustomBins.get(0) - 1.0;
        lessThanElt.min = Math.min(min, minBin);
        lessThanElt.max = minBin;
        lessThanElt.label = "<" + formatter.format(validatedCustomBins.get(0));
        ret.add(lessThanElt);
        for (int i = 0; i < validatedCustomBins.size() - 1; ++i) {
            NumericalAxisElt elt = new NumericalAxisElt();
            elt.sortValue = (validatedCustomBins.get(i) + validatedCustomBins.get(i + 1)) / 2.0;
            elt.min = validatedCustomBins.get(i);
            elt.max = validatedCustomBins.get(i + 1);
            elt.label = formatter.format(validatedCustomBins.get(i)) + "-" + formatter.format(validatedCustomBins.get(i + 1));
            ret.add(elt);
        }
        NumericalAxisElt greaterThanElt = new NumericalAxisElt();
        double maxBin = validatedCustomBins.get(0);
        greaterThanElt.sortValue = validatedCustomBins.get(validatedCustomBins.size() - 1) + 1.0;
        greaterThanElt.min = validatedCustomBins.get(validatedCustomBins.size() - 1);
        greaterThanElt.max = Math.max(max, maxBin);
        greaterThanElt.label = "\u2265" + formatter.format(validatedCustomBins.get(validatedCustomBins.size() - 1));
        ret.add(greaterThanElt);
        return ret;
    }

    private PivotUtils() {
    }
}

