/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.scatter;

import com.dataiku.dip.pivot.backend.model.Unaggregated;
import com.dataiku.dip.utils.DKUtils;
import java.util.Calendar;

public class UnaggregatedDateHelper {
    private Calendar cal = DKUtils.getUTCCalendar();
    private static final String[] dow = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

    public String getValue(long timestamp, Unaggregated.DateMode mode) {
        this.cal.setTimeInMillis(timestamp);
        switch (mode) {
            case HOUR_OF_DAY: {
                return "" + this.cal.get(11);
            }
            case DAY_OF_WEEK: {
                return dow[this.cal.get(7) - 1];
            }
            case DAY_OF_MONTH: {
                return "" + this.cal.get(5);
            }
            case WEEK_OF_YEAR: {
                int woy = this.cal.get(3);
                if (woy == 53) {
                    System.err.println("Unexpected week 53 for " + DKUtils.isoFormatPretty((long)timestamp));
                    woy = 52;
                }
                return "" + woy;
            }
            case MONTH_OF_YEAR: {
                return "" + (this.cal.get(2) + 1);
            }
            case QUARTER_OF_YEAR: {
                return "" + (this.cal.get(2) / 3 + 1);
            }
            case YEAR: {
                return "" + this.cal.get(1);
            }
        }
        return "";
    }
}

