/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisSortPrune;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.SimpleAggregatedRequest;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.pivot.backend.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.pivot.backend.sql.queries.SimpleAxisToSQL;
import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.DremioSQLDialect;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.TreasureDataSQLDialect;
import com.dataiku.dip.sql.TrinoSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AxisMaterializerToSQL {
    private final VariablesService variablesService;
    private InputTable input;
    private PivotTableAggregatedRequest req;
    private BasicStatsBuilder.BasicStats stats;
    private final BasicStatsBuilder.BasicStats globalStats;
    private ColumnMapper colMapping;
    private SQLDialect dialect;

    public AxisMaterializerToSQL(InputTable input, PivotTableAggregatedRequest req, BasicStatsBuilder.BasicStats stats, BasicStatsBuilder.BasicStats globalStats, ColumnMapper colMapping) {
        this.input = input;
        this.req = req;
        this.stats = stats;
        this.dialect = input.dialect;
        this.globalStats = globalStats;
        this.colMapping = colMapping;
        this.variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
    }

    public static boolean mayRequireJoin(boolean single, AxisDef def, boolean hasDistinctAggr) {
        if (!AxisMaterializerToSQL.requireMaterialization(single, def, hasDistinctAggr)) {
            return false;
        }
        if (single) {
            return (def.type == AxisDef.Type.ALPHANUM || def.type == AxisDef.Type.NUMERICAL) && def.sortPrune.generateOthersCategory && def.sortPrune.isMaxValuesDefined();
        }
        if (def == null) {
            return true;
        }
        if (def.type == AxisDef.Type.DATE) {
            return false;
        }
        return !(def.type == AxisDef.Type.NUMERICAL ? def.numParams.mode == NumericalAxisParams.BinningMode.NONE && !def.sortPrune.isMaxValuesDefined() : def.type == AxisDef.Type.ALPHANUM && !def.sortPrune.isMaxValuesDefined());
    }

    static boolean requireMaterialization(boolean single, AxisDef def, boolean hasDistinctAggr) {
        boolean naturallyOrdered;
        if (single) {
            if (def != null && (def.type == AxisDef.Type.ALPHANUM || def.type == AxisDef.Type.NUMERICAL && def.numParams.mode == NumericalAxisParams.BinningMode.NONE)) {
                return def.sortPrune.generateOthersCategory && def.sortPrune.isMaxValuesDefined();
            }
            return false;
        }
        if (hasDistinctAggr) {
            return true;
        }
        boolean bl = naturallyOrdered = def.sortPrune.sortType == AxisSortPrune.SortType.NATURAL;
        if (def.type == AxisDef.Type.NUMERICAL) {
            return !naturallyOrdered || def.numParams.mode != NumericalAxisParams.BinningMode.FIXED_NB && def.numParams.mode != NumericalAxisParams.BinningMode.FIXED_SIZE;
        }
        if (def.type == AxisDef.Type.DATE) {
            return def.dateParams.mode.getDateBinner().requireMaterializationForSqlEngine(naturallyOrdered);
        }
        return true;
    }

    private static boolean hasDistinctAggr(PivotTableAggregatedRequest req) {
        for (Aggregation aggregation : req.aggregations) {
            if (aggregation.function != Aggregation.Function.COUNTD) continue;
            return true;
        }
        return false;
    }

    private MaterializedAxis buildAxis(boolean single, AxisDef def) {
        MaterializedAxis sqlAxis = new MaterializedAxis();
        SimpleAxisToSQL axisBuilder = new SimpleAxisToSQL(this.input, this.req, def, this.stats, this.colMapping);
        axisBuilder.setGenerateAliasForAxis(true);
        boolean hasDistinctAggr = AxisMaterializerToSQL.hasDistinctAggr(this.req);
        if (def != null && def.type == AxisDef.Type.ALPHANUM && AxisMaterializerToSQL.requireMaterialization(single, def, hasDistinctAggr) && this.dialect instanceof MySQLDialect) {
            axisBuilder.setForceVarcharCast(true);
        }
        axisBuilder.setComputeAggregate(single || hasDistinctAggr);
        sqlAxis.axis = axisBuilder.buildAxis(null, null, this.globalStats);
        sqlAxis.builder = axisBuilder;
        AbstractSQLConnection.SQLManagedDatasetNamingRule namingRule = this.getNamingRuleOrDefault(this.input);
        VariablesContext variablesContext = this.variablesService.getContext(this.input.projectKey);
        String catalog = variablesContext.expand(namingRule.catalog);
        String schema = variablesContext.expand(namingRule.schemaName);
        if (this.dialect instanceof TrinoSQLDialect) {
            if (StringUtils.isBlank((String)schema)) {
                schema = this.input.table.getSchemaNullIfBlank();
            }
            if (StringUtils.isBlank((String)schema)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_MISSING_SCHEMA, "Cannot create temporary tables because schema for the dataset is not set. Open the settings for the input dataset and set a schema.");
            }
            if (this.dialect instanceof TreasureDataSQLDialect) {
                catalog = "td-presto";
            } else {
                if (StringUtils.isBlank((String)catalog)) {
                    catalog = this.input.table.getCatalog();
                }
                if (StringUtils.isBlank((String)catalog)) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_MISSING_SCHEMA, "Cannot create temporary tables because catalog for the dataset is not set. Open the settings for the input dataset and set a catalog.");
                }
            }
        } else if (this.dialect instanceof DremioSQLDialect) {
            if (StringUtils.isBlank((String)schema)) {
                schema = this.input.table.getSchemaNullIfBlank();
            }
            if (StringUtils.isBlank((String)schema)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_MISSING_SCHEMA, "Cannot create temporary tables because schema for the dataset is not set. Open the settings for the input dataset and set a schema.");
            }
        }
        sqlAxis.tempTableTable = this.dialect.getSafeRandomTemporaryTableName(catalog, schema, Objects.requireNonNullElse(variablesContext.expand(namingRule.tableNameDatasetNamePrefix), "dku_temp_"), Objects.requireNonNullElse(variablesContext.expand(namingRule.tableNameDatasetNameSuffix), ""));
        Logger.getLogger((String)"dku").info((Object)("Will create Axis table: " + JSON.json((Object)sqlAxis.tempTableTable)));
        sqlAxis.createTableQuery = this.dialect.createTemporaryTableAs(sqlAxis.tempTableTable, sqlAxis.axis.query.toSQL());
        SelectQueryBuilder selectBuilder = new SelectQueryBuilder(this.dialect);
        selectBuilder.fromTable(sqlAxis.tempTableTable, "main");
        for (SimpleAxisToSQL.AxisQueryContext.AxisOrdering ordering : sqlAxis.axis.order) {
            if (ordering.needCaseWhen) {
                selectBuilder.orderBy(ExpressionUtils.ef.caseWhen(ExpressionUtils.ef.expr(this.dialect.quoteIdentifier(ordering.columnName)).eq("___dku_no_value___"), ExpressionUtils.ef.cst(0), ExpressionUtils.ef.cst(1)).toSQL(this.dialect), ordering.asc);
            }
            selectBuilder.orderBy(this.dialect.quoteIdentifier(ordering.columnName), ordering.asc);
        }
        sqlAxis.selectTableQuery = selectBuilder.toSQL();
        sqlAxis.dropTableQuery = this.dialect.dropTemporaryTable(sqlAxis.tempTableTable);
        sqlAxis.truncateTableQuery = "TRUNCATE TABLE " + this.dialect.getQuotedTableFullName(sqlAxis.tempTableTable);
        if (!sqlAxis.axis.mapping.axisRefs.isEmpty()) {
            String indexName = QueryUtils.safeRandomIdentifier("dku_index_");
            sqlAxis.createIndexQuery = this.dialect.getCreateIndexStatement(indexName, sqlAxis.tempTableTable, this.dialect.quoteIdentifier(sqlAxis.axis.mapping.axisRefs.get((int)0).name));
        }
        sqlAxis.requireMaterialization = AxisMaterializerToSQL.requireMaterialization(single, def, hasDistinctAggr);
        sqlAxis.mayRequireJoin = AxisMaterializerToSQL.mayRequireJoin(single, def, hasDistinctAggr);
        return sqlAxis;
    }

    private AbstractSQLConnection.SQLManagedDatasetNamingRule getNamingRuleOrDefault(InputTable input) {
        if (input != null && input.connection != null && input.connection.getConnection() != null && input.connection.getConnection().getParams() != null && input.connection.getConnection().getParams().namingRule != null) {
            return input.connection.getConnection().getParams().namingRule;
        }
        return new AbstractSQLConnection.SQLManagedDatasetNamingRule();
    }

    public MaterializedAxesContext build() {
        MaterializedAxesContext axes = new MaterializedAxesContext();
        if (this.req instanceof PivotTableTensorRequest) {
            PivotTableTensorRequest treq = (PivotTableTensorRequest)this.req;
            for (AxisDef axisDef : treq.axes) {
                axes.axes.add(this.buildAxis(treq.axes.length == 1 && !treq.computeSubTotals, axisDef));
            }
        } else if (this.req instanceof SimpleAggregatedRequest) {
            axes.axes.add(this.buildAxis(true, null));
        } else {
            throw new UnsupportedOperation("Unsupported request type");
        }
        return axes;
    }

    public static class MaterializedAxis {
        public SimpleAxisToSQL builder;
        public SimpleAxisToSQL.AxisQueryContext axis;
        public String[] createTableQuery;
        public String dropTableQuery;
        public String truncateTableQuery;
        public SQLUtils.SQLTable tempTableTable;
        public String selectTableQuery;
        public String createIndexQuery;
        public boolean requireMaterialization;
        public boolean mayRequireJoin;
    }

    public static class MaterializedAxesContext {
        public List<MaterializedAxis> axes = new ArrayList<MaterializedAxis>();
    }
}

