/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckRunInfo;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckRunResult;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@UIModel
@PartOfPublicAPI
public class ProjectStandardsRunReport {
    public String projectKey;
    @Nullable
    public String scope;
    public String requester;
    @Nullable
    public String requesterDisplayName;
    public Map<String, ProjectStandardsCheckRunInfo> bundleChecksRunInfo = new HashMap<String, ProjectStandardsCheckRunInfo>();
    public String startTime;
    public long totalDurationMs;

    private ProjectStandardsRunReport() {
    }

    public ProjectStandardsRunReport(String projectKey) {
        this.projectKey = projectKey;
    }

    private int mapSeverity(ProjectStandardsCheckRunResult result, int errorCheckSeverityMapping) {
        return switch (result.status) {
            case ProjectStandardsCheckRunResult.ProjectStandardsCheckRunStatus.RUN_SUCCESS -> {
                if (result.severity != null) {
                    yield result.severity;
                }
                yield 0;
            }
            case ProjectStandardsCheckRunResult.ProjectStandardsCheckRunStatus.RUN_ERROR -> errorCheckSeverityMapping;
            default -> 0;
        };
    }

    public int worstCheckSeverity(int errorCheckSeverityMapping) {
        return this.bundleChecksRunInfo.values().stream().mapToInt(runInfo -> this.mapSeverity(runInfo.result, errorCheckSeverityMapping)).max().orElse(0);
    }

    public boolean isEmpty() {
        return this.bundleChecksRunInfo.isEmpty();
    }
}

