/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveGlobalMetastoreTablesHandler;
import com.dataiku.dip.hive.HiveLocalMetastoreTablesHandler;
import com.dataiku.dip.hive.HiveMetastoreTablesHandler;
import com.dataiku.dip.hive.HiveScriptPreprocessor;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.code.hive.AbstractHiveRecipeRunner;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveRecipeRunner
extends AbstractHiveRecipeRunner
implements FlowRunnable,
RecipeRunner,
RecipeRunnerWithPayload {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    private HiveScriptPreprocessor preprocessor;
    private JobActivity activity;
    private RecipeRunnableSubgraph subgraph;
    private FlowRecipe recipe;
    private HiveMetastoreTablesHandler tablesHandler;
    private String code;
    private static Logger logger = Logger.getLogger((String)"dku.recipes.hive.runner");

    public HiveRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
    }

    @Override
    public void setPayload(String payload) {
        this.code = payload;
        if (this.code == null) {
            throw new Error("Could not find Hive script for " + this.recipe.getName());
        }
    }

    @Override
    public synchronized void init() throws Exception {
        Object hiveScript;
        if (this.abortNotified) {
            throw new ActivityAbortedException();
        }
        SerializedRecipe.SerializedRecipeAndPayload srp = new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        if (srp != null && srp.payload != null) {
            this.setPayload(srp.payload);
        }
        if (this.activity != null) {
            this.activity.initStatus();
            for (FlowDataset fd : this.activity.getSubgraph().getTargetsDatasets()) {
                Partition p = this.activity.getSubgraph().getTargetPartition(fd);
                try (DatasetHandler dh = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), fd.getMandatory(this.datasetsDAO));){
                    logger.info((Object)("Hive recipe runner: clear target partition " + String.valueOf(p) + " of " + fd.getFullId()));
                    dh.clearPartitions(Lists.newArrayList((Object[])new Partition[]{p}));
                }
            }
        }
        if ((hiveScript = this.getSql()) == null) {
            throw new Error("Could not find Hive script for " + this.recipe.getName());
        }
        logger.info((Object)("Hive query:\n" + (String)hiveScript));
        String preQueries = this.getPreQueries();
        if (!StringUtils.isBlank((String)preQueries)) {
            hiveScript = preQueries + "\n;\n" + (String)hiveScript;
            logger.info((Object)("Hive query with pre-queries:\n" + (String)hiveScript));
        }
        logger.info((Object)"Preprocessing Hive request");
        MetastoreInspectionService.MetastoreInspector inspector = this.metastoreInspectionService.newInspector(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey());
        switch (this.getExecutionEngine()) {
            case HIVECLI_LOCAL: {
                this.tablesHandler = new HiveLocalMetastoreTablesHandler(this.recipe.getProjectKey(), this.authCtxService.getAuthCtx(), this.canOverrideDatabase(), inspector);
                break;
            }
            case HIVECLI_GLOBAL: {
                this.tablesHandler = new HiveGlobalMetastoreTablesHandler(this.authCtxService.getAuthCtx(), inspector, false);
                break;
            }
            case HIVESERVER2: {
                this.tablesHandler = new HiveGlobalMetastoreTablesHandler(this.authCtxService.getAuthCtx(), inspector, true);
            }
        }
        assert (this.tablesHandler != null);
        HiveSettings hiveSettings = new ClusterSelector().selectForProject(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey()).getHiveSettings();
        this.preprocessor = new HiveScriptPreprocessor(this.authCtxService.getAuthCtx(), this.datasetsDAO, this.variablesService.getContext(this.recipe.getProjectKey()), this.subgraph, (String)hiveScript, this.tablesHandler, this.addDkuUdf(), hiveSettings);
        this.preprocessor.setForceInsertOverwrite(true);
        this.preprocessor.setValidationMode(false);
        this.preprocessor.preprocess();
        logger.info((Object)"Hive script preprocessed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        try {
            this.tablesHandler.prepare();
            logger.info((Object)"Starting up Hive and executing the query (HRR)");
            JobContext jta = JobContext.getCurrentJobContext();
            if (this.activity != null) {
                this.activity.setStatusMessage("Starting Hive");
            }
            List<SimpleKeyValue> extraConf = this.getExtraConf();
            extraConf.addAll(this.tablesHandler.getCollectedExtraConf());
            this.startAndWaitHive(this.activity, jta, this.preprocessor, this.makeListener(this.activity), this.subgraph.id(), extraConf, this.getExecutionEngine(), this.authCtxService.getAuthCtx(), this.subgraph.getRecipe().getProjectKey());
            this.tablesHandler.postProcess();
            if (this.activity != null) {
                this.activity.setStatusMessage("Hive recipe executed successfully");
            }
        }
        finally {
            HiveRecipeRunner hiveRecipeRunner = this;
            synchronized (hiveRecipeRunner) {
                this.runTerminated = true;
                this.notifyAll();
            }
        }
    }

    protected String getSql() throws Exception {
        return this.code;
    }

    protected List<SimpleKeyValue> getExtraConf() throws IOException, DKUSecurityException {
        HiveRecipeMeta.HiveRecipeParams params = RecipeRegistry.getParamsAs(this.activity, HiveRecipeMeta.HiveRecipeParams.class);
        return new HiveConfHelper().getResolvedConf(this.authCtxService.getAuthCtx(), this.recipe.getModel().projectKey, params);
    }

    protected String getPreQueries() throws Exception {
        HiveRecipeMeta.HiveRecipeParams params = RecipeRegistry.getParamsAs(this.activity, HiveRecipeMeta.HiveRecipeParams.class);
        return params.preQueries;
    }

    protected HiveRecipeMeta.HiveExecutionEngine getExecutionEngine() throws Exception {
        HiveRecipeMeta.HiveRecipeParams params = RecipeRegistry.getParamsAs(this.activity, HiveRecipeMeta.HiveRecipeParams.class);
        return params.executionEngine;
    }

    protected boolean addDkuUdf() throws Exception {
        HiveRecipeMeta.HiveRecipeParams params = RecipeRegistry.getParamsAs(this.activity, HiveRecipeMeta.HiveRecipeParams.class);
        return params.addDkuUdf;
    }

    protected boolean canOverrideDatabase() {
        return true;
    }
}

