/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.hadoop.MapredCompressionSetter;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveScriptPreprocessor;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.code.hive.AbstractHiveRecipeRunner;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.variables.VariablesService;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class NonLoopingNonTransformingHiveEngineVisualRecipeRunner
extends AbstractHiveRecipeRunner
implements InitializableAbortableRecipeRunner {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    protected JobActivity activity;
    protected RecipeRunnableSubgraph subgraph;
    protected FlowRecipe recipe;
    protected QueryBunch queryBunch;
    private static Logger logger = Logger.getLogger((String)"dku.recipes.hive.runner");

    public NonLoopingNonTransformingHiveEngineVisualRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
    }

    protected abstract QueryBunch getQueryBunch(HiveSQLDialect var1) throws Exception;

    protected abstract void initializeTargetTable(Dataset var1, Partition var2, Output.WriteMode var3) throws Exception;

    /*
     * WARNING - void declaration
     */
    @Override
    public void init() throws Exception {
        if (this.abortNotified) {
            throw new ActivityAbortedException();
        }
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        HiveSQLDialect dialect = new HiveSQLDialect();
        HiveSettings hiveSettings = new ClusterSelector().selectForProject(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey()).getHiveSettings();
        this.queryBunch = this.getQueryBunch(dialect);
        ArrayList<Object> additionalPreQueries = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)hiveSettings.initQueryPreStatements)) {
            void var7_9;
            String[] stringArray = dialect.getSplitter().split(hiveSettings.initQueryPreStatements);
            int n = stringArray.length;
            boolean bl = false;
            while (var7_9 < n) {
                String sql2 = stringArray[var7_9];
                additionalPreQueries.add(sql2);
                ++var7_9;
            }
        }
        MapredCompressionSetter compressionSetter = new MapredCompressionSetter();
        for (FlowDataset flowDataset : this.subgraph.getTargetsDatasets()) {
            compressionSetter.inspectOutputDataset(flowDataset.getMandatory(this.datasetsDAO));
        }
        if (hiveSettings.addCompressionCommands) {
            for (String string : dialect.getSplitter().split(compressionSetter.getCompressionCommands(false))) {
                additionalPreQueries.add(string);
            }
        }
        if (StringUtils.isNotBlank((String)hiveSettings.initQueryPostStatements)) {
            for (String string : dialect.getSplitter().split(hiveSettings.initQueryPostStatements)) {
                additionalPreQueries.add(string);
            }
        }
        Collections.reverse(additionalPreQueries);
        for (String string : additionalPreQueries) {
            this.queryBunch.preQueries.add(0, string);
        }
        Pattern addJarPattern = Pattern.compile("^\\s*add\\s+jar\\s+.*$", 2);
        this.queryBunch.optionalPreQueries = this.queryBunch.optionalPreQueries.stream().filter(sql -> !addJarPattern.matcher((CharSequence)sql).matches()).collect(Collectors.toList());
        this.queryBunch.preQueries = this.queryBunch.preQueries.stream().filter(sql -> !addJarPattern.matcher((CharSequence)sql).matches()).collect(Collectors.toList());
        this.queryBunch.optionalPreQueries = this.queryBunch.optionalPreQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipe.getProjectKey(), this.subgraph, q, dialect, false)).collect(Collectors.toList());
        this.queryBunch.preQueries = this.queryBunch.preQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipe.getProjectKey(), this.subgraph, q, dialect, false)).collect(Collectors.toList());
        this.queryBunch.postQueries = this.queryBunch.postQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipe.getProjectKey(), this.subgraph, q, dialect, false)).collect(Collectors.toList());
        this.queryBunch.query = SQLQueryRecipeUtils.substituteAllAndStripComments(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), this.subgraph, this.queryBunch.query, new ImpalaSQLDialect(), false);
    }

    @Override
    public void run() throws Exception {
        DatasetHandler dh;
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        HiveSQLDialect dialect = new HiveSQLDialect();
        ArrayList<SimpleKeyValue> extraConf = new ArrayList<SimpleKeyValue>();
        for (FlowDataset fd : this.subgraph.getSourceDatasets()) {
            dh = DatasetHandlerFactory.build(authCtx, fd.getMandatory(this.datasetsDAO));
            try {
                if (!(dh instanceof HDFSDatasetHandler)) continue;
                extraConf.addAll(HiveScriptPreprocessor.getFSExtraConfForHiveserver2(((HDFSDatasetHandler)dh).getFSExtraConf()));
            }
            finally {
                if (dh == null) continue;
                dh.close();
            }
        }
        for (FlowDataset fd : this.subgraph.getTargetsDatasets()) {
            dh = DatasetHandlerFactory.build(authCtx, fd.getMandatory(this.datasetsDAO));
            try {
                if (!(dh instanceof HDFSDatasetHandler)) continue;
                extraConf.addAll(HiveScriptPreprocessor.getFSExtraConfForHiveserver2(((HDFSDatasetHandler)dh).getFSExtraConf()));
            }
            finally {
                if (dh == null) continue;
                dh.close();
            }
        }
        Output.WriteMode writeMode = this.recipe.getModel().getSingleOutput("main").getWriteMode();
        FlowDataset target = this.subgraph.getTargetsDatasets().get(0);
        Dataset targetDataset = target.getMandatory(this.datasetsDAO);
        Partition targetPartition = this.subgraph.getTargetPartition(this.subgraph.getTargets().get(0));
        this.initializeTargetTable(targetDataset, targetPartition, writeMode);
        HiveConnection connection = HiveConfigurator.configureConnectionForDatabase(authCtx, "default", extraConf, this.hiveServer2ConnectionPoolService);
        SQLConnectionProvider.SQLConnectionData connData = connection.getConnectionData_NT(authCtx, this.recipe.getProjectKey());
        try (SQLConnectionProvider.SQLConnectionWrapper conn = connData.buildConnection(authCtx, this.recipe.getProjectKey(), null, true);){
            Statement stmt;
            for (String query : this.queryBunch.optionalPreQueries) {
                try {
                    stmt = conn.createStatement();
                    try {
                        this.executeCancellableStatement(conn, stmt, query);
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Optional pre-query failed", (Throwable)e);
                }
            }
            for (String query : this.queryBunch.preQueries) {
                stmt = conn.createStatement();
                try {
                    this.executeCancellableStatement(conn, stmt, query);
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            try (Statement stmt2 = conn.createStatement();){
                this.executeCancellableStatement(conn, stmt2, this.queryBunch.query);
            }
            for (String query : this.queryBunch.postQueries) {
                stmt = conn.createStatement();
                try {
                    this.executeCancellableStatement(conn, stmt, query);
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
        }
    }
}

