/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.julia;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractJuliaRecipeRunner;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.util.AutoDelete;
import java.io.File;
import org.apache.log4j.Logger;

public class JuliaRecipeRunner
extends AbstractJuliaRecipeRunner
implements RecipeRunnerWithPayload {
    private String code;
    private static Logger logger = Logger.getLogger((String)"dku.flow.julia");

    public JuliaRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        this.code = payload;
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }

    @Override
    public void run() throws Exception {
        try (AutoDelete recipeTmpDir = FlowJobUtils.getTmpFolder("julia-recipe", "jlout");){
            if (this.code == null) {
                throw new Error("Could not find Julia script for " + this.recipe.getName());
            }
            this.activity.setStatusMessage("Executing Julia script");
            logger.info((Object)"Starting execution of user's Julia code");
            this.executeScript((File)recipeTmpDir, this.code, "");
        }
        logger.info((Object)"Execution of user's Julia code complete");
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }
}

