/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sparksql;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.spark.SparkCodes;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SparkK8SDriverLogParser
implements DKUtils.LineSubscription {
    private InfoMessage.MessageCode probableFatalFailure;
    private String fatalLine;
    private final Pattern errorWhileCallingSavePyDataFrame = Pattern.compile("Py4JJavaError.*An error occurred while calling o.*savePyDataFrame");
    private boolean previousLineWasErrorWhileCallingSavePyDataFrame;
    private final Pattern readNonDistributed = Pattern.compile("WARN.*get[A-Za-z0-9._]* ([A-Za-z0-9._-]*):.*Reading.*as\\s*a?\\s*remote.*Computation will not be distributed: (.*)$");
    private final Pattern writeNonDistributed = Pattern.compile("WARN.*saveDataFrame[A-Za-z0-9._]* ([A-Za-z0-9._-]*):.*Writing.*as\\s*a?\\s*remote.*Computation will not be distributed: (.*)$");
    private final Pattern taskOOM = Pattern.compile("Lost task.*java.lang.OutOfMemoryError");
    private final Pattern jobFailedDueToTaskOOM = Pattern.compile("Job aborted due to stage failure.*Lost task.*java.lang.OutOfMemoryError");
    private final Pattern containerTerminatedDueToOOM = Pattern.compile("termination reason: OOMKilled", 2);
    private final Pattern outstandingBlocksFetchException = Pattern.compile("Exception while beginning fetch of .* outstanding blocks");
    private final Pattern connectTimeoutException = Pattern.compile("java.io.IOException: Connecting to (.*) timed out \\([0-9]+ ms\\)");
    private boolean previousLineIsOutstandingBlocksFetchException = false;
    private boolean lowOnEphemeralStorageSeen = false;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.spark.k8s");

    public Pattern getReadNonDistributed() {
        return this.readNonDistributed;
    }

    public Pattern getWriteNonDistributed() {
        return this.writeNonDistributed;
    }

    public synchronized void handle(String line, boolean replace) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Parsing driver log line: " + line));
        }
        if (StringUtils.isBlank((String)line)) {
            return;
        }
        if (this.previousLineWasErrorWhileCallingSavePyDataFrame) {
            logger.debugV("Checking line after the savePyDataFrame failure in log: %s", new Object[]{line});
            if (line.contains("OutOfMemoryError")) {
                this.probableFatalFailure = SparkCodes.ERR_SPARK_FAILED_DRIVER_OOM;
                this.fatalLine = line;
            }
            this.previousLineWasErrorWhileCallingSavePyDataFrame = false;
        }
        if (this.errorWhileCallingSavePyDataFrame.matcher(line).find()) {
            logger.debugV("Found savePyDataFrame failure in log: %s", new Object[]{line});
            this.previousLineWasErrorWhileCallingSavePyDataFrame = true;
        }
        if (this.jobFailedDueToTaskOOM.matcher(line).find()) {
            logger.debugV("Found task OOM in log: %s", new Object[]{line});
            this.fatalLine = line;
            this.probableFatalFailure = SparkCodes.ERR_SPARK_FAILED_TASK_OOM;
        }
        if (this.containerTerminatedDueToOOM.matcher(line).find()) {
            logger.debugV("Found container OOM in log: %s", new Object[]{line});
            this.fatalLine = line;
            this.probableFatalFailure = SparkCodes.ERR_SPARK_FAILED_CONTAINER_OOM;
        }
        if (this.taskOOM.matcher(line).find()) {
            logger.warn((Object)(SparkCodes.WARN_SPARK_TASK_OOM.getCode() + " : " + SparkCodes.WARN_SPARK_TASK_OOM.getCodeTitle()));
            JobContext.getCurrentActivityObj().getStatus().messages.withWarningV((InfoMessage.MessageCode)SparkCodes.WARN_SPARK_TASK_OOM, line, new Object[0]);
        }
        if (!this.lowOnEphemeralStorageSeen && line.contains("The node was low on resource: ephemeral-storage")) {
            logger.warn((Object)(SparkCodes.WARN_SPARK_TASK_DISKFULL.getCode() + " : " + SparkCodes.WARN_SPARK_TASK_DISKFULL.getCodeTitle()));
            JobContext.getCurrentActivityObj().getStatus().messages.withWarningV((InfoMessage.MessageCode)SparkCodes.WARN_SPARK_TASK_DISKFULL, line, new Object[0]);
            this.lowOnEphemeralStorageSeen = true;
        }
        if (this.previousLineIsOutstandingBlocksFetchException && this.connectTimeoutException.matcher(line).find()) {
            logger.warn((Object)(SparkCodes.WARN_SPARK_MISSING_DRIVER_TO_EXECUTOR_CONNECTIVITY.getCode() + " : " + SparkCodes.WARN_SPARK_MISSING_DRIVER_TO_EXECUTOR_CONNECTIVITY.getCodeTitle()));
            JobContext.getCurrentActivityObj().getStatus().messages.withWarningV((InfoMessage.MessageCode)SparkCodes.WARN_SPARK_MISSING_DRIVER_TO_EXECUTOR_CONNECTIVITY, line, new Object[0]);
        }
        this.previousLineIsOutstandingBlocksFetchException = this.outstandingBlocksFetchException.matcher(line).find();
        Matcher m = this.readNonDistributed.matcher(line);
        if (m.find()) {
            logger.warn((Object)("Found read non distributed in driver log, dataset= " + m.group(1) + " reason=" + m.group(2)));
            JobContext.getCurrentActivityObj().getStatus().messages.withWarningV((InfoMessage.MessageCode)SparkCodes.WARN_SPARK_NON_DISTRIBUTED_READ, "Dataset %s, cause: %s", new Object[]{m.group(1), m.group(2)});
        }
        if ((m = this.writeNonDistributed.matcher(line)).find()) {
            logger.warn((Object)("Found write non distributed in driver log, dataset= " + m.group(1) + " reason=" + m.group(2)));
            JobContext.getCurrentActivityObj().getStatus().messages.withWarningV((InfoMessage.MessageCode)SparkCodes.WARN_SPARK_NON_DISTRIBUTED_WRITE, "Dataset %s, cause: %s", new Object[]{m.group(1), m.group(2)});
        }
    }

    public boolean hasSomethingInterestingToSay() {
        logger.info((Object)("Driver parser log found probable failure: " + String.valueOf(this.probableFatalFailure)));
        return this.probableFatalFailure != null;
    }

    public CodedIOException getInterestingException() {
        return new CodedIOException(this.probableFatalFailure, this.fatalLine);
    }

    public void close() throws IOException {
    }
}

