/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;

public abstract class SISORecipeCreator
extends SingleOutputDatasetRecipeCreator {
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.siso.creator");

    public SISORecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data, Dataset outputDataset) throws Exception {
        Object input = this.getInputDatasetOrStreamingEndpoint(recipe);
        if (input instanceof StreamingEndpoint) {
            return this.makeInitialPayload(recipe, (StreamingEndpoint)input, outputDataset, data);
        }
        return this.makeInitialPayload(recipe, (Dataset)input, outputDataset, data);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data, StreamingEndpoint outputStreamingEndpoint) throws Exception {
        Object input = this.getInputDatasetOrStreamingEndpoint(recipe);
        if (input instanceof StreamingEndpoint) {
            return this.makeInitialPayload(recipe, (StreamingEndpoint)input, outputStreamingEndpoint, data);
        }
        return this.makeInitialPayload(recipe, (Dataset)input, outputStreamingEndpoint, data);
    }

    protected abstract String makeInitialPayload(SerializedRecipe var1, Dataset var2, Dataset var3, JsonObject var4);

    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, StreamingEndpoint outputStreamingEndpoint, JsonObject data) {
        throw new UnsupportedOperationException("Recipe doesn't work with streaming endpoints");
    }

    protected String makeInitialPayload(SerializedRecipe recipe, StreamingEndpoint inputStreamingEndpoint, Dataset outputDataset, JsonObject data) {
        throw new UnsupportedOperationException("Recipe doesn't work with streaming endpoints");
    }

    protected String makeInitialPayload(SerializedRecipe recipe, StreamingEndpoint inputStreamingEndpoint, StreamingEndpoint outputStreamingEndpoint, JsonObject data) {
        throw new UnsupportedOperationException("Recipe doesn't work with streaming endpoints");
    }

    protected Dataset getInputDataset(SerializedRecipe recipe) throws IOException {
        DatasetLocUtils.DatasetLoc inputLoc = this.getInputLoc(recipe);
        return this.datasetAccessService.getMandatory(inputLoc);
    }

    protected StreamingEndpoint getInputStreamingEndpoint(SerializedRecipe recipe) throws IOException {
        DatasetLocUtils.DatasetLoc inputLoc = this.getInputLoc(recipe);
        return (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(inputLoc);
    }

    protected Object getInputDatasetOrStreamingEndpoint(SerializedRecipe recipe) throws IOException {
        DatasetLocUtils.DatasetLoc inputLoc = this.getInputLoc(recipe);
        StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNull(inputLoc);
        if (se != null) {
            return se;
        }
        return this.datasetAccessService.getMandatory(inputLoc);
    }

    private DatasetLocUtils.DatasetLoc getInputLoc(SerializedRecipe recipe) {
        List<SerializedRecipe.RecipeInput> inputsForRole = recipe.getInputsForRole("main");
        if (inputsForRole.isEmpty()) {
            throw new IllegalArgumentException("Illegal inputs parameters for recipe: missing main role");
        }
        SerializedRecipe.RecipeInput input = inputsForRole.get(0);
        DatasetLocUtils.DatasetLoc inputLoc = DatasetLocUtils.resolveSmart(recipe.projectKey, input.ref);
        return inputLoc;
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, StreamingEndpoint outputStreamingEndpoint) throws Exception {
        throw new Error("Unreachable");
    }
}

