/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ShakerRecipeCreator
extends SingleOutputDatasetRecipeCreator {
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private ShakerRecipeService service;
    @Autowired
    private FlowZonesService flowZonesService;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.shaker.creator");

    public ShakerRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings settings = (SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings)JSON.parse((JsonElement)creationData, SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings.class);
        if (settings.outputDatasetSettings == null) {
            settings.outputDatasetSettings = new ManagedDatasetsCreationService.ManagedDatasetCreationSettings();
        }
        assert (StringUtils.isNotBlank((String)recipe.projectKey));
        assert (this.meta.getType().equals(recipe.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)recipe.name), (Object)"Recipe has no name");
        List<SerializedRecipe.RecipeInput> inputs = recipe.getInputsForRole("main");
        Preconditions.checkArgument((inputs.size() == 1 ? 1 : 0) != 0, (Object)(this.meta.getType() + " recipes require one input"));
        List<SerializedRecipe.RecipeOutput> outputs = recipe.getOutputsForRole("main");
        Preconditions.checkArgument((outputs.size() == 1 ? 1 : 0) != 0, (Object)(this.meta.getType() + " recipes require one output"));
        String outputDatasetName = outputs.get((int)0).ref;
        Dataset inputDataset = null;
        String inputDatasetSmartName = inputs.get((int)0).ref;
        DatasetExploreSettings exploreSettings = null;
        try (Transaction t = this.transactionService.beginRead();){
            DatasetLocUtils.DatasetLoc inputLoc = DatasetLocUtils.resolveSmart(recipe.projectKey, inputDatasetSmartName);
            inputDataset = this.datasetAccessService.getMandatory(inputLoc);
            exploreSettings = this.exploresService.get(recipe.projectKey, inputDatasetSmartName);
        }
        SerializedShakerScript script = new SerializedShakerScript();
        script.explorationSampling = (SerializedShakerScript.ShakerExplorationSampleSettings)JSON.deepCopy((Object)exploreSettings.script.explorationSampling);
        if (inputDataset != null && inputDataset.getSchema() != null) {
            for (SchemaColumn inputColumn : inputDataset.getSchema().columns) {
                if (inputColumn.getMeaning() == null) continue;
                SerializedShakerScript.AnalysisColumnData acd = new SerializedShakerScript.AnalysisColumnData();
                acd.meaning = inputColumn.getMeaning();
                acd.isColumnEdited = inputColumn.isColumnEdited;
                script.analysisColumnData.put(inputColumn.getName(), acd);
            }
        }
        this.checkOutputOwnership_NT(recipe);
        ShakerRecipeService.PreDeployed pd = this.service.prepareAddToFlow_NT(this.authCtx, inputDataset, script, recipe.projectKey, settings.createOutputDataset, outputDatasetName, settings.outputDatasetSettings, true);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            RecipeCreator.CreationResult result = this.service.executeAddToFlow(pd, settings.outputDatasetSettings.zone);
            this.updateOriginRecipes(recipe, creationData);
            t.commitV("Created %s recipe: %s", new Object[]{this.meta.getType(), recipe.getFullId()});
            RecipeCreator.CreationResult creationResult = result;
            return creationResult;
        }
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        Dataset oldDataset = this.datasetAccessService.getMandatory(recipe.getSingleOutput("main").getLoc(recipe.getProjectKey()));
        outputDataset.setSchema(new Schema(oldDataset.getSchema()));
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, StreamingEndpoint outputStreamingEndpoint) throws Exception {
        throw new Error("Unreachable");
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data, Dataset outputDataset) throws Exception {
        throw new Error("Unreachable");
    }
}

